/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.List;

public abstract class ScrollPickerView<T>
extends View {
    private int mVisibleItemCount = 3;
    private boolean mIsInertiaScroll = true;
    private boolean mIsCirculation = true;
    private boolean mDisallowInterceptTouch = false;
    private int mSelected;
    private List<T> mData;
    private int mItemHeight = 0;
    private int mCenterPosition = -1;
    private int mCenterY;
    private float mLastMoveY;
    private float mMoveLength = 0.0f;
    private GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlingOnGestureListener());
    private OnSelectedListener mListener;
    private Scroller mScroller = new Scroller(this.getContext());
    private boolean mIsFling;
    private boolean mIsMovingCenter;
    private int mLastScrollY = 0;
    private boolean mDisallowTouch = false;
    private Paint mPaint;
    private int mCenterItemBackground = 0;
    private long mTouchDownTime;
    private boolean mCanTap = true;
    private boolean mIsAutoScrolling = false;
    private ValueAnimator mAutoScrollAnimator = ValueAnimator.ofInt((int[])new int[]{0, 0});
    private static final SlotInterpolator sAutoScrollInterpolator = new SlotInterpolator();

    public ScrollPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mData == null || this.mData.size() <= 0) {
            return;
        }
        this.mPaint.setColor(this.mCenterItemBackground);
        float y = this.mCenterY;
        canvas.drawRect(0.0f, y, (float)this.getWidth(), y + (float)this.mItemHeight, this.mPaint);
        this.drawItem(canvas, this.mData, this.mSelected, 0, this.mMoveLength, (float)this.mCenterY + this.mMoveLength);
        int length = Math.max(this.mCenterPosition, this.mVisibleItemCount - this.mCenterPosition);
        for (int i = 1; i <= length && i <= this.mData.size(); ++i) {
            int positon;
            if (i <= this.mCenterPosition + 1) {
                int n = positon = this.mSelected - i < 0 ? this.mData.size() + this.mSelected - i : this.mSelected - i;
                if (this.mIsCirculation) {
                    this.drawItem(canvas, this.mData, positon, -i, this.mMoveLength, (float)this.mCenterY + this.mMoveLength - (float)(i * this.mItemHeight));
                } else if (this.mSelected - i >= 0) {
                    this.drawItem(canvas, this.mData, positon, -i, this.mMoveLength, (float)this.mCenterY + this.mMoveLength - (float)(i * this.mItemHeight));
                }
            }
            if (i > this.mVisibleItemCount - this.mCenterPosition) continue;
            int n = positon = this.mSelected + i >= this.mData.size() ? this.mSelected + i - this.mData.size() : this.mSelected + i;
            if (this.mIsCirculation) {
                this.drawItem(canvas, this.mData, positon, i, this.mMoveLength, (float)this.mCenterY + this.mMoveLength + (float)(i * this.mItemHeight));
                continue;
            }
            if (this.mSelected + i >= this.mData.size()) continue;
            this.drawItem(canvas, this.mData, positon, i, this.mMoveLength, (float)this.mCenterY + this.mMoveLength + (float)(i * this.mItemHeight));
        }
    }

    public abstract void drawItem(Canvas var1, List<T> var2, int var3, int var4, float var5, float var6);

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.reset();
    }

    private void reset() {
        this.mItemHeight = this.getMeasuredHeight() / this.mVisibleItemCount;
        if (this.mCenterPosition < 0) {
            this.mCenterPosition = this.mVisibleItemCount / 2;
        }
        this.mCenterY = this.mCenterPosition * this.mItemHeight;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDisallowTouch) {
            return true;
        }
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        switch (event.getActionMasked()) {
            case 2: {
                if (Math.abs(event.getY() - this.mLastMoveY) < 0.1f) {
                    return true;
                }
                this.mMoveLength += event.getY() - this.mLastMoveY;
                this.mLastMoveY = event.getY();
                this.checkCirculation();
                this.invalidate();
                break;
            }
            case 1: {
                this.mLastMoveY = event.getY();
                this.moveToCenter();
            }
        }
        return true;
    }

    private void computeScroll(int currY, int endY) {
        if (currY != endY) {
            this.mMoveLength = this.mMoveLength + (float)currY - (float)this.mLastScrollY;
            this.mLastScrollY = currY;
            this.checkCirculation();
            this.invalidate();
        } else {
            this.mIsMovingCenter = false;
            this.mLastScrollY = 0;
            this.mMoveLength = this.mMoveLength > 0.0f ? (this.mMoveLength < (float)(this.mItemHeight / 2) ? 0.0f : (float)this.mItemHeight) : (-this.mMoveLength < (float)(this.mItemHeight / 2) ? 0.0f : (float)(-this.mItemHeight));
            this.checkCirculation();
            this.mMoveLength = 0.0f;
            this.mLastScrollY = 0;
            this.notifySelected();
            this.invalidate();
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.mMoveLength = this.mMoveLength + (float)this.mScroller.getCurrY() - (float)this.mLastScrollY;
            this.mLastScrollY = this.mScroller.getCurrY();
            this.checkCirculation();
            this.invalidate();
        } else if (this.mIsFling) {
            this.mIsFling = false;
            this.moveToCenter();
        } else if (this.mIsMovingCenter) {
            this.mMoveLength = 0.0f;
            this.mIsMovingCenter = false;
            this.mLastScrollY = 0;
            this.notifySelected();
        }
    }

    public void cancelScroll() {
        this.mLastScrollY = 0;
        this.mIsMovingCenter = false;
        this.mIsFling = false;
        this.mScroller.abortAnimation();
        this.stopAutoScroll();
    }

    private void checkCirculation() {
        if (this.mMoveLength >= (float)this.mItemHeight) {
            int span = (int)(this.mMoveLength / (float)this.mItemHeight);
            this.mSelected -= span;
            if (this.mSelected < 0) {
                if (this.mIsCirculation) {
                    do {
                        this.mSelected = this.mData.size() + this.mSelected;
                    } while (this.mSelected < 0);
                    this.mMoveLength = (this.mMoveLength - (float)this.mItemHeight) % (float)this.mItemHeight;
                } else {
                    this.mSelected = 0;
                    this.mMoveLength = this.mItemHeight;
                    if (this.mIsFling) {
                        this.mScroller.forceFinished(true);
                    }
                    if (this.mIsMovingCenter) {
                        this.scroll(this.mMoveLength, 0);
                    }
                }
            } else {
                this.mMoveLength = (this.mMoveLength - (float)this.mItemHeight) % (float)this.mItemHeight;
            }
        } else if (this.mMoveLength <= (float)(-this.mItemHeight)) {
            int span = (int)(-this.mMoveLength / (float)this.mItemHeight);
            this.mSelected += span;
            if (this.mSelected >= this.mData.size()) {
                if (this.mIsCirculation) {
                    do {
                        this.mSelected -= this.mData.size();
                    } while (this.mSelected >= this.mData.size());
                    this.mMoveLength = (this.mMoveLength + (float)this.mItemHeight) % (float)this.mItemHeight;
                } else {
                    this.mSelected = this.mData.size() - 1;
                    this.mMoveLength = -this.mItemHeight;
                    if (this.mIsFling) {
                        this.mScroller.forceFinished(true);
                    }
                    if (this.mIsMovingCenter) {
                        this.scroll(this.mMoveLength, 0);
                    }
                }
            } else {
                this.mMoveLength = (this.mMoveLength + (float)this.mItemHeight) % (float)this.mItemHeight;
            }
        }
    }

    private void moveToCenter() {
        if (!this.mScroller.isFinished() || this.mIsFling) {
            return;
        }
        this.cancelScroll();
        if (this.mMoveLength > 0.0f) {
            if (this.mMoveLength < (float)(this.mItemHeight / 2)) {
                this.scroll(this.mMoveLength, 0);
            } else {
                this.scroll(this.mMoveLength, this.mItemHeight);
            }
        } else if (-this.mMoveLength < (float)(this.mItemHeight / 2)) {
            this.scroll(this.mMoveLength, 0);
        } else {
            this.scroll(this.mMoveLength, -this.mItemHeight);
        }
    }

    private void scroll(float from, int to) {
        this.mLastScrollY = (int)from;
        this.mIsMovingCenter = true;
        this.mScroller.startScroll(0, (int)from, 0, 0);
        this.mScroller.setFinalY(to);
        this.invalidate();
    }

    private void fling(float from, float vY) {
        this.mLastScrollY = (int)from;
        this.mIsFling = true;
        this.mScroller.fling(0, (int)from, 0, (int)vY, 0, 0, -10 * this.mItemHeight, 10 * this.mItemHeight);
        this.invalidate();
    }

    private void notifySelected() {
        if (this.mListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ScrollPickerView.this.mListener.onSelected(ScrollPickerView.this, ScrollPickerView.this.mSelected);
                }
            });
        }
    }

    public void autoScrollFast(int position, long duration, float speed, Interpolator interpolator) {
        if (this.mIsAutoScrolling || !this.mIsCirculation) {
            return;
        }
        this.cancelScroll();
        this.mIsAutoScrolling = true;
        int length = (int)(speed * (float)duration);
        int circle = (int)((float)length * 1.0f / (float)(this.mData.size() * this.mItemHeight) + 0.5f);
        circle = circle <= 0 ? 1 : circle;
        int aPlan = circle * this.mData.size() * this.mItemHeight + (this.mSelected - position) * this.mItemHeight;
        int bPlan = aPlan + this.mData.size() * this.mItemHeight;
        final int endY = Math.abs(length - aPlan) < Math.abs(length - bPlan) ? aPlan : bPlan;
        this.mAutoScrollAnimator.cancel();
        this.mAutoScrollAnimator.setIntValues(new int[]{0, endY});
        this.mAutoScrollAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mAutoScrollAnimator.setDuration(duration);
        this.mAutoScrollAnimator.removeAllUpdateListeners();
        this.mAutoScrollAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ScrollPickerView.this.computeScroll((Integer)animation.getAnimatedValue(), endY);
                float rate = 0.0f;
                rate = Build.VERSION.SDK_INT >= 12 ? animation.getAnimatedFraction() : (float)animation.getCurrentPlayTime() * 1.0f / (float)animation.getDuration();
                if (rate >= 1.0f) {
                    ScrollPickerView.this.mIsAutoScrolling = false;
                }
            }
        });
        this.mAutoScrollAnimator.start();
    }

    public void autoScrollFast(int position, long duration) {
        float speed = this.dip2px(0.4f);
        this.autoScrollFast(position, duration, speed, sAutoScrollInterpolator);
    }

    public void autoScrollFast(int position, long duration, float speed) {
        this.autoScrollFast(position, duration, speed, sAutoScrollInterpolator);
    }

    public void autoScrollToPosition(int toPosition, long duration, Interpolator interpolator) {
        int endY = (this.mSelected - (toPosition %= this.mData.size())) * this.mItemHeight;
        this.autoScrollTo(endY, duration, interpolator, false);
    }

    public void autoScrollTo(final int endY, long duration, Interpolator interpolator, boolean canIntercept) {
        if (this.mIsAutoScrolling) {
            return;
        }
        final boolean temp = this.mDisallowTouch;
        this.mDisallowTouch = !canIntercept;
        this.mIsAutoScrolling = true;
        this.mAutoScrollAnimator.cancel();
        this.mAutoScrollAnimator.setIntValues(new int[]{0, endY});
        this.mAutoScrollAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mAutoScrollAnimator.setDuration(duration);
        this.mAutoScrollAnimator.removeAllUpdateListeners();
        this.mAutoScrollAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ScrollPickerView.this.computeScroll((Integer)animation.getAnimatedValue(), endY);
                float rate = 0.0f;
                rate = Build.VERSION.SDK_INT >= 12 ? animation.getAnimatedFraction() : (float)animation.getCurrentPlayTime() * 1.0f / (float)animation.getDuration();
                if (rate >= 1.0f) {
                    ScrollPickerView.this.mIsAutoScrolling = false;
                    ScrollPickerView.this.mDisallowTouch = temp;
                }
            }
        });
        this.mAutoScrollAnimator.start();
    }

    public void stopAutoScroll() {
        this.mIsAutoScrolling = false;
        this.mAutoScrollAnimator.cancel();
    }

    public List<T> getData() {
        return this.mData;
    }

    public void setData(List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : data;
        this.mSelected = this.mData.size() / 2;
        this.invalidate();
    }

    public T getSelectedItem() {
        return this.mData.get(this.mSelected);
    }

    public void setSelectedPosition(int position) {
        if (position < 0 || position > this.mData.size() - 1 || position == this.mSelected) {
            return;
        }
        this.mSelected = position;
        this.invalidate();
        if (this.mListener != null) {
            this.notifySelected();
        }
    }

    public void setOnSelectedListener(OnSelectedListener listener) {
        this.mListener = listener;
    }

    public OnSelectedListener getListener() {
        return this.mListener;
    }

    public boolean isInertiaScroll() {
        return this.mIsInertiaScroll;
    }

    public void setInertiaScroll(boolean inertiaScroll) {
        this.mIsInertiaScroll = inertiaScroll;
    }

    public boolean isIsCirculation() {
        return this.mIsCirculation;
    }

    public void setIsCirculation(boolean isCirculation) {
        this.mIsCirculation = isCirculation;
    }

    public boolean isDisallowInterceptTouch() {
        return this.mDisallowInterceptTouch;
    }

    public int getVisibleItemCount() {
        return this.mVisibleItemCount;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.mVisibleItemCount = visibleItemCount;
        this.reset();
        this.invalidate();
    }

    public void setDisallowInterceptTouch(boolean disallowInterceptTouch) {
        this.mDisallowInterceptTouch = disallowInterceptTouch;
    }

    public int getItemHeight() {
        return this.mItemHeight;
    }

    public boolean isDisallowTouch() {
        return this.mDisallowTouch;
    }

    public void setDisallowTouch(boolean disallowTouch) {
        this.mDisallowTouch = disallowTouch;
    }

    public void setCenterPosition(int centerPosition) {
        this.mCenterPosition = this.mCenterPosition < 0 ? 0 : (this.mCenterPosition > this.mVisibleItemCount ? this.mVisibleItemCount : centerPosition);
        this.mCenterY = this.mCenterPosition * this.mItemHeight;
        this.invalidate();
    }

    public int getCenterPosition() {
        return this.mCenterPosition;
    }

    public void setCenterItemBackground(int centerItemBackground) {
        this.mCenterItemBackground = centerItemBackground;
        this.invalidate();
    }

    public int getCenterItemBackground() {
        return this.mCenterItemBackground;
    }

    public boolean isCanTap() {
        return this.mCanTap;
    }

    public void setCanTap(boolean canTap) {
        this.mCanTap = canTap;
    }

    public int dip2px(float dipVlue) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        float sDensity = metrics.density;
        return (int)(dipVlue * sDensity + 0.5f);
    }

    public static interface OnSelectedListener {
        public void onSelected(ScrollPickerView var1, int var2);
    }

    private class FlingOnGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private FlingOnGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            ViewParent parent;
            ScrollPickerView.this.mTouchDownTime = System.currentTimeMillis();
            if (ScrollPickerView.this.mDisallowInterceptTouch && (parent = ScrollPickerView.this.getParent()) != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            ScrollPickerView.this.cancelScroll();
            ScrollPickerView.this.mLastMoveY = e.getY();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (ScrollPickerView.this.mIsInertiaScroll) {
                ScrollPickerView.this.cancelScroll();
                ScrollPickerView.this.fling(ScrollPickerView.this.mMoveLength, velocityY);
            }
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (!ScrollPickerView.this.mCanTap || ScrollPickerView.this.mMoveLength != 0.0f || ScrollPickerView.this.mLastScrollY != 0) {
                return false;
            }
            ScrollPickerView.this.mLastMoveY = e.getY();
            if (ScrollPickerView.this.mLastMoveY >= (float)ScrollPickerView.this.mCenterY && ScrollPickerView.this.mLastMoveY <= (float)(ScrollPickerView.this.mCenterY + ScrollPickerView.this.mItemHeight)) {
                ScrollPickerView.this.performClick();
            } else if (ScrollPickerView.this.mLastMoveY < (float)ScrollPickerView.this.mCenterY) {
                int moveY = ScrollPickerView.this.mItemHeight;
                ScrollPickerView.this.autoScrollTo(moveY, 150L, sAutoScrollInterpolator, false);
            } else if (ScrollPickerView.this.mLastMoveY > (float)(ScrollPickerView.this.mCenterY + ScrollPickerView.this.mItemHeight)) {
                int moveY = -ScrollPickerView.this.mItemHeight;
                ScrollPickerView.this.autoScrollTo(moveY, 150L, sAutoScrollInterpolator, false);
            } else {
                ScrollPickerView.this.moveToCenter();
            }
            return true;
        }
    }

    private static class SlotInterpolator
    implements Interpolator {
        private SlotInterpolator() {
        }

        public float getInterpolation(float input) {
            return (float)(Math.cos((double)(input + 1.0f) * Math.PI) / 2.0) + 0.5f;
        }
    }
}

