/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.provider.MediaStore;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import cn.forward.androids.utils.ReflectUtil;
import cn.forward.androids.utils.Util;
import java.io.File;
import java.io.IOException;

public class ImageUtils {
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private static final Uri STORAGE_URI = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;

    public static Uri addImage(ContentResolver cr, String path) {
        File file = new File(path);
        String name = file.getName();
        int i = name.lastIndexOf(".");
        String title = name.substring(0, i);
        String filename = title + name.substring(i);
        int[] degree = new int[1];
        return ImageUtils.addImage(cr, title, System.currentTimeMillis(), null, file.getParent(), filename, degree);
    }

    private static Uri addImage(ContentResolver cr, String title, long dateTaken, Location location, String directory, String filename, int[] degree) {
        File file = new File(directory, filename);
        long size = file.length();
        ContentValues values = new ContentValues(9);
        values.put("title", title);
        values.put("_display_name", filename);
        values.put("datetaken", Long.valueOf(dateTaken));
        values.put("mime_type", "image/jpeg");
        values.put("orientation", Integer.valueOf(degree[0]));
        values.put("_data", file.getAbsolutePath());
        values.put("_size", Long.valueOf(size));
        if (location != null) {
            values.put("latitude", Double.valueOf(location.getLatitude()));
            values.put("longitude", Double.valueOf(location.getLongitude()));
        }
        return cr.insert(STORAGE_URI, values);
    }

    public static Uri addVideo(ContentResolver cr, String title, long dateTaken, Location location, String directory, String filename) {
        String filePath = directory + "/" + filename;
        try {
            File dir = new File(directory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(directory, filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long size = new File(directory, filename).length();
        ContentValues values = new ContentValues(9);
        values.put("title", title);
        values.put("_display_name", filename);
        values.put("datetaken", Long.valueOf(dateTaken));
        values.put("mime_type", "video/3gpp");
        values.put("_data", filePath);
        values.put("_size", Long.valueOf(size));
        if (location != null) {
            values.put("latitude", Double.valueOf(location.getLatitude()));
            values.put("longitude", Double.valueOf(location.getLongitude()));
        }
        return cr.insert(STORAGE_URI, values);
    }

    public static Bitmap rotate(Bitmap bitmap, int degree, boolean isRecycle) {
        Matrix m = new Matrix();
        m.setRotate((float)degree, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
        try {
            Bitmap bm1 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
            if (isRecycle) {
                bitmap.recycle();
            }
            return bm1;
        }
        catch (OutOfMemoryError ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getBitmapExifRotate(String path) {
        int degree = 0;
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        if (exif != null) {
            int ori = exif.getAttributeInt("Orientation", 0);
            switch (ori) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
                default: {
                    degree = 0;
                }
            }
        }
        return degree;
    }

    public static Bitmap rotateBitmapByExif(Bitmap bitmap, String path, boolean isRecycle) {
        int digree = ImageUtils.getBitmapExifRotate(path);
        if (digree != 0) {
            bitmap = ImageUtils.rotate(bitmap, digree, isRecycle);
        }
        return bitmap;
    }

    public static final Bitmap createBitmapFromPath(String path, Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        int screenW = display.getWidth();
        int screenH = display.getHeight();
        return ImageUtils.createBitmapFromPath(path, screenW, screenH);
    }

    public static final Bitmap createBitmapFromPath(String path, int maxWidth, int maxHeight) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = null;
        if (path.endsWith(".3gp")) {
            return ThumbnailUtils.createVideoThumbnail((String)path, (int)1);
        }
        try {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            int width = options.outWidth;
            int height = options.outHeight;
            options.inSampleSize = ImageUtils.computeBitmapSimple(width * height, maxWidth * maxHeight * 2);
            options.inPurgeable = true;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inDither = false;
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            return ImageUtils.rotateBitmapByExif(bitmap, path, true);
        }
        catch (OutOfMemoryError error) {
            options.inSampleSize *= 2;
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            return ImageUtils.rotateBitmapByExif(bitmap, path, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final Bitmap createBitmapFromPath(byte[] data, int maxWidth, int maxHeight) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = null;
        try {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            int width = options.outWidth;
            int height = options.outHeight;
            options.inSampleSize = ImageUtils.computeBitmapSimple(width * height, maxWidth * maxHeight * 2);
            options.inPurgeable = true;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inDither = false;
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (OutOfMemoryError error) {
            options.inSampleSize *= 2;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int computeBitmapSimple(int realPixels, int maxPixels) {
        if (maxPixels <= 0) {
            return 1;
        }
        try {
            if (realPixels <= maxPixels) {
                return 1;
            }
            int scale = 2;
            while (realPixels / (scale * scale) > maxPixels) {
                scale *= 2;
            }
            return scale;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int[] optimizeMaxSizeByView(View view, int maxImageWidth, int maxImageHeight) {
        int width = maxImageWidth;
        int height = maxImageHeight;
        if (width > 0 && height > 0) {
            return new int[]{width, height};
        }
        if (view != null) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params != null) {
                if (params.width > 0) {
                    width = params.width;
                } else if (params.width != -2) {
                    width = view.getWidth();
                }
                if (params.height > 0) {
                    height = params.height;
                } else if (params.height != -2) {
                    height = view.getHeight();
                }
            }
            if (view instanceof ImageView) {
                int tempHeight;
                int tempWidth;
                Object obj;
                if (width <= 0 && (obj = ReflectUtil.getValue(view, "mMaxWidth")) != null && (tempWidth = ((Integer)obj).intValue()) > 0 && tempWidth < Integer.MAX_VALUE) {
                    width = tempWidth;
                }
                if (height <= 0 && (obj = ReflectUtil.getValue(view, "mMaxHeight")) != null && (tempHeight = ((Integer)obj).intValue()) > 0 && tempHeight < Integer.MAX_VALUE) {
                    height = tempHeight;
                }
            }
        }
        if (width <= 0) {
            width = Util.getScreenWidth(view.getContext());
        }
        if (height <= 0) {
            height = Util.getScreenHeight(view.getContext());
        }
        return new int[]{width, height};
    }
}

