/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import cn.forward.androids.R;

public class PaddingViewAttrs {
    @SuppressLint(value={"ResourceType"})
    public static void obtainsAttrs(Context context, View view, AttributeSet attrs) {
        int paddingTop;
        int paddingLeft;
        int[] systemAttrs = new int[]{16842996, 16842997};
        TypedArray array = context.obtainStyledAttributes(attrs, systemAttrs);
        TypedValue typedValue = new TypedValue();
        array.getValue(0, typedValue);
        if (typedValue.type != 5) {
            return;
        }
        array.getValue(1, typedValue);
        if (typedValue.type != 5) {
            return;
        }
        int width = array.getDimensionPixelOffset(0, 0);
        int height = array.getDimensionPixelOffset(1, 0);
        array.recycle();
        if (width <= 0 || height <= 0) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PaddingViewAttrs);
        int mContentWidth = a.getDimensionPixelOffset(R.styleable.PaddingViewAttrs_vp_content_width, 0);
        int mContentHeight = a.getDimensionPixelOffset(R.styleable.PaddingViewAttrs_vp_content_height, 0);
        int mContentPaddingLeft = a.getDimensionPixelOffset(R.styleable.PaddingViewAttrs_vp_content_padding_left, -1);
        int mContentPaddingTop = a.getDimensionPixelOffset(R.styleable.PaddingViewAttrs_vp_content_padding_top, -1);
        int mContentPaddingRight = a.getDimensionPixelOffset(R.styleable.PaddingViewAttrs_vp_content_padding_right, -1);
        int mContentPaddingBottom = a.getDimensionPixelOffset(R.styleable.PaddingViewAttrs_vp_content_padding_bottom, -1);
        a.recycle();
        if (mContentWidth <= 0 || mContentHeight <= 0 || mContentWidth > width || mContentHeight > height) {
            return;
        }
        int paddingRight = paddingLeft = (int)((float)(width - mContentWidth) / 2.0f + 0.5f);
        int paddingBottom = paddingTop = (int)((float)(height - mContentHeight) / 2.0f + 0.5f);
        if (mContentPaddingLeft >= 0) {
            paddingRight = paddingRight + paddingLeft - mContentPaddingLeft;
            paddingLeft = mContentPaddingLeft;
        } else if (mContentPaddingRight >= 0) {
            paddingLeft = paddingLeft + paddingRight - mContentPaddingRight;
            paddingRight = mContentPaddingRight;
        }
        if (mContentPaddingTop >= 0) {
            paddingBottom = paddingBottom + paddingTop - mContentPaddingTop;
            paddingTop = mContentPaddingTop;
        } else if (mContentPaddingBottom >= 0) {
            paddingTop = paddingTop + paddingBottom - mContentPaddingBottom;
            paddingBottom = mContentPaddingBottom;
        }
        if (paddingLeft != view.getPaddingLeft() || paddingTop != view.getPaddingTop() || paddingRight != view.getPaddingRight() || paddingBottom != view.getPaddingBottom()) {
            view.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        }
    }
}

