/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import cn.forward.androids.utils.LogUtil;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AnimatorUtil {
    private static final TimeInterpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();

    public static AnimatorSetWrap createAnimator() {
        return new AnimatorSetWrap();
    }

    public static AnimatorSetWrap createAnimator(TimeInterpolator interpolator) {
        return new AnimatorSetWrap(interpolator);
    }

    public static boolean isVisibleOnScreen(View mView) {
        if (mView == null) {
            return false;
        }
        return mView.getWindowVisibility() == 0 && mView.getVisibility() == 0 && mView.isShown();
    }

    public static class AnimatorSetWrap {
        private View mView;
        public static final long DEFAULT_DURATION = 300L;
        private ArrayList<Animator> mAnimatorsThen = new ArrayList();
        private AnimatorSet mAnimatorSet = new AnimatorSet();
        private AnimatorSet.Builder mAnimatorSetBuilder;
        private TimeInterpolator mTimeInterpolator;
        private boolean mIsPlaying = false;
        private boolean mHasInitThenAnim = false;
        private int mRepeatCount = 0;
        private int mCurrentRepeat;
        private boolean mIsCanceled;
        private ScheduledExecutorService mRepeatSchedule;

        public AnimatorSetWrap() {
            this(sDefaultInterpolator);
        }

        public AnimatorSetWrap(TimeInterpolator interpolator) {
            this.mTimeInterpolator = interpolator;
        }

        public AnimatorSetWrap setRepeatCount(int count) {
            this.mRepeatCount = count;
            return this;
        }

        public int getRepeatCount() {
            return this.mRepeatCount;
        }

        public AnimatorSetWrap play(View view, String propertyName, float ... values) {
            return this.play(view, 300L, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap play(View view, long duration, String propertyName, float ... values) {
            return this.play(view, duration, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap play(View view, long duration, Animator.AnimatorListener listener, String propertyName, float ... values) {
            return this.play(view, duration, listener, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap play(View view, long duration, Animator.AnimatorListener listener, TimeInterpolator interpolator, String propertyName, float ... values) {
            if (this.mIsPlaying) {
                throw new RuntimeException("AnimatorSetWrap.play()\u65b9\u6cd5\u53ea\u80fd\u8c03\u7528\u4e00\u6b21");
            }
            if (view == null) {
                throw new RuntimeException("view \u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.mIsPlaying = true;
            this.mView = view;
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])values).setDuration(duration);
            animator.setInterpolator(interpolator);
            if (listener != null) {
                animator.addListener(listener);
            }
            this.mAnimatorsThen.clear();
            this.mAnimatorSetBuilder = this.mAnimatorSet.play((Animator)animator);
            return this;
        }

        public AnimatorSetWrap play(Animator animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSet.play(animator);
            return this;
        }

        public AnimatorSetWrap play(AnimatorSetWrap animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSet.play((Animator)animator.getAnimatorSet());
            return this;
        }

        public AnimatorSetWrap with(View view, String propertyName, float ... values) {
            return this.with(view, 300L, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap with(View view, long duration, String propertyName, float ... values) {
            return this.with(view, duration, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap with(View view, long duration, Animator.AnimatorListener listener, String propertyName, float ... values) {
            return this.with(view, duration, listener, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap with(View view, long duration, Animator.AnimatorListener listener, TimeInterpolator interpolator, String propertyName, float ... values) {
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])values).setDuration(duration);
            animator.setInterpolator(interpolator);
            if (listener != null) {
                animator.addListener(listener);
            }
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.with((Animator)animator);
            return this;
        }

        public AnimatorSetWrap with(Animator animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.with(animator);
            return this;
        }

        public AnimatorSetWrap with(AnimatorSetWrap animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.with((Animator)animator.getAnimatorSet());
            return this;
        }

        public AnimatorSetWrap before(View view, String propertyName, float ... values) {
            return this.before(view, 300L, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap before(View view, long duration, String propertyName, float ... values) {
            return this.before(view, duration, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap before(View view, long duration, Animator.AnimatorListener listener, String propertyName, float ... values) {
            return this.before(view, duration, listener, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap before(View view, long duration, Animator.AnimatorListener listener, TimeInterpolator interpolator, String propertyName, float ... values) {
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])values).setDuration(duration);
            animator.setInterpolator(interpolator);
            if (listener != null) {
                animator.addListener(listener);
            }
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.before((Animator)animator);
            return this;
        }

        public AnimatorSetWrap before(Animator animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.before(animator);
            return this;
        }

        public AnimatorSetWrap before(AnimatorSetWrap animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.before((Animator)animator.getAnimatorSet());
            return this;
        }

        public AnimatorSetWrap after(View view, String propertyName, float ... values) {
            return this.after(view, 300L, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap after(View view, long duration, String propertyName, float ... values) {
            return this.after(view, duration, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap after(View view, long duration, Animator.AnimatorListener listener, String propertyName, float ... values) {
            return this.after(view, duration, listener, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap after(View view, long duration, Animator.AnimatorListener listener, TimeInterpolator interpolator, String propertyName, float ... values) {
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])values).setDuration(duration);
            animator.setInterpolator(interpolator);
            if (listener != null) {
                animator.addListener(listener);
            }
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.after((Animator)animator);
            return this;
        }

        public AnimatorSetWrap after(Animator animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.after(animator);
            return this;
        }

        public AnimatorSetWrap after(AnimatorSetWrap animator) {
            this.mAnimatorSetBuilder = this.mAnimatorSetBuilder.after((Animator)animator.getAnimatorSet());
            return this;
        }

        public AnimatorSetWrap after(long delay) {
            this.mAnimatorSetBuilder.after(delay);
            return this;
        }

        public AnimatorSetWrap then(View view, String propertyName, float ... values) {
            return this.then(view, 300L, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap then(View view, long duration, String propertyName, float ... values) {
            return this.then(view, duration, null, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap then(View view, long duration, Animator.AnimatorListener listener, String propertyName, float ... values) {
            return this.then(view, duration, listener, this.mTimeInterpolator, propertyName, values);
        }

        public AnimatorSetWrap then(View view, long duration, Animator.AnimatorListener listener, TimeInterpolator interpolator, String propertyName, float ... values) {
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])values).setDuration(duration);
            animator.setInterpolator(interpolator);
            if (listener != null) {
                animator.addListener(listener);
            }
            this.then((Animator)animator);
            return this;
        }

        public AnimatorSetWrap then(Animator animator) {
            this.mAnimatorsThen.add(animator);
            return this;
        }

        public AnimatorSetWrap then(AnimatorSetWrap animator) {
            this.mAnimatorsThen.add((Animator)animator.getAnimatorSet());
            return this;
        }

        private void shutdownRepeat() {
            if (this.mRepeatSchedule != null) {
                try {
                    this.mRepeatSchedule.shutdownNow();
                    this.mRepeatSchedule = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleRepeat() {
            this.shutdownRepeat();
            this.mCurrentRepeat = 0;
            if (this.mRepeatCount == 0) {
                return;
            }
            this.mAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                long mStart;
                long mEnd;

                public void onAnimationStart(Animator animation) {
                    this.mStart = System.currentTimeMillis();
                }

                public void onAnimationEnd(Animator animation) {
                    this.mEnd = System.currentTimeMillis();
                    AnimatorSetWrap.this.mAnimatorSet.removeListener((Animator.AnimatorListener)this);
                    if (Build.VERSION.SDK_INT >= 12) {
                        AnimatorSetWrap.this.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                            public void onViewAttachedToWindow(View v) {
                            }

                            public void onViewDetachedFromWindow(View v) {
                                AnimatorSetWrap.this.cancel();
                            }
                        });
                    }
                    this.repeat();
                }

                private void repeat() {
                    if (AnimatorSetWrap.this.mView == null || AnimatorSetWrap.this.mIsCanceled) {
                        AnimatorSetWrap.this.shutdownRepeat();
                        return;
                    }
                    AnimatorSetWrap.this.mRepeatSchedule = Executors.newSingleThreadScheduledExecutor();
                    AnimatorSetWrap.this.mRepeatSchedule.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            LogUtil.d("hzw", "animator schedule");
                            if (AnimatorSetWrap.this.mIsCanceled) {
                                AnimatorSetWrap.this.shutdownRepeat();
                                return;
                            }
                            if (!AnimatorUtil.isVisibleOnScreen(AnimatorSetWrap.this.mView)) {
                                AnimatorSetWrap.this.shutdownRepeat();
                                AnimatorSetWrap.this.mView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                                    public boolean onPreDraw() {
                                        if (AnimatorUtil.isVisibleOnScreen(AnimatorSetWrap.this.mView)) {
                                            AnimatorSetWrap.this.mView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                            this.repeat();
                                        }
                                        return true;
                                    }
                                });
                                return;
                            }
                            AnimatorSetWrap.this.mView.post(new Runnable(){

                                @Override
                                public void run() {
                                    AnimatorSetWrap.this.mAnimatorSet.cancel();
                                    AnimatorSetWrap.this.mAnimatorSet.start();
                                }
                            });
                            if (AnimatorSetWrap.this.mRepeatCount > 0) {
                                AnimatorSetWrap.this.mCurrentRepeat++;
                                if (AnimatorSetWrap.this.mCurrentRepeat == AnimatorSetWrap.this.mRepeatCount) {
                                    AnimatorSetWrap.this.shutdownRepeat();
                                }
                            }
                        }
                    }, 0L, this.mEnd - this.mStart, TimeUnit.MILLISECONDS);
                }
            });
        }

        private void beforeStart() {
            this.mIsCanceled = false;
            this.handleRepeat();
            if (this.mHasInitThenAnim) {
                return;
            }
            this.mHasInitThenAnim = true;
            if (this.mAnimatorsThen.size() > 0) {
                AnimatorSet set = new AnimatorSet();
                set.playSequentially(this.mAnimatorsThen);
                this.mAnimatorSetBuilder.before((Animator)set);
            }
        }

        public void start() {
            this.beforeStart();
            this.mAnimatorSet.start();
        }

        public void start(long duration) {
            this.beforeStart();
            this.mAnimatorSet.setDuration(duration);
            this.mAnimatorSet.start();
        }

        public void startDelay(long delay) {
            this.beforeStart();
            this.mAnimatorSet.setStartDelay(delay);
            this.mAnimatorSet.start();
        }

        public void cancel() {
            this.mIsCanceled = true;
            this.shutdownRepeat();
            this.mAnimatorSet.cancel();
            this.mCurrentRepeat = Integer.MAX_VALUE;
        }

        private AnimatorSet getAnimatorSet() {
            return this.mAnimatorSet;
        }

        public AnimatorSetWrap setListener(Animator.AnimatorListener listener) {
            this.mAnimatorSet.addListener(listener);
            return this;
        }

        public ArrayList<Animator.AnimatorListener> getListeners() {
            return this.mAnimatorSet.getListeners();
        }

        public void removeListner(Animator.AnimatorListener listener) {
            this.mAnimatorSet.removeListener(listener);
        }

        public void removeAllListeners() {
            this.mAnimatorSet.removeAllListeners();
        }
    }
}

