/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import cn.forward.androids.R;
import cn.forward.androids.utils.ColorUtil;
import cn.forward.androids.views.ScrollPickerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringScrollPicker
extends ScrollPickerView<CharSequence> {
    private int mMeasureWidth;
    private int mMeasureHeight;
    private TextPaint mPaint;
    private int mMinTextSize = 24;
    private int mMaxTextSize = 32;
    private int mStartColor = -16777216;
    private int mEndColor = -7829368;
    private int mMaxLineWidth = -1;
    private Layout.Alignment mAlignment = Layout.Alignment.ALIGN_CENTER;

    public StringScrollPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StringScrollPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new TextPaint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-16777216);
        this.init(attrs);
        this.setData(new ArrayList<String>(Arrays.asList("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve")));
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.StringScrollPicker);
            this.mMinTextSize = typedArray.getDimensionPixelSize(R.styleable.StringScrollPicker_spv_min_text_size, this.mMinTextSize);
            this.mMaxTextSize = typedArray.getDimensionPixelSize(R.styleable.StringScrollPicker_spv_max_text_size, this.mMaxTextSize);
            this.mStartColor = typedArray.getColor(R.styleable.StringScrollPicker_spv_start_color, this.mStartColor);
            this.mEndColor = typedArray.getColor(R.styleable.StringScrollPicker_spv_end_color, this.mEndColor);
            this.mMaxLineWidth = typedArray.getDimensionPixelSize(R.styleable.StringScrollPicker_spv_max_line_width, this.mMaxLineWidth);
            int align = typedArray.getInt(R.styleable.StringScrollPicker_spv_alignment, 1);
            this.mAlignment = align == 2 ? Layout.Alignment.ALIGN_NORMAL : (align == 3 ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_CENTER);
            typedArray.recycle();
        }
    }

    public void setColor(int startColor, int endColor) {
        this.mStartColor = startColor;
        this.mEndColor = endColor;
        this.invalidate();
    }

    public void setTextSize(int minText, int maxText) {
        this.mMinTextSize = minText;
        this.mMaxTextSize = maxText;
        this.invalidate();
    }

    public int getStartColor() {
        return this.mStartColor;
    }

    public int getEndColor() {
        return this.mEndColor;
    }

    public int getMinTextSize() {
        return this.mMinTextSize;
    }

    public int getMaxTextSize() {
        return this.mMaxTextSize;
    }

    public int getMaxLineWidth() {
        return this.mMaxLineWidth;
    }

    public void setMaxLineWidth(int maxLineWidth) {
        this.mMaxLineWidth = maxLineWidth;
    }

    public Layout.Alignment getAlignment() {
        return this.mAlignment;
    }

    public void setAlignment(Layout.Alignment alignment) {
        this.mAlignment = alignment;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mMeasureWidth = this.getMeasuredWidth();
        this.mMeasureHeight = this.getMeasuredHeight();
        if (this.mMaxLineWidth < 0) {
            this.mMaxLineWidth = this.getItemWidth();
        }
    }

    @Override
    public void drawItem(Canvas canvas, List<CharSequence> data, int position, int relative, float moveLength, float top) {
        CharSequence text = data.get(position);
        int itemSize = this.getItemSize();
        if (relative == -1) {
            if (moveLength < 0.0f) {
                this.mPaint.setTextSize((float)this.mMinTextSize);
            } else {
                this.mPaint.setTextSize((float)this.mMinTextSize + (float)(this.mMaxTextSize - this.mMinTextSize) * moveLength / (float)itemSize);
            }
        } else if (relative == 0) {
            this.mPaint.setTextSize((float)this.mMinTextSize + (float)(this.mMaxTextSize - this.mMinTextSize) * ((float)itemSize - Math.abs(moveLength)) / (float)itemSize);
        } else if (relative == 1) {
            if (moveLength > 0.0f) {
                this.mPaint.setTextSize((float)this.mMinTextSize);
            } else {
                this.mPaint.setTextSize((float)this.mMinTextSize + (float)(this.mMaxTextSize - this.mMinTextSize) * -moveLength / (float)itemSize);
            }
        } else {
            this.mPaint.setTextSize((float)this.mMinTextSize);
        }
        StaticLayout layout = new StaticLayout(text, 0, text.length(), this.mPaint, this.mMaxLineWidth, this.mAlignment, 1.0f, 0.0f, true, null, 0);
        float x = 0.0f;
        float y = 0.0f;
        float lineWidth = layout.getWidth();
        if (this.isHorizontal()) {
            x = top + ((float)this.getItemWidth() - lineWidth) / 2.0f;
            y = (this.getItemHeight() - layout.getHeight()) / 2;
        } else {
            x = ((float)this.getItemWidth() - lineWidth) / 2.0f;
            y = top + (float)((this.getItemHeight() - layout.getHeight()) / 2);
        }
        this.computeColor(relative, itemSize, moveLength);
        canvas.save();
        canvas.translate(x, y);
        layout.draw(canvas);
        canvas.restore();
    }

    private void computeColor(int relative, int itemSize, float moveLength) {
        int color = this.mEndColor;
        if (relative == -1 || relative == 1) {
            if (relative == -1 && moveLength < 0.0f || relative == 1 && moveLength > 0.0f) {
                color = this.mEndColor;
            } else {
                float rate = ((float)itemSize - Math.abs(moveLength)) / (float)itemSize;
                color = ColorUtil.computeGradientColor(this.mStartColor, this.mEndColor, rate);
            }
        } else if (relative == 0) {
            float rate = Math.abs(moveLength) / (float)itemSize;
            color = ColorUtil.computeGradientColor(this.mStartColor, this.mEndColor, rate);
        }
        this.mPaint.setColor(color);
    }
}

