/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import cn.forward.androids.R;

public class RoundProgressBar
extends View {
    private Paint mPaint;
    private RectF mRect;
    private float mProgress = 0.0f;
    private float mMaxProgress = 100.0f;
    private int mColor = -5538;
    private int mWidth = 20;
    private int mBgWidth = 20;
    private int mBackground = 0;
    private RoundProgressBarListener mListener;

    public RoundProgressBar(Context context) {
        this(context, null, 0);
    }

    public RoundProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
        this.mRect = new RectF();
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RoundProgressBar);
        this.mWidth = a.getDimensionPixelOffset(R.styleable.RoundProgressBar_rpb_width, this.mWidth);
        this.mColor = a.getColor(R.styleable.RoundProgressBar_rpb_color, this.mColor);
        this.mBackground = a.getColor(R.styleable.RoundProgressBar_rpb_background, this.mBackground);
        this.mProgress = a.getFloat(R.styleable.RoundProgressBar_rpb_progress, this.mProgress);
        this.mMaxProgress = a.getFloat(R.styleable.RoundProgressBar_rpb_max_progress, this.mMaxProgress);
        this.mBgWidth = a.getDimensionPixelOffset(R.styleable.RoundProgressBar_rpb_background_width, this.mBgWidth);
        a.recycle();
    }

    public void setProgress(float progress) {
        float f = this.mProgress = progress < 0.0f ? 0.0f : progress;
        if (this.mListener != null) {
            this.mListener.onProgressChanged(this.mProgress);
        }
        this.invalidate();
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setMaxProgress(float maxProgress) {
        this.mMaxProgress = maxProgress < 0.0f ? 100.0f : this.mMaxProgress;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRect.left = this.getPaddingLeft() + this.mWidth / 2;
        this.mRect.top = this.getPaddingTop() + this.mWidth / 2;
        this.mRect.right = w - this.getPaddingRight() - this.mWidth / 2;
        this.mRect.bottom = h - this.getPaddingBottom() - this.mWidth / 2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float degree = 360.0f * this.mProgress / this.mMaxProgress;
        this.mPaint.setStrokeWidth((float)this.mBgWidth);
        this.mPaint.setColor(this.mBackground);
        canvas.drawArc(this.mRect, 0.0f, 360.0f, false, this.mPaint);
        this.mPaint.setStrokeWidth((float)this.mWidth);
        this.mPaint.setColor(this.mColor);
        canvas.drawArc(this.mRect, -90.0f, degree <= 0.0f ? 1.0f : degree, false, this.mPaint);
    }

    public void setProgressBarListener(RoundProgressBarListener listener) {
        this.mListener = listener;
    }

    public RoundProgressBarListener getProgressBarListener() {
        return this.mListener;
    }

    public float getMaxProgress() {
        return this.mMaxProgress;
    }

    public void setBgCircleColor(int background) {
        this.mBackground = background;
    }

    public void setBgCircleWidth(int bgWidth) {
        this.mBgWidth = bgWidth;
    }

    public void setCircleColor(int color) {
        this.mColor = color;
    }

    public void setCircleWidth(int width) {
        this.mWidth = width;
    }

    public int getBgCircleColor() {
        return this.mBackground;
    }

    public int getBgCircleWidth() {
        return this.mBgWidth;
    }

    public int getCircleColor() {
        return this.mColor;
    }

    public int getCirlceWidth() {
        return this.mWidth;
    }

    public static interface RoundProgressBarListener {
        public void onProgressChanged(float var1);
    }
}

