/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import cn.forward.androids.R;
import cn.forward.androids.views.ScrollPickerView;
import java.util.List;

public class BitmapScrollPicker
extends ScrollPickerView<Bitmap> {
    public static final int DRAW_MODE_FULL = 1;
    public static final int DRAW_MODE_CENTER = 2;
    public static final int DRAW_MODE_SPECIFIED_SIZE = 3;
    private int mMeasureWidth;
    private int mMeasureHeight;
    private Rect mRect1 = new Rect();
    private Rect mRect2 = new Rect();
    private Rect mSpecifiedSizeRect = new Rect();
    private Rect mRectTemp = new Rect();
    private int mDrawMode = 2;
    private float mMinScale = 1.0f;
    private float mMaxScale = 1.0f;
    private int mSpecifiedSizeWidth = -1;
    private int mSpecifiedSizeHeight = -1;

    public BitmapScrollPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BitmapScrollPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BitmapScrollPicker);
            this.mDrawMode = typedArray.getInt(R.styleable.BitmapScrollPicker_spv_draw_bitmap_mode, this.mDrawMode);
            this.mSpecifiedSizeWidth = typedArray.getDimensionPixelOffset(R.styleable.BitmapScrollPicker_spv_draw_bitmap_width, this.mSpecifiedSizeWidth);
            this.mSpecifiedSizeHeight = typedArray.getDimensionPixelOffset(R.styleable.BitmapScrollPicker_spv_draw_bitmap_height, this.mSpecifiedSizeHeight);
            this.mMinScale = typedArray.getFloat(R.styleable.BitmapScrollPicker_spv_min_scale, this.mMinScale);
            this.mMaxScale = typedArray.getFloat(R.styleable.BitmapScrollPicker_spv_max_scale, this.mMaxScale);
            typedArray.recycle();
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mMeasureWidth = this.getMeasuredWidth();
        this.mMeasureHeight = this.getMeasuredHeight();
        if (this.mDrawMode == 1) {
            if (this.isHorizontal()) {
                this.mRect2.top = 0;
                this.mRect2.bottom = this.mMeasureHeight;
            } else {
                this.mRect2.left = 0;
                this.mRect2.right = this.mMeasureWidth;
            }
        } else if (this.mDrawMode == 3) {
            if (this.mSpecifiedSizeWidth == -1) {
                this.mSpecifiedSizeWidth = this.mMeasureWidth;
                this.mSpecifiedSizeHeight = this.mMeasureHeight;
            }
            this.setDrawModeSpecifiedSize(this.mSpecifiedSizeWidth, this.mSpecifiedSizeHeight);
        } else {
            int size = this.isHorizontal() ? Math.min(this.mMeasureHeight, this.getItemWidth()) : Math.min(this.mMeasureWidth, this.getItemHeight());
            if (this.isHorizontal()) {
                this.mRect2.top = this.mMeasureHeight / 2 - size / 2;
                this.mRect2.bottom = this.mMeasureHeight / 2 + size / 2;
            } else {
                this.mRect2.left = this.mMeasureWidth / 2 - size / 2;
                this.mRect2.right = this.mMeasureWidth / 2 + size / 2;
            }
        }
    }

    @Override
    public void drawItem(Canvas canvas, List<Bitmap> data, int position, int relative, float moveLength, float top) {
        int itemSize = this.getItemSize();
        Bitmap bitmap = data.get(position);
        this.mRect1.right = bitmap.getWidth();
        this.mRect1.bottom = bitmap.getHeight();
        int span = 0;
        if (this.mDrawMode == 1) {
            span = 0;
            if (this.isHorizontal()) {
                this.mRect2.left = (int)top + span;
                this.mRect2.right = (int)(top + (float)itemSize - (float)span);
            } else {
                this.mRect2.top = (int)top + span;
                this.mRect2.bottom = (int)(top + (float)itemSize - (float)span);
            }
            this.mRectTemp.set(this.mRect2);
            this.scale(this.mRectTemp, relative, itemSize, moveLength);
            canvas.drawBitmap(bitmap, this.mRect1, this.mRectTemp, null);
        } else if (this.mDrawMode == 3) {
            if (this.isHorizontal()) {
                span = (itemSize - this.mSpecifiedSizeWidth) / 2;
                this.mSpecifiedSizeRect.left = (int)top + span;
                this.mSpecifiedSizeRect.right = (int)top + span + this.mSpecifiedSizeWidth;
            } else {
                span = (itemSize - this.mSpecifiedSizeHeight) / 2;
                this.mSpecifiedSizeRect.top = (int)top + span;
                this.mSpecifiedSizeRect.bottom = (int)top + span + this.mSpecifiedSizeHeight;
            }
            this.mRectTemp.set(this.mSpecifiedSizeRect);
            this.scale(this.mRectTemp, relative, itemSize, moveLength);
            canvas.drawBitmap(bitmap, this.mRect1, this.mRectTemp, null);
        } else {
            if (this.isHorizontal()) {
                float scale = (float)this.mRect2.height() * 1.0f / (float)bitmap.getHeight();
                span = (int)(((float)itemSize - (float)bitmap.getWidth() * scale) / 2.0f);
            } else {
                float scale = (float)this.mRect2.width() * 1.0f / (float)bitmap.getWidth();
                span = (int)(((float)itemSize - (float)bitmap.getHeight() * scale) / 2.0f);
            }
            if (this.isHorizontal()) {
                this.mRect2.left = (int)(top + (float)span);
                this.mRect2.right = (int)(top + (float)itemSize - (float)span);
            } else {
                this.mRect2.top = (int)(top + (float)span);
                this.mRect2.bottom = (int)(top + (float)itemSize - (float)span);
            }
            this.mRectTemp.set(this.mRect2);
            this.scale(this.mRectTemp, relative, itemSize, moveLength);
            canvas.drawBitmap(bitmap, this.mRect1, this.mRectTemp, null);
        }
    }

    private void scale(Rect rect, int relative, int itemSize, float moveLength) {
        float spanHeight;
        float spanWidth;
        if (this.mMinScale == 1.0f && this.mMaxScale == 1.0f) {
            return;
        }
        if (this.mMinScale == this.mMaxScale) {
            float spanWidth2 = ((float)rect.width() - this.mMinScale * (float)rect.width()) / 2.0f;
            float spanHeight2 = ((float)rect.height() - this.mMinScale * (float)rect.height()) / 2.0f;
            rect.left = (int)((float)rect.left + spanWidth2);
            rect.right = (int)((float)rect.right - spanWidth2);
            rect.top = (int)((float)rect.top + spanHeight2);
            rect.bottom = (int)((float)rect.bottom - spanHeight2);
            return;
        }
        if (relative == -1 || relative == 1) {
            if (relative == -1 && moveLength < 0.0f || relative == 1 && moveLength > 0.0f) {
                spanWidth = ((float)rect.width() - this.mMinScale * (float)rect.width()) / 2.0f;
                spanHeight = ((float)rect.height() - this.mMinScale * (float)rect.height()) / 2.0f;
            } else {
                float rate = Math.abs(moveLength) / (float)itemSize;
                spanWidth = ((float)rect.width() - (this.mMinScale + (this.mMaxScale - this.mMinScale) * rate) * (float)rect.width()) / 2.0f;
                spanHeight = ((float)rect.height() - (this.mMinScale + (this.mMaxScale - this.mMinScale) * rate) * (float)rect.height()) / 2.0f;
            }
        } else if (relative == 0) {
            float rate = ((float)itemSize - Math.abs(moveLength)) / (float)itemSize;
            spanWidth = ((float)rect.width() - (this.mMinScale + (this.mMaxScale - this.mMinScale) * rate) * (float)rect.width()) / 2.0f;
            spanHeight = ((float)rect.height() - (this.mMinScale + (this.mMaxScale - this.mMinScale) * rate) * (float)rect.height()) / 2.0f;
        } else {
            spanWidth = ((float)rect.width() - this.mMinScale * (float)rect.width()) / 2.0f;
            spanHeight = ((float)rect.height() - this.mMinScale * (float)rect.height()) / 2.0f;
        }
        rect.left = (int)((float)rect.left + spanWidth);
        rect.right = (int)((float)rect.right - spanWidth);
        rect.top = (int)((float)rect.top + spanHeight);
        rect.bottom = (int)((float)rect.bottom - spanHeight);
    }

    public void setDrawMode(int mode) {
        int size = 0;
        size = this.isHorizontal() ? Math.min(this.mMeasureHeight, this.getItemWidth()) : Math.min(this.mMeasureWidth, this.getItemHeight());
        this.mDrawMode = mode;
        if (this.mDrawMode == 1) {
            if (this.isHorizontal()) {
                this.mRect2.top = 0;
                this.mRect2.bottom = this.mMeasureHeight;
            } else {
                this.mRect2.left = 0;
                this.mRect2.right = this.mMeasureWidth;
            }
        } else if (this.mDrawMode != 3) {
            if (this.isHorizontal()) {
                this.mRect2.top = this.mMeasureHeight / 2 - size / 2;
                this.mRect2.bottom = this.mMeasureHeight / 2 + size / 2;
            } else {
                this.mRect2.left = this.mMeasureWidth / 2 - size / 2;
                this.mRect2.right = this.mMeasureWidth / 2 + size / 2;
            }
        }
        this.invalidate();
    }

    public void setDrawModeSpecifiedSize(int width, int height) {
        if (this.isHorizontal()) {
            this.mSpecifiedSizeRect.top = (this.mMeasureHeight - height) / 2;
            this.mSpecifiedSizeRect.bottom = (this.mMeasureHeight - height) / 2 + height;
        } else {
            this.mSpecifiedSizeRect.left = (this.mMeasureWidth - width) / 2;
            this.mSpecifiedSizeRect.right = (this.mMeasureWidth - width) / 2 + width;
        }
        this.mSpecifiedSizeWidth = width;
        this.mSpecifiedSizeHeight = height;
        this.invalidate();
    }

    public int getDrawMode() {
        return this.mDrawMode;
    }

    public void setItemScale(float minScale, float maxScale) {
        this.mMinScale = minScale;
        this.mMaxScale = maxScale;
        this.invalidate();
    }

    public float getMinScale() {
        return this.mMinScale;
    }

    public float getMaxScale() {
        return this.mMaxScale;
    }
}

