/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.utils;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.AbsListView;
import java.lang.reflect.Field;

public class ViewUtil {
    private static long sLastTime = 0L;

    public static float getX(View view) {
        if (Build.VERSION.SDK_INT >= 11) {
            return view.getX();
        }
        return (float)view.getLeft() + view.getTranslationX();
    }

    public static float getY(View view) {
        if (Build.VERSION.SDK_INT >= 11) {
            return view.getY();
        }
        return (float)view.getTop() + view.getTranslationY();
    }

    public static boolean isFastDoubleClick(int time) {
        if (System.currentTimeMillis() - sLastTime < (long)time) {
            return true;
        }
        sLastTime = System.currentTimeMillis();
        return false;
    }

    public static boolean isFastDoubleClick() {
        return ViewUtil.isFastDoubleClick(500);
    }

    public static View.OnClickListener getOnClickListener(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            return ViewUtil.getOnClickListenerV14(view);
        }
        return ViewUtil.getOnClickListenerV(view);
    }

    private static View.OnClickListener getOnClickListenerV(View view) {
        View.OnClickListener retrievedListener = null;
        String viewStr = "android.view.View";
        try {
            Field field = Class.forName(viewStr).getDeclaredField("mOnClickListener");
            retrievedListener = (View.OnClickListener)field.get(view);
        }
        catch (NoSuchFieldException ex) {
            Log.e((String)"Reflection", (String)"No Such Field.");
        }
        catch (IllegalAccessException ex) {
            Log.e((String)"Reflection", (String)"Illegal Access.");
        }
        catch (ClassNotFoundException ex) {
            Log.e((String)"Reflection", (String)"Class Not Found.");
        }
        return retrievedListener;
    }

    private static View.OnClickListener getOnClickListenerV14(View view) {
        View.OnClickListener retrievedListener = null;
        String viewStr = "android.view.View";
        String lInfoStr = "android.view.View$ListenerInfo";
        try {
            Field clickListenerField;
            Field listenerField = Class.forName(viewStr).getDeclaredField("mListenerInfo");
            Object listenerInfo = null;
            if (listenerField != null) {
                listenerField.setAccessible(true);
                listenerInfo = listenerField.get(view);
            }
            if ((clickListenerField = Class.forName(lInfoStr).getDeclaredField("mOnClickListener")) != null && listenerInfo != null) {
                retrievedListener = (View.OnClickListener)clickListenerField.get(listenerInfo);
            }
        }
        catch (NoSuchFieldException ex) {
            Log.e((String)"Reflection", (String)"No Such Field.");
        }
        catch (IllegalAccessException ex) {
            Log.e((String)"Reflection", (String)"Illegal Access.");
        }
        catch (ClassNotFoundException ex) {
            Log.e((String)"Reflection", (String)"Class Not Found.");
        }
        return retrievedListener;
    }

    public static boolean canScrollUp(View view) {
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                AbsListView absListView = (AbsListView)view;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return view.getScrollY() > 0;
        }
        return view.canScrollVertically(-1);
    }
}

