/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.Image;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import cn.forward.androids.Image.ImageCache;
import cn.forward.androids.Image.ImageLoader;
import cn.forward.androids.Image.ImageLoaderConfig;
import java.util.concurrent.CopyOnWriteArrayList;

public class ImageLoaderGroup
implements ImageLoader {
    private ImageCache mImageCache;
    private ImageLoaderConfig mImageLoaderConfig;
    private CopyOnWriteArrayList<ImageLoader> mImageLoaders = new CopyOnWriteArrayList();

    public ImageLoaderGroup(Context context) {
        this(context, (int)Runtime.getRuntime().maxMemory() / 8, 0x1900000L);
    }

    public ImageLoaderGroup(Context context, int memoryMaxSize, long diskMaxSize) {
        this(context, null);
        this.mImageCache = new ImageCache(context, memoryMaxSize, diskMaxSize);
        this.mImageLoaderConfig = new ImageLoaderConfig(this.mImageCache);
    }

    public ImageLoaderGroup(Context context, ImageLoaderConfig config) {
        this.mImageLoaderConfig = config;
    }

    public void setImageLoaderConfig(ImageLoaderConfig imageLoaderConfig) {
        this.mImageLoaderConfig = imageLoaderConfig;
    }

    public ImageLoaderConfig getImageLoaderConfig() {
        return this.mImageLoaderConfig;
    }

    @Override
    public boolean load(View view, String path, ImageLoaderConfig config, ImageLoader.ImageLoaderListener loaderListener) {
        if (view == null || TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        boolean accept = false;
        for (ImageLoader loader : this.mImageLoaders) {
            if (!loader.load(view, path, config, loaderListener)) continue;
            accept = true;
            break;
        }
        return accept;
    }

    @Override
    public boolean load(String path, ImageLoaderConfig config, ImageLoader.ImageLoaderListener loaderListener) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        boolean accept = false;
        for (ImageLoader loader : this.mImageLoaders) {
            if (!loader.load(path, config, loaderListener)) continue;
            accept = true;
            break;
        }
        return accept;
    }

    public boolean load(View view, String path) {
        return this.load(view, path, this.mImageLoaderConfig, null);
    }

    public boolean load(String path, ImageLoader.ImageLoaderListener loaderListener) {
        return this.load(path, this.mImageLoaderConfig, loaderListener);
    }

    public void addImageLoader(ImageLoader loader) {
        if (loader == null) {
            return;
        }
        this.mImageLoaders.add(loader);
    }

    public void removeImageLoader(ImageLoader loader) {
        if (loader == null) {
            return;
        }
        this.mImageLoaders.remove(loader);
    }

    public boolean containImageLoader(ImageLoader loader) {
        return this.mImageLoaders.contains(loader);
    }

    public void clearAllImageLoaders() {
        this.mImageLoaders.clear();
    }

    public ImageCache getImageCache() {
        return this.mImageCache;
    }
}

