/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.utils;

import android.app.Activity;
import android.os.Build;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    public static void setStatusBarTranslucent(Window win, boolean translucent, boolean darkMode) {
        if (Build.VERSION.SDK_INT >= 19) {
            WindowManager.LayoutParams winParams = win.getAttributes();
            winParams.flags = translucent ? (winParams.flags |= 0x4000000) : (winParams.flags &= 0xFBFFFFFF);
            win.setAttributes(winParams);
            if (!StatusBarUtil.setStatusBarDarkModeMEIZU(win, darkMode)) {
                StatusBarUtil.setStatusBarDarkModeXIAOMI(win, darkMode);
            }
        }
    }

    public static void setStatusBarTranslucent(Activity activity, boolean translucent, boolean darkMode) {
        StatusBarUtil.setStatusBarTranslucent(activity.getWindow(), translucent, darkMode);
    }

    public static boolean setStatusBarDarkModeMEIZU(Window window, boolean dark) {
        try {
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setStatusBarDarkModeXIAOMI(Window window, boolean darkmode) {
        Class<?> clazz = window.getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)window, darkmode ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

