/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.exception;

import android.os.Looper;
import cn.forward.androids.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private HandlerListener mHandlerListener;
    private String mLogDir;

    public UncaughtExceptionHandler() {
        this(null);
    }

    public UncaughtExceptionHandler(HandlerListener handlerListener) {
        this(handlerListener, null);
    }

    public UncaughtExceptionHandler(HandlerListener handlerListener, String logDirPath) {
        this.mHandlerListener = handlerListener;
        this.mLogDir = logDirPath != null ? logDirPath : LogUtil.LOG_DIR;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogs(Throwable ex) {
        ByteArrayOutputStream baos = null;
        PrintStream printStream = null;
        try {
            baos = new ByteArrayOutputStream();
            printStream = new PrintStream(baos);
            ex.printStackTrace(printStream);
            byte[] data = baos.toByteArray();
            LogUtil.writeLog(new String(data), this.mLogDir);
        }
        catch (Exception e) {
            LogUtil.e("UncaughtExceptionHandler", e.getMessage(), e);
        }
        finally {
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        LogUtil.i("uncaughtException");
        if (ex != null) {
            ex.printStackTrace();
            this.saveLogs(ex);
        }
        if (this.mHandlerListener != null) {
            Looper.getMainLooper();
            Looper.prepare();
            this.mHandlerListener.onHandleException(ex);
            Looper.getMainLooper();
            Looper.loop();
        }
    }

    public static interface HandlerListener {
        public void onHandleException(Throwable var1);
    }
}

