/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import cn.forward.androids.R;

public class RatioImageView
extends ImageView {
    private float mDrawableSizeRatio = -1.0f;
    private boolean mIsWidthFitDrawableSizeRatio;
    private boolean mIsHeightFitDrawableSizeRatio;
    private int mMaxWidthWhenWidthFixDrawable = -1;
    private int mMaxHeightWhenHeightFixDrawable = -1;
    private float mWidthRatio = -1.0f;
    private float mHeightRatio = -1.0f;
    private int mDesiredWidth = -1;
    private int mDesiredHeight = -1;

    public RatioImageView(Context context) {
        this(context, null);
    }

    public RatioImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RatioImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
        if (this.getDrawable() != null) {
            this.mDrawableSizeRatio = 1.0f * (float)this.getDrawable().getIntrinsicWidth() / (float)this.getDrawable().getIntrinsicHeight();
        }
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RatioImageView);
        this.mIsWidthFitDrawableSizeRatio = a.getBoolean(R.styleable.RatioImageView_riv_is_width_fix_drawable_size_ratio, this.mIsWidthFitDrawableSizeRatio);
        this.mIsHeightFitDrawableSizeRatio = a.getBoolean(R.styleable.RatioImageView_riv_is_height_fix_drawable_size_ratio, this.mIsHeightFitDrawableSizeRatio);
        this.mMaxWidthWhenWidthFixDrawable = a.getDimensionPixelOffset(R.styleable.RatioImageView_riv_max_width_when_width_fix_drawable, this.mMaxWidthWhenWidthFixDrawable);
        this.mMaxHeightWhenHeightFixDrawable = a.getDimensionPixelOffset(R.styleable.RatioImageView_riv_max_height_when_height_fix_drawable, this.mMaxHeightWhenHeightFixDrawable);
        this.mHeightRatio = a.getFloat(R.styleable.RatioImageView_riv_height_to_width_ratio, this.mHeightRatio);
        this.mWidthRatio = a.getFloat(R.styleable.RatioImageView_riv_width_to_height_ratio, this.mWidthRatio);
        this.mDesiredWidth = a.getDimensionPixelOffset(R.styleable.RatioImageView_riv_width, this.mDesiredWidth);
        this.mDesiredHeight = a.getDimensionPixelOffset(R.styleable.RatioImageView_riv_height, this.mDesiredHeight);
        a.recycle();
    }

    private void onSetDrawable() {
        Drawable drawable = this.getDrawable();
        if (drawable != null && (this.mIsWidthFitDrawableSizeRatio || this.mIsHeightFitDrawableSizeRatio)) {
            float old = this.mDrawableSizeRatio;
            this.mDrawableSizeRatio = 1.0f * (float)drawable.getIntrinsicWidth() / (float)drawable.getIntrinsicHeight();
            if (old != this.mDrawableSizeRatio && this.mDrawableSizeRatio > 0.0f) {
                this.requestLayout();
            }
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.onSetDrawable();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.onSetDrawable();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mDrawableSizeRatio > 0.0f) {
            if (this.mIsWidthFitDrawableSizeRatio) {
                this.mWidthRatio = this.mDrawableSizeRatio;
            } else if (this.mIsHeightFitDrawableSizeRatio) {
                this.mHeightRatio = 1.0f / this.mDrawableSizeRatio;
            }
        }
        if (this.mHeightRatio > 0.0f && this.mWidthRatio > 0.0f) {
            throw new RuntimeException("\u9ad8\u5ea6\u548c\u5bbd\u5ea6\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e\u767e\u5206\u6bd4\uff01\uff01");
        }
        if (this.mWidthRatio > 0.0f) {
            int height = 0;
            height = this.mDesiredHeight > 0 ? this.mDesiredHeight : View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (height <= 0) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int width = (int)((float)height * this.mWidthRatio);
            if (this.mIsWidthFitDrawableSizeRatio && this.mMaxWidthWhenWidthFixDrawable > 0 && width > this.mMaxWidthWhenWidthFixDrawable) {
                width = this.mMaxWidthWhenWidthFixDrawable;
                height = (int)((float)width / this.mWidthRatio);
            }
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        } else if (this.mHeightRatio > 0.0f) {
            int width = 0;
            width = this.mDesiredWidth > 0 ? this.mDesiredWidth : View.MeasureSpec.getSize((int)widthMeasureSpec);
            if (width <= 0) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int height = (int)((float)width * this.mHeightRatio);
            if (this.mIsHeightFitDrawableSizeRatio && this.mMaxHeightWhenHeightFixDrawable > 0 && height > this.mMaxHeightWhenHeightFixDrawable) {
                height = this.mMaxHeightWhenHeightFixDrawable;
                width = (int)((float)height / this.mHeightRatio);
            }
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        } else if (this.mDesiredHeight > 0 && this.mDesiredWidth > 0) {
            int width = this.mDesiredWidth;
            int height = this.mDesiredHeight;
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setIsFitDrawableSizeRatio(boolean isWidthFitDrawableSizeRatio, boolean isHeightFitDrawableSizeRatio) {
        this.mHeightRatio = -1.0f;
        this.mWidthRatio = -1.0f;
        boolean oldIsWidth = this.mIsWidthFitDrawableSizeRatio;
        boolean oldIsHeight = this.mIsHeightFitDrawableSizeRatio;
        this.mIsWidthFitDrawableSizeRatio = isWidthFitDrawableSizeRatio;
        this.mIsHeightFitDrawableSizeRatio = isHeightFitDrawableSizeRatio;
        Drawable drawable = this.getDrawable();
        this.mDrawableSizeRatio = drawable != null ? 1.0f * (float)drawable.getIntrinsicWidth() / (float)drawable.getIntrinsicHeight() : -1.0f;
        if (oldIsWidth != this.mIsWidthFitDrawableSizeRatio || oldIsHeight != this.mIsHeightFitDrawableSizeRatio) {
            this.requestLayout();
        }
    }

    public void setWidthRatio(float mWidthRatio) {
        this.mIsHeightFitDrawableSizeRatio = false;
        this.mIsWidthFitDrawableSizeRatio = false;
        float oldWidthRatio = mWidthRatio;
        float oldHeightRatio = this.mHeightRatio;
        this.mHeightRatio = -1.0f;
        this.mWidthRatio = mWidthRatio;
        if (oldWidthRatio != mWidthRatio || oldHeightRatio != this.mHeightRatio) {
            this.requestLayout();
        }
    }

    public void setHeightRatio(float mHeightRatio) {
        this.mIsHeightFitDrawableSizeRatio = false;
        this.mIsWidthFitDrawableSizeRatio = false;
        float oldWidthRatio = this.mWidthRatio;
        float oldHeightRatio = mHeightRatio;
        this.mWidthRatio = -1.0f;
        this.mHeightRatio = mHeightRatio;
        if (oldWidthRatio != this.mWidthRatio || oldHeightRatio != mHeightRatio) {
            this.requestLayout();
        }
    }

    public void setWidthAndHeight(int width, int height) {
        int oldW = this.mDesiredWidth;
        int oldH = this.mDesiredHeight;
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        if (oldW != this.mDesiredWidth || oldH != this.mDesiredHeight) {
            this.requestLayout();
        }
    }

    public boolean isIsWidthFitDrawableSizeRatio() {
        return this.mIsWidthFitDrawableSizeRatio;
    }

    public boolean isIsHeightFitDrawableSizeRatio() {
        return this.mIsHeightFitDrawableSizeRatio;
    }

    public float getWidthRatio() {
        return this.mWidthRatio;
    }

    public float getHeightRatio() {
        return this.mHeightRatio;
    }

    public float getDrawableSizeRatio() {
        return this.mDrawableSizeRatio;
    }
}

