/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import cn.forward.androids.R;
import cn.forward.androids.annotation.ViewInjectProcessor;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;

public class InjectionLayoutInflater
extends LayoutInflater
implements LayoutInflater.Factory {
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.app."};
    private static final WeakHashMap<Context, InjectionLayoutInflater> WEAK_HASH_MAP = new WeakHashMap();
    private OnViewCreatedListener mOnViewCreatedListener;

    protected InjectionLayoutInflater(Context context) {
        super(context);
        this.setFactory(this);
    }

    protected InjectionLayoutInflater(LayoutInflater original, Context newContext) {
        super(original, newContext);
        this.setFactory(this);
    }

    public static InjectionLayoutInflater from(Context context) {
        InjectionLayoutInflater layoutInflater = WEAK_HASH_MAP.get(context);
        if (layoutInflater == null) {
            layoutInflater = new InjectionLayoutInflater(context);
            WEAK_HASH_MAP.put(context, layoutInflater);
        }
        return layoutInflater;
    }

    public static InjectionLayoutInflater from(Context context, LayoutInflater original) {
        InjectionLayoutInflater layoutInflater = WEAK_HASH_MAP.get(context);
        if (layoutInflater == null) {
            layoutInflater = new InjectionLayoutInflater(original, context);
            WEAK_HASH_MAP.put(context, layoutInflater);
        }
        return layoutInflater;
    }

    public LayoutInflater cloneInContext(Context newContext) {
        return new InjectionLayoutInflater(this, newContext);
    }

    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot, OnViewCreatedListener listener) {
        this.mOnViewCreatedListener = listener;
        View view = super.inflate(parser, root, attachToRoot);
        this.mOnViewCreatedListener = null;
        return view;
    }

    public View inflate(XmlPullParser parser, ViewGroup root, OnViewCreatedListener listener) {
        this.mOnViewCreatedListener = listener;
        View view = super.inflate(parser, root);
        this.mOnViewCreatedListener = null;
        return view;
    }

    public View inflate(int resource, ViewGroup root, OnViewCreatedListener listener) {
        this.mOnViewCreatedListener = listener;
        View view = super.inflate(resource, root);
        this.mOnViewCreatedListener = null;
        return view;
    }

    public View inflate(int resource, ViewGroup root, boolean attachToRoot, OnViewCreatedListener listener) {
        this.mOnViewCreatedListener = listener;
        View view = super.inflate(resource, root, attachToRoot);
        this.mOnViewCreatedListener = null;
        return view;
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs, OnViewCreatedListener listener) throws ClassNotFoundException {
        this.mOnViewCreatedListener = listener;
        View view = this.onCreateView(parent, name, attrs);
        this.mOnViewCreatedListener = null;
        return view;
    }

    protected View onCreateView(String name, AttributeSet attrs, OnViewCreatedListener listener) throws ClassNotFoundException {
        this.mOnViewCreatedListener = listener;
        View view = this.onCreateView(name, attrs);
        this.mOnViewCreatedListener = null;
        return view;
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = super.onCreateView(parent, name, attrs);
        if (this.mOnViewCreatedListener != null) {
            return this.mOnViewCreatedListener.onViewCreated(this.getContext(), parent, view, attrs);
        }
        return view;
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = null;
        if (-1 == name.indexOf(46)) {
            for (String prefix : sClassPrefixList) {
                try {
                    view = this.createView(name, prefix, attrs);
                    if (view == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        } else {
            view = this.createView(name, null, attrs);
        }
        if (view == null) {
            view = super.onCreateView(name, attrs);
        }
        if (this.mOnViewCreatedListener != null) {
            return this.mOnViewCreatedListener.onViewCreated(this.getContext(), null, view, attrs);
        }
        return view;
    }

    public void setFactory2(LayoutInflater.Factory2 factory) {
        super.setFactory2(factory);
    }

    public void setFactory(LayoutInflater.Factory factory) {
        super.setFactory(factory);
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        try {
            return this.onCreateView(name, attrs);
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    public static OnViewCreatedListener getViewOnClickListenerInjector(final View.OnClickListener clickListener) {
        if (clickListener == null) {
            return null;
        }
        return new OnViewCreatedListener(){

            @Override
            public View onViewCreated(Context context, View parent, View view, AttributeSet attrs) {
                TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View);
                if (a.getBoolean(R.styleable.View_injectListener, false)) {
                    view.setOnClickListener(clickListener);
                }
                a.recycle();
                return view;
            }
        };
    }

    public static OnViewCreatedListener getViewInjector(final Object object) {
        if (object == null) {
            return null;
        }
        return new OnViewCreatedListener(){

            @Override
            public View onViewCreated(Context context, View parent, View view, AttributeSet attrs) {
                ViewInjectProcessor.process(object, view);
                return view;
            }
        };
    }

    public static OnViewCreatedListener merge(final OnViewCreatedListener ... listeners) {
        if (listeners == null) {
            return null;
        }
        return new OnViewCreatedListener(){

            @Override
            public View onViewCreated(Context context, View parent, View view, AttributeSet attrs) {
                for (OnViewCreatedListener listener : listeners) {
                    view = listener.onViewCreated(context, parent, view, attrs);
                }
                return view;
            }
        };
    }

    public static interface OnViewCreatedListener {
        public View onViewCreated(Context var1, View var2, View var3, AttributeSet var4);
    }
}

