/*
 * Decompiled with CFR 0.152.
 */
package com.github.qq120011676.ladybird.web.conntroller;

import com.github.qq120011676.ladybird.web.exception.Restful;
import com.github.qq120011676.ladybird.web.exception.autoconfigure.RestfulExceptionProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerAdviceException {
    @Resource
    private RestfulExceptionProperties restfulExceptionProperties;

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map<String, Object>> handleException(Exception e) {
        e.printStackTrace();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(this.restfulExceptionProperties.getMessageName(), e.getMessage());
        String code = this.restfulExceptionProperties.getDefaultCode();
        int httpStatus = this.restfulExceptionProperties.getDefaultHttpStatus();
        if (e instanceof Restful) {
            Restful restful = (Restful)((Object)e);
            code = restful.getCode();
            if (!StringUtils.isEmpty((Object)restful.getHttpStatus())) {
                httpStatus = restful.getHttpStatus();
            }
        } else if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException methodArgumentNotValidException = (MethodArgumentNotValidException)e;
            BindingResult bindingResult = methodArgumentNotValidException.getBindingResult();
            code = this.getString(body, bindingResult);
        } else if (e instanceof BindException) {
            BindException bindException = (BindException)e;
            code = this.getString(body, (BindingResult)bindException);
        } else if ("org.springframework.security.access.AccessDeniedException".equals(e.getClass().getName())) {
            code = "no_authority";
            body.put(this.restfulExceptionProperties.getMessageName(), this.restfulExceptionProperties.getMessages().get(code));
        }
        body.put(this.restfulExceptionProperties.getCodeName(), code);
        return new ResponseEntity(body, HttpStatus.valueOf((int)httpStatus));
    }

    private String getString(Map<String, Object> body, BindingResult bindingResult) {
        List objectErrors = bindingResult.getAllErrors();
        String code = "parameter_error";
        StringBuilder message = new StringBuilder();
        ArrayList data = new ArrayList(objectErrors.size());
        for (int i = 0; i < objectErrors.size(); ++i) {
            ObjectError objectError = (ObjectError)objectErrors.get(i);
            HashMap<String, String> map = new HashMap<String, String>(2);
            if (i > 0) {
                message.append(System.lineSeparator());
            }
            message.append(objectError.getDefaultMessage());
            map.put("message", objectError.getDefaultMessage());
            Object[] objects = objectError.getArguments();
            if (objects != null) {
                StringBuilder field = new StringBuilder();
                for (int j = 0; j < objects.length; ++j) {
                    Object object = objects[j];
                    if (!(object instanceof MessageSourceResolvable)) continue;
                    MessageSourceResolvable messageSourceResolvable = (MessageSourceResolvable)object;
                    if (j > 0) {
                        field.append(",");
                    }
                    field.append(messageSourceResolvable.getDefaultMessage());
                }
                map.put("field", field.toString());
            }
            data.add(map);
        }
        body.put("data", data);
        body.put(this.restfulExceptionProperties.getMessageName(), message);
        return code;
    }
}

