/*
 * Decompiled with CFR 0.152.
 */
package com.github.qq120011676.ladybird.web.conntroller;

import com.github.qq120011676.ladybird.web.date.autoconfigure.RequestDateFormatProperties;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerAdviceDate {
    @Resource
    private RequestDateFormatProperties requestDateFormatProperties;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.requestDateFormatProperties.getDatePattern());
        dateFormat.setLenient(this.requestDateFormatProperties.isDateLenient());
        dateFormat.setTimeZone(TimeZone.getTimeZone(this.requestDateFormatProperties.getDateTimeZone()));
        binder.registerCustomEditor(Date.class, (PropertyEditor)this.customDateEditor(this.requestDateFormatProperties.getDatePattern(), this.requestDateFormatProperties.getDateTimeZone(), this.requestDateFormatProperties.isDateLenient(), this.requestDateFormatProperties.isDateAllowEmpty(), this.requestDateFormatProperties.isDatePatternLengthAuto()));
        binder.registerCustomEditor(LocalDate.class, (PropertyEditor)this.customDateEditor(this.requestDateFormatProperties.getLocalDatePattern(), this.requestDateFormatProperties.getLocalDateTimeZone(), this.requestDateFormatProperties.isLocalDateLenient(), this.requestDateFormatProperties.isLocalDateAllowEmpty(), this.requestDateFormatProperties.isLocalDatePatternLengthAuto()));
        binder.registerCustomEditor(LocalDateTime.class, (PropertyEditor)this.customDateEditor(this.requestDateFormatProperties.getLocalDateTimePattern(), this.requestDateFormatProperties.getLocalDateTimeTimeZone(), this.requestDateFormatProperties.isLocalDateTimeLenient(), this.requestDateFormatProperties.isLocalDateTimeAllowEmpty(), this.requestDateFormatProperties.isLocalDateTimePatternLengthAuto()));
        binder.registerCustomEditor(LocalTime.class, (PropertyEditor)this.customDateEditor(this.requestDateFormatProperties.getLocalTimePattern(), this.requestDateFormatProperties.getLocalTimeTimeZone(), this.requestDateFormatProperties.isLocalTimeLenient(), this.requestDateFormatProperties.isLocalTimeAllowEmpty(), this.requestDateFormatProperties.isLocalTimePatternLengthAuto()));
    }

    private CustomDateEditor customDateEditor(final String pattern, String timeZone, boolean lenient, boolean allowEmpty, final boolean autoLength) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(lenient);
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        return new CustomDateEditor(dateFormat, allowEmpty){

            public void setAsText(String text) throws IllegalArgumentException {
                if (autoLength && StringUtils.hasText((String)text) && text.length() != pattern.length()) {
                    try {
                        super.setValue((Object)new SimpleDateFormat(pattern.substring(0, text.length())).parse(text));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                super.setAsText(text);
            }
        };
    }
}

