/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.githang.statusbar.IStatusBar;
import com.githang.statusbar.LightStatusBarCompat;
import com.githang.statusbar.StatusBarExclude;
import com.githang.statusbar.StatusBarKitkatImpl;
import com.githang.statusbar.StatusBarLollipopImpl;
import com.githang.statusbar.StatusBarMImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class StatusBarCompat {
    static final IStatusBar IMPL = Build.VERSION.SDK_INT >= 23 ? new StatusBarMImpl() : (Build.VERSION.SDK_INT >= 21 && !StatusBarCompat.isEMUI() ? new StatusBarLollipopImpl() : (Build.VERSION.SDK_INT >= 19 ? new StatusBarKitkatImpl() : new IStatusBar(){

        @Override
        public void setStatusBarColor(Window window, @ColorInt int color) {
        }
    }));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEMUI() {
        File file = new File(Environment.getRootDirectory(), "build.prop");
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                properties.load(fis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return properties.containsKey("ro.build.hw_emui_api_level");
        }
        return false;
    }

    public static void setStatusBarColor(Activity activity, @ColorInt int color) {
        boolean isLightColor = StatusBarCompat.toGrey(color) > 225;
        StatusBarCompat.setStatusBarColor(activity, color, isLightColor);
    }

    public static int toGrey(@ColorInt int color) {
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        int red = Color.red((int)color);
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public static void setStatusBarColor(Activity activity, @ColorInt int color, boolean lightStatusBar) {
        StatusBarCompat.setStatusBarColor(activity.getWindow(), color, lightStatusBar);
    }

    public static void setStatusBarColor(Window window, @ColorInt int color, boolean lightStatusBar) {
        if ((window.getAttributes().flags & 0x400) > 0 || StatusBarExclude.exclude) {
            return;
        }
        IMPL.setStatusBarColor(window, color);
        LightStatusBarCompat.setLightStatusBar(window, lightStatusBar);
    }

    public static void setFitsSystemWindows(Window window, boolean fitSystemWindows) {
        if (Build.VERSION.SDK_INT >= 14) {
            StatusBarCompat.internalSetFitsSystemWindows(window, fitSystemWindows);
        }
    }

    @TargetApi(value=14)
    static void internalSetFitsSystemWindows(Window window, boolean fitSystemWindows) {
        ViewGroup contentView = (ViewGroup)window.findViewById(0x1020002);
        View childView = contentView.getChildAt(0);
        if (childView != null) {
            childView.setFitsSystemWindows(fitSystemWindows);
        }
    }

    public static void resetActionBarContainerTopMargin(Window window) {
        View contentView = window.findViewById(0x1020002);
        ViewGroup group = (ViewGroup)contentView.getParent();
        if (group.getChildCount() > 1) {
            View view = group.getChildAt(1);
            StatusBarCompat.internalResetActionBarContainer(view);
        }
    }

    public static void resetActionBarContainerTopMargin(Window window, @IdRes int actionBarContainerId) {
        View view = window.findViewById(actionBarContainerId);
        StatusBarCompat.internalResetActionBarContainer(view);
    }

    private static void internalResetActionBarContainer(View actionBarContainer) {
        ViewGroup.LayoutParams params;
        if (actionBarContainer != null && (params = actionBarContainer.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams) {
            ((ViewGroup.MarginLayoutParams)params).topMargin = 0;
            actionBarContainer.setLayoutParams(params);
        }
    }

    public static void setLightStatusBar(Window window, boolean isLightStatusBar) {
        LightStatusBarCompat.setLightStatusBar(window, isLightStatusBar);
    }

    public static void setTranslucent(Window window, boolean translucent) {
        if (Build.VERSION.SDK_INT >= 19) {
            if (translucent) {
                window.addFlags(0x4000000);
                StatusBarCompat.internalSetFitsSystemWindows(window, false);
            } else {
                window.clearFlags(0x4000000);
            }
        }
    }
}

