/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.ColorInt;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.githang.statusbar.IStatusBar;
import com.githang.statusbar.LightStatusBarCompat;
import com.githang.statusbar.StatusBarExclude;
import com.githang.statusbar.StatusBarKitkatImpl;
import com.githang.statusbar.StatusBarLollipopImpl;
import com.githang.statusbar.StatusBarMImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class StatusBarCompat {
    static final IStatusBar IMPL = Build.VERSION.SDK_INT >= 23 ? new StatusBarMImpl() : (Build.VERSION.SDK_INT >= 21 && !StatusBarCompat.isEMUI() ? new StatusBarLollipopImpl() : (Build.VERSION.SDK_INT >= 19 ? new StatusBarKitkatImpl() : new IStatusBar(){

        @Override
        public void setStatusBarColor(Window window, @ColorInt int color) {
        }
    }));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEMUI() {
        File file = new File(Environment.getRootDirectory(), "build.prop");
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                properties.load(fis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return properties.containsKey("ro.build.hw_emui_api_level");
        }
        return false;
    }

    public static void setStatusBarColor(Activity activity, @ColorInt int color) {
        boolean isLightColor = StatusBarCompat.toGrey(color) > 225;
        StatusBarCompat.setStatusBarColor(activity, color, isLightColor);
    }

    public static int toGrey(@ColorInt int color) {
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        int red = Color.red((int)color);
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public static void setStatusBarColor(Activity activity, @ColorInt int color, boolean lightStatusBar) {
        StatusBarCompat.setStatusBarColor(activity.getWindow(), color, lightStatusBar);
    }

    public static void setStatusBarColor(Window window, @ColorInt int color, boolean lightStatusBar) {
        if ((window.getAttributes().flags & 0x400) > 0 || StatusBarExclude.exclude) {
            return;
        }
        IMPL.setStatusBarColor(window, color);
        LightStatusBarCompat.setLightStatusBar(window, lightStatusBar);
    }

    @TargetApi(value=14)
    public static void setFitsSystemWindows(Window window, boolean fitSystemWindows) {
        ViewGroup mContentView;
        View mChildView;
        if (Build.VERSION.SDK_INT >= 14 && (mChildView = (mContentView = (ViewGroup)window.findViewById(0x1020002)).getChildAt(0)) != null) {
            mChildView.setFitsSystemWindows(fitSystemWindows);
        }
    }

    public static void setLightStatusBar(Window window, boolean isLightStatusBar) {
        LightStatusBarCompat.setLightStatusBar(window, isLightStatusBar);
    }
}

