/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.githang.statusbar.IStatusBar;
import com.githang.statusbar.StatusBarCompat;

class StatusBarKitkatImpl
implements IStatusBar {
    private static final String STATUS_BAR_VIEW_TAG = "ghStatusBarView";

    StatusBarKitkatImpl() {
    }

    @Override
    @TargetApi(value=19)
    public void setStatusBarColor(Window window, int color) {
        window.addFlags(0x4000000);
        ViewGroup decorViewGroup = (ViewGroup)window.getDecorView();
        View statusBarView = decorViewGroup.findViewWithTag((Object)STATUS_BAR_VIEW_TAG);
        if (statusBarView == null) {
            statusBarView = new View(window.getContext());
            statusBarView.setTag((Object)STATUS_BAR_VIEW_TAG);
            int statusBarHeight = StatusBarKitkatImpl.getStatusBarHeight(window.getContext());
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, statusBarHeight);
            params.gravity = 48;
            statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
            decorViewGroup.addView(statusBarView);
        }
        statusBarView.setBackgroundColor(color);
        StatusBarCompat.setFitsSystemWindows(window, true);
    }

    private static int getStatusBarHeight(Context context) {
        int statusBarHeight = 0;
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = res.getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }
}

