/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;

class LightStatusBarCompat {
    private static final ILightStatusBar IMPL = MIUILightStatusBarImpl.isMe() ? new MIUILightStatusBarImpl() : (Build.VERSION.SDK_INT >= 23 ? new MLightStatusBarImpl() : (MeizuLightStatusBarImpl.isMe() ? new MeizuLightStatusBarImpl() : new ILightStatusBar(){

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
        }
    }));

    LightStatusBarCompat() {
    }

    static void setLightStatusBar(Window window, boolean lightStatusBar) {
        IMPL.setLightStatusBar(window, lightStatusBar);
    }

    private static class MeizuLightStatusBarImpl
    implements ILightStatusBar {
        private MeizuLightStatusBarImpl() {
        }

        static boolean isMe() {
            return Build.DISPLAY.startsWith("Flyme");
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            WindowManager.LayoutParams params = window.getAttributes();
            try {
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(params);
                value = lightStatusBar ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(params, value);
                window.setAttributes(params);
                darkFlag.setAccessible(false);
                meizuFlags.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class MIUILightStatusBarImpl
    implements ILightStatusBar {
        private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
        private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
        private static final String KEY_MIUI_INTERNAL_STORAGE = "ro.miui.internal.storage";

        private MIUILightStatusBarImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean isMe() {
            FileInputStream is = null;
            try {
                is = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                Properties prop = new Properties();
                prop.load(is);
                boolean bl = prop.getProperty(KEY_MIUI_VERSION_CODE) != null || prop.getProperty(KEY_MIUI_VERSION_NAME) != null || prop.getProperty(KEY_MIUI_INTERNAL_STORAGE) != null;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                extraFlagField.invoke((Object)window, lightStatusBar ? darkModeFlag : 0, darkModeFlag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class MLightStatusBarImpl
    implements ILightStatusBar {
        private MLightStatusBarImpl() {
        }

        @Override
        @TargetApi(value=11)
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            View decor = window.getDecorView();
            int ui = decor.getSystemUiVisibility();
            ui = lightStatusBar ? (ui |= 0x2000) : (ui &= 0xFFFFDFFF);
            decor.setSystemUiVisibility(ui);
        }
    }

    static interface ILightStatusBar {
        public void setLightStatusBar(Window var1, boolean var2);
    }
}

