/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.githang.statusbar.IStatusBar;
import com.githang.statusbar.StatusBarKitkatImpl;
import com.githang.statusbar.StatusBarMImpl;

public class StatusBarCompat {
    static final IStatusBar IMPL = Build.VERSION.SDK_INT >= 23 ? new StatusBarMImpl() : (Build.VERSION.SDK_INT >= 19 ? new StatusBarKitkatImpl() : new IStatusBar(){

        @Override
        public void setStatusBarColor(Window window, int color, boolean lightStatusBar) {
        }
    });

    public static void setStatusBarColor(Activity activity, int color) {
        boolean isLightColor = StatusBarCompat.toGrey(color) > 225;
        StatusBarCompat.setStatusBarColor(activity, color, isLightColor);
    }

    public static int toGrey(int color) {
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        int red = Color.red((int)color);
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public static void setStatusBarColor(Activity activity, int color, boolean lightStatusBar) {
        StatusBarCompat.setStatusBarColor(activity.getWindow(), color, lightStatusBar);
    }

    public static void setStatusBarColor(Window window, int color, boolean lightStatusBar) {
        if ((window.getAttributes().flags & 0x400) > 0) {
            return;
        }
        IMPL.setStatusBarColor(window, color, lightStatusBar);
    }

    @TargetApi(value=14)
    public static void setFitsSystemWindows(Window window, boolean fitSystemWindows) {
        ViewGroup mContentView;
        View mChildView;
        if (Build.VERSION.SDK_INT >= 14 && (mChildView = (mContentView = (ViewGroup)window.findViewById(0x1020002)).getChildAt(0)) != null) {
            mChildView.setFitsSystemWindows(fitSystemWindows);
        }
    }
}

