/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.os.Build;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class StatusBarCompatFlavorRom {
    static final ILightStatusBar IMPL = MIUILightStatusBarImpl.isMe() ? new MIUILightStatusBarImpl() : (MeizuLightStatusBarImpl.isMe() ? new MeizuLightStatusBarImpl() : new ILightStatusBar(){

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
        }
    });

    StatusBarCompatFlavorRom() {
    }

    static void setLightStatusBar(Window window, boolean lightStatusBar) {
        IMPL.setLightStatusBar(window, lightStatusBar);
    }

    static class MeizuLightStatusBarImpl
    implements ILightStatusBar {
        MeizuLightStatusBarImpl() {
        }

        static boolean isMe() {
            return Build.BRAND.contains("Meizu");
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            WindowManager.LayoutParams params = window.getAttributes();
            try {
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(params);
                value = lightStatusBar ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(params, value);
                window.setAttributes(params);
                darkFlag.setAccessible(false);
                meizuFlags.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class MIUILightStatusBarImpl
    implements ILightStatusBar {
        MIUILightStatusBarImpl() {
        }

        static boolean isMe() {
            return "Xiaomi".equals(Build.MANUFACTURER);
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                extraFlagField.invoke((Object)window, lightStatusBar ? darkModeFlag : 0, darkModeFlag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static interface ILightStatusBar {
        public void setLightStatusBar(Window var1, boolean var2);
    }
}

