/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.githang.statusbar.StatusBarCompat;
import com.githang.statusbar.StatusBarCompatFlavorRom;

class StatusBarCompatKitkat {
    StatusBarCompatKitkat() {
    }

    @TargetApi(value=19)
    static void setStatusBarColor(Window window, int color, boolean lightStatusBar) {
        window.addFlags(0x4000000);
        ViewGroup decorViewGroup = (ViewGroup)window.getDecorView();
        View statusBarView = new View(window.getContext());
        int statusBarHeight = StatusBarCompatKitkat.getStatusBarHeight(window.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, statusBarHeight);
        params.gravity = 48;
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(color);
        decorViewGroup.addView(statusBarView);
        StatusBarCompat.setFitsSystemWindows(window, true);
        StatusBarCompatFlavorRom.setLightStatusBar(window, lightStatusBar);
    }

    private static int getStatusBarHeight(Context context) {
        int statusBarHeight = 0;
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = res.getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }
}

