/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.os.Build;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class StatusBarCompatFlavorRom {
    static final StatusBarImpl IMPL = MIUIStatusBarImpl.isMe() ? new MIUIStatusBarImpl() : (MeizuStatusBarImpl.isMe() ? new MeizuStatusBarImpl() : new DefaultStatusBarImpl());

    StatusBarCompatFlavorRom() {
    }

    static void setLightStatusBar(Window window, boolean lightStatusBar) {
        IMPL.setLightStatusBar(window, lightStatusBar);
    }

    static class DefaultStatusBarImpl
    implements StatusBarImpl {
        DefaultStatusBarImpl() {
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
        }
    }

    static class MeizuStatusBarImpl
    implements StatusBarImpl {
        MeizuStatusBarImpl() {
        }

        static boolean isMe() {
            try {
                Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
                return method != null;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            WindowManager.LayoutParams params = window.getAttributes();
            try {
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(params);
                value = lightStatusBar ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(params, value);
                window.setAttributes(params);
                darkFlag.setAccessible(false);
                meizuFlags.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class MIUIStatusBarImpl
    implements StatusBarImpl {
        MIUIStatusBarImpl() {
        }

        static boolean isMe() {
            return "Xiaomi".equals(Build.MANUFACTURER);
        }

        @Override
        public void setLightStatusBar(Window window, boolean lightStatusBar) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                extraFlagField.invoke((Object)window, lightStatusBar ? darkModeFlag : 0, darkModeFlag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static interface StatusBarImpl {
        public void setLightStatusBar(Window var1, boolean var2);
    }
}

