/*
 * Decompiled with CFR 0.152.
 */
package com.githang.statusbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.githang.statusbar.StatusBarCompat;

class StatusBarCompatKitkat {
    StatusBarCompatKitkat() {
    }

    @TargetApi(value=19)
    static void setStatusBarColor(Activity activity, int color, boolean lightStatusBar) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        Window win = activity.getWindow();
        ViewGroup decorViewGroup = (ViewGroup)win.getDecorView();
        View statusBarView = new View((Context)activity);
        int statusBarHeight = StatusBarCompatKitkat.getStatusBarHeight(activity);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, statusBarHeight);
        params.gravity = 48;
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(color);
        decorViewGroup.addView(statusBarView);
        StatusBarCompat.setFitsSystemWindows(activity, true);
    }

    private static int getStatusBarHeight(Activity activity) {
        int statusBarHeight = 0;
        Resources res = activity.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = res.getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }
}

