/*
 * Decompiled with CFR 0.152.
 */
package com.githang.groundrecycleradapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.githang.groundrecycleradapter.OnChildClickListener;
import com.githang.groundrecycleradapter.OnGroupClickListener;
import java.util.ArrayList;
import java.util.List;

public abstract class GroupRecyclerAdapter<G, GVH extends RecyclerView.ViewHolder, CVH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter {
    private static final int INVALID_POSITION = -1;
    private static final int TYPE_GROUP = 1;
    private static final int TYPE_CHILD = 2;
    private List<G> mGroups;
    private int mItemCount;
    private OnGroupClickListener mOnGroupClickListener;
    private OnChildClickListener mOnChildClickListener;

    public GroupRecyclerAdapter(List<G> groups) {
        this.mGroups = groups == null ? new ArrayList() : groups;
        this.updateItemCount();
    }

    public OnGroupClickListener getOnGroupClickListener() {
        return this.mOnGroupClickListener;
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public OnChildClickListener getOnChildClickListener() {
        return this.mOnChildClickListener;
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            GVH viewHolder = this.onCreateGroupViewHolder(parent);
            if (this.mOnGroupClickListener != null) {
                ((RecyclerView.ViewHolder)viewHolder).itemView.setOnClickListener(new View.OnClickListener((RecyclerView.ViewHolder)viewHolder){
                    final /* synthetic */ RecyclerView.ViewHolder val$viewHolder;
                    {
                        this.val$viewHolder = viewHolder;
                    }

                    public void onClick(View v) {
                        if (GroupRecyclerAdapter.this.mOnGroupClickListener != null) {
                            int itemPosition = this.val$viewHolder.getAdapterPosition();
                            int groupPosition = GroupRecyclerAdapter.this.getGroupChildPosition((int)itemPosition).group;
                            GroupRecyclerAdapter.this.mOnGroupClickListener.onGroupItemClick(v, groupPosition);
                        }
                    }
                });
            }
            return viewHolder;
        }
        CVH viewHolder = this.onCreateChildViewHolder(parent);
        if (this.mOnChildClickListener != null) {
            ((RecyclerView.ViewHolder)viewHolder).itemView.setOnClickListener(new View.OnClickListener((RecyclerView.ViewHolder)viewHolder){
                final /* synthetic */ RecyclerView.ViewHolder val$viewHolder;
                {
                    this.val$viewHolder = viewHolder;
                }

                public void onClick(View v) {
                    if (GroupRecyclerAdapter.this.mOnChildClickListener != null) {
                        int itemPosition = this.val$viewHolder.getAdapterPosition();
                        Position position = GroupRecyclerAdapter.this.getGroupChildPosition(itemPosition);
                        GroupRecyclerAdapter.this.mOnChildClickListener.onChildClick(v, position.group, position.child);
                    }
                }
            });
        }
        return viewHolder;
    }

    protected abstract GVH onCreateGroupViewHolder(ViewGroup var1);

    protected abstract CVH onCreateChildViewHolder(ViewGroup var1);

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int itemPosition) {
        Position position = this.getGroupChildPosition(itemPosition);
        if (position.child == -1) {
            this.onBindGroupViewHolder(holder, position.group);
        } else {
            this.onBindChildViewHolder(holder, position.group, position.child);
        }
    }

    protected Position getGroupChildPosition(int itemPosition) {
        int itemCount = 0;
        Position position = new Position();
        for (G g : this.mGroups) {
            if (itemPosition == itemCount) {
                position.child = -1;
                return position;
            }
            position.child = itemPosition - ++itemCount;
            int childCount = this.getChildCount(g);
            if (position.child < childCount) {
                return position;
            }
            itemCount += childCount;
            ++position.group;
        }
        return position;
    }

    protected abstract void onBindGroupViewHolder(GVH var1, int var2);

    protected abstract void onBindChildViewHolder(CVH var1, int var2, int var3);

    public int getItemCount() {
        return this.mItemCount;
    }

    public int getItemViewType(int position) {
        return this.getItemType(position) == ItemType.GROUP_TITLE ? 1 : 2;
    }

    private void updateItemCount() {
        int count = 0;
        for (G group : this.mGroups) {
            count += this.getChildCount(group) + 1;
        }
        this.mItemCount = count;
    }

    public int getGroupCount() {
        return this.mGroups.size();
    }

    protected abstract int getChildCount(G var1);

    public void add(List<G> groups) {
        int lastCount = this.getItemCount();
        this.addGroups(groups);
        this.updateItemCount();
        this.notifyItemRangeInserted(lastCount, this.mItemCount - lastCount);
    }

    public void update(List<G> groups) {
        this.mGroups.clear();
        this.addGroups(groups);
        this.updateItemCount();
        this.notifyDataSetChanged();
    }

    private void addGroups(List<G> groups) {
        if (groups != null) {
            this.mGroups.addAll(groups);
        }
    }

    public G getGroup(int groupPosition) {
        return this.mGroups.get(groupPosition);
    }

    public ItemType getItemType(int itemPosition) {
        int count = 0;
        for (G g : this.mGroups) {
            if (itemPosition == count) {
                return ItemType.GROUP_TITLE;
            }
            if (itemPosition == ++count) {
                return ItemType.FIRST_CHILD;
            }
            if (itemPosition >= (count += this.getChildCount(g))) continue;
            return ItemType.NOT_FIRST_CHILD;
        }
        throw new IllegalStateException("Could not find item type for item position " + itemPosition);
    }

    class Position {
        public int group;
        public int child = -1;

        Position() {
        }
    }

    static enum ItemType {
        GROUP_TITLE,
        FIRST_CHILD,
        NOT_FIRST_CHILD;

    }
}

