/*
 * Decompiled with CFR 0.152.
 */
package com.githang.groundrecycleradapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.githang.groundrecycleradapter.GroupRecyclerAdapter;
import com.githang.groundrecycleradapter.R;

public class GroupItemDecoration
extends RecyclerView.ItemDecoration {
    private GroupRecyclerAdapter mAdapter;
    private Drawable mGroupDivider;
    private Drawable mTitleDivider;
    private Drawable mChildDivider;
    private boolean mFirstDividerEnabled = true;
    private final Rect mBounds = new Rect();

    public GroupItemDecoration(GroupRecyclerAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void setGroupDivider(Drawable groupDivider) {
        this.mGroupDivider = groupDivider;
    }

    public void setTitleDivider(Drawable titleDivider) {
        this.mTitleDivider = titleDivider;
    }

    public void setChildDivider(Drawable childDivider) {
        this.mChildDivider = childDivider;
    }

    public void setFirstDividerEnabled(boolean enabled) {
        this.mFirstDividerEnabled = enabled;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        if (!this.mFirstDividerEnabled && position == 0) {
            return;
        }
        Drawable drawable = this.getDividerDrawable(position);
        if (drawable != null) {
            outRect.top = drawable.getIntrinsicHeight();
        }
        view.setTag(R.id.item_divider, (Object)drawable);
    }

    @Nullable
    private Drawable getDividerDrawable(int position) {
        GroupRecyclerAdapter.ItemType type = this.mAdapter.getItemType(position);
        switch (type) {
            case GROUP_TITLE: {
                return this.mGroupDivider;
            }
            case FIRST_CHILD: {
                return this.mTitleDivider;
            }
            case NOT_FIRST_CHILD: {
                return this.mChildDivider;
            }
        }
        return null;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        int right;
        int left;
        if (parent.getLayoutManager() == null) {
            return;
        }
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            parent.getDecoratedBoundsWithMargins(child, this.mBounds);
            Object object = child.getTag(R.id.item_divider);
            if (object == null || !(object instanceof Drawable)) continue;
            Drawable drawable = (Drawable)object;
            int top = this.mBounds.top + Math.round(child.getTranslationX());
            int bottom = this.mBounds.top + drawable.getIntrinsicHeight();
            drawable.setBounds(left, top, right, bottom);
            drawable.draw(canvas);
        }
        canvas.restore();
    }
}

