/*
 * Decompiled with CFR 0.152.
 */
package com.phillipcalvin.iconbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.CheckBox;
import com.phillipcalvin.iconbutton.CenterInterface;
import com.phillipcalvin.iconbutton.DrawablePositions;
import com.phillipcalvin.iconbutton.IconConfig;
import com.phillipcalvin.iconbutton.IconUtil;
import com.phillipcalvin.iconbutton.R;

public class IconCheckBox
extends CheckBox
implements CenterInterface {
    protected int drawableWidth;
    protected DrawablePositions drawablePosition;
    protected int iconPadding;
    protected int center;
    Rect bounds = new Rect();

    public IconCheckBox(Context context) {
        super(context);
    }

    public IconCheckBox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(attrs);
    }

    public IconCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.applyAttributes(attrs);
    }

    protected void applyAttributes(AttributeSet attrs) {
        if (null == this.bounds) {
            this.bounds = new Rect();
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.IconButton);
        int padding = typedArray.getDimensionPixelSize(R.styleable.IconButton_iconPadding, 0);
        int center = typedArray.getInt(R.styleable.IconButton_center, 0);
        this.iconPadding = padding;
        this.center = center;
        typedArray.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        TextPaint textPaint = this.getPaint();
        String text = this.getText().toString();
        textPaint.getTextBounds(text, 0, text.length(), this.bounds);
        int textWidth = this.bounds.width();
        IconConfig config = new IconConfig(this.center, textWidth, this.iconPadding, this.drawableWidth, this.drawablePosition);
        IconUtil.setCenter((Button)this, config);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
        if (null != left) {
            this.drawableWidth = left.getIntrinsicWidth();
            this.drawablePosition = DrawablePositions.LEFT;
        } else if (null != right) {
            this.drawableWidth = right.getIntrinsicWidth();
            this.drawablePosition = DrawablePositions.RIGHT;
        } else {
            this.drawablePosition = DrawablePositions.NONE;
        }
        this.requestLayout();
    }
}

