/*
 * Decompiled with CFR 0.152.
 */
package com.phillipcalvin.iconbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.Button;
import com.phillipcalvin.iconbutton.R;

public class IconButton
extends Button {
    private static final int CENTER_ALL = 0;
    private static final int CENTER_WITHOUT_DRAWABLE = 1;
    private static final int CENTER_TEXT_ONLY = 2;
    protected int drawableWidth;
    protected DrawablePositions drawablePosition;
    protected int iconPadding;
    protected int center;
    Rect bounds = new Rect();

    public IconButton(Context context) {
        super(context);
    }

    public IconButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(attrs);
    }

    public IconButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.applyAttributes(attrs);
    }

    protected void applyAttributes(AttributeSet attrs) {
        if (null == this.bounds) {
            this.bounds = new Rect();
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.IconButton);
        int paddingId = typedArray.getDimensionPixelSize(R.styleable.IconButton_iconPadding, 0);
        int center = typedArray.getInt(R.styleable.IconButton_center, 0);
        this.setIconPadding(paddingId, center);
        typedArray.recycle();
    }

    public void setIconPadding(int padding, int center) {
        this.iconPadding = padding;
        this.center = center;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        TextPaint textPaint = this.getPaint();
        String text = this.getText().toString();
        textPaint.getTextBounds(text, 0, text.length(), this.bounds);
        int textWidth = this.bounds.width();
        if (this.center == 1) {
            this.centerWithoutDrawable(textWidth);
        } else if (this.center == 2) {
            this.centerOnlyText(textWidth);
        } else {
            this.allCenter(textWidth);
        }
    }

    private void centerWithoutDrawable(int textWidth) {
        int contentWidth = this.iconPadding + textWidth;
        int contentLeft = (this.getWidth() - contentWidth) / 2;
        this.setCompoundDrawablePadding(-contentLeft + this.iconPadding);
        switch (this.drawablePosition) {
            case LEFT: {
                this.setPadding(contentLeft - this.drawableWidth, 0, 0, 0);
                break;
            }
            case RIGHT: {
                this.setPadding(0, 0, contentLeft - this.drawableWidth, 0);
                break;
            }
            default: {
                this.setPadding(0, 0, 0, 0);
            }
        }
    }

    private void centerOnlyText(int textWidth) {
        int contentLeft = (this.getWidth() - textWidth) / 2;
        this.setCompoundDrawablePadding(-contentLeft + this.iconPadding);
        switch (this.drawablePosition) {
            case LEFT: {
                this.setPadding(contentLeft - this.drawableWidth - this.iconPadding, 0, 0, 0);
                break;
            }
            case RIGHT: {
                this.setPadding(0, 0, contentLeft - this.drawableWidth - this.iconPadding, 0);
                break;
            }
            default: {
                this.setPadding(0, 0, 0, 0);
            }
        }
    }

    private void allCenter(int textWidth) {
        int contentWidth = this.drawableWidth + this.iconPadding + textWidth;
        int contentLeft = (this.getWidth() - contentWidth) / 2;
        this.setCompoundDrawablePadding(-contentLeft + this.iconPadding);
        switch (this.drawablePosition) {
            case LEFT: {
                this.setPadding(contentLeft, 0, 0, 0);
                break;
            }
            case RIGHT: {
                this.setPadding(0, 0, contentLeft, 0);
                break;
            }
            default: {
                this.setPadding(0, 0, 0, 0);
            }
        }
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
        if (null != left) {
            this.drawableWidth = left.getIntrinsicWidth();
            this.drawablePosition = DrawablePositions.LEFT;
        } else if (null != right) {
            this.drawableWidth = right.getIntrinsicWidth();
            this.drawablePosition = DrawablePositions.RIGHT;
        } else {
            this.drawablePosition = DrawablePositions.NONE;
        }
        this.requestLayout();
    }

    private static enum DrawablePositions {
        NONE,
        LEFT,
        RIGHT;

    }
}

