/*
 * Decompiled with CFR 0.152.
 */
package com.phillipcalvin.iconbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.Button;
import com.phillipcalvin.iconbutton.R;

public class IconButton
extends Button {
    protected int drawableWidth;
    protected DrawablePositions drawablePosition;
    protected int iconPadding;
    Rect bounds = new Rect();

    public IconButton(Context context) {
        super(context);
    }

    public IconButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(attrs);
    }

    public IconButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.applyAttributes(attrs);
    }

    protected void applyAttributes(AttributeSet attrs) {
        if (null == this.bounds) {
            this.bounds = new Rect();
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.IconButton);
        int paddingId = typedArray.getDimensionPixelSize(R.styleable.IconButton_iconPadding, 0);
        this.setIconPadding(paddingId);
        typedArray.recycle();
    }

    public void setIconPadding(int padding) {
        this.iconPadding = padding;
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        TextPaint textPaint = this.getPaint();
        String text = this.getText().toString();
        textPaint.getTextBounds(text, 0, text.length(), this.bounds);
        int textWidth = this.bounds.width();
        int contentWidth = this.drawableWidth + this.iconPadding + textWidth;
        int contentLeft = (int)((double)this.getWidth() / 2.0 - (double)contentWidth / 2.0);
        this.setCompoundDrawablePadding(-contentLeft + this.iconPadding);
        switch (this.drawablePosition) {
            case LEFT: {
                this.setPadding(contentLeft, 0, 0, 0);
                break;
            }
            case RIGHT: {
                this.setPadding(0, 0, contentLeft, 0);
                break;
            }
            default: {
                this.setPadding(0, 0, 0, 0);
            }
        }
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
        if (null != left) {
            this.drawableWidth = left.getIntrinsicWidth();
            this.drawablePosition = DrawablePositions.LEFT;
        } else if (null != right) {
            this.drawableWidth = right.getIntrinsicWidth();
            this.drawablePosition = DrawablePositions.RIGHT;
        } else {
            this.drawablePosition = DrawablePositions.NONE;
        }
        this.requestLayout();
    }

    private static enum DrawablePositions {
        NONE,
        LEFT,
        RIGHT;

    }
}

