/*
 * Decompiled with CFR 0.152.
 */
package com.yunianvh.libusbcamera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.rtmp.RtmpUsbCamera;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCCamera;
import com.serenegiant.utils.HandlerThreadHandler;
import com.yunianvh.libusbcamera.R;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class USBCameraHelper
implements SurfaceHolder.Callback {
    public static volatile USBCameraHelper mUSBCameraInit;
    private static final String TAG = "USBCameraHelper";
    private final Object mSync = new Object();
    private USBMonitor mUSBMonitor;
    private UVCCamera mUVCCamera;
    private Surface mPreviewSurface;
    private Context mContext;
    private Handler mWorkerHandler;
    private long mWorkerThreadID = -1L;
    private RtmpUsbCamera rtmpUsbCamera;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int bitrate = 0x300000;
    private int rotation = 0;
    private boolean isPreviewing = true;
    private boolean isTakePicture = false;
    private USBCameraCallBack usbCameraCallBack;
    private final USBMonitor.OnDeviceConnectListener mOnDeviceConnectListener = new USBMonitor.OnDeviceConnectListener(){

        @Override
        public void onAttach(UsbDevice device) {
            USBCameraHelper.this.doLog(USBCameraHelper.this.mContext.getResources().getString(R.string.msg_usb_device_attached));
            USBCameraHelper.this.requestPermission();
        }

        @Override
        public void onConnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
            USBCameraHelper.this.doLog("onConnect:" + device.getDeviceName() + " createNew:" + createNew);
            USBCameraHelper.this.releaseCamera();
            USBCameraHelper.this.queueEvent(() -> {
                UVCCamera camera = new UVCCamera();
                try {
                    camera.open(ctrlBlock);
                    if (USBCameraHelper.this.usbCameraCallBack != null) {
                        USBCameraHelper.this.usbCameraCallBack.onOpenCamera(true);
                    }
                }
                catch (UnsupportedOperationException e) {
                    USBCameraHelper.this.releaseCamera();
                    USBCameraHelper.this.doLog("onConnect UnsupportedOperationException:" + e);
                    if (USBCameraHelper.this.usbCameraCallBack != null) {
                        USBCameraHelper.this.usbCameraCallBack.onOpenCamera(false);
                    }
                    return;
                }
                catch (Exception e) {
                    USBCameraHelper.this.releaseCamera();
                    USBCameraHelper.this.doLog("onConnect Exception:" + e);
                    if (USBCameraHelper.this.usbCameraCallBack != null) {
                        USBCameraHelper.this.usbCameraCallBack.onOpenCamera(false);
                    }
                    return;
                }
                USBCameraHelper.this.setPreviewSize(camera, USBCameraHelper.this.width, USBCameraHelper.this.height);
                USBCameraHelper.this.releaseSurface();
                USBCameraHelper.this.initSurface();
                camera.setPreviewDisplay(USBCameraHelper.this.mPreviewSurface);
                camera.startPreview();
                Object object = USBCameraHelper.this.mSync;
                synchronized (object) {
                    USBCameraHelper.this.mUVCCamera = camera;
                }
            }, 0L);
        }

        @Override
        public void onDisconnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock) {
            USBCameraHelper.this.releaseCamera();
        }

        @Override
        public void onDettach(UsbDevice device) {
            USBCameraHelper.this.stopPreview();
            USBCameraHelper.this.doLog(USBCameraHelper.this.mContext.getResources().getString(R.string.msg_usb_device_detached));
        }

        @Override
        public void onCancel(UsbDevice device) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static USBCameraHelper getInstance() {
        if (mUSBCameraInit != null) return mUSBCameraInit;
        Class<USBCameraHelper> clazz = USBCameraHelper.class;
        synchronized (USBCameraHelper.class) {
            if (mUSBCameraInit != null) return mUSBCameraInit;
            mUSBCameraInit = new USBCameraHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mUSBCameraInit;
        }
    }

    public void setUSBCameraCallBack(USBCameraCallBack usbCameraCallBack) {
        this.usbCameraCallBack = usbCameraCallBack;
    }

    public void init(Context context, ConnectCheckerRtmp connectCheckerRtmp) {
        this.isPreviewing = false;
        this.mContext = context;
        this.rtmpUsbCamera = new RtmpUsbCamera(context, connectCheckerRtmp);
        this.init();
    }

    public void init(Context context, OpenGlView openGlView, ConnectCheckerRtmp connectCheckerRtmp) {
        this.isPreviewing = true;
        this.mContext = context;
        this.rtmpUsbCamera = new RtmpUsbCamera(openGlView, connectCheckerRtmp);
        openGlView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.init();
    }

    public void init(Context context, LightOpenGlView lightOpenGlView, ConnectCheckerRtmp connectCheckerRtmp) {
        this.isPreviewing = true;
        this.mContext = context;
        this.rtmpUsbCamera = new RtmpUsbCamera(lightOpenGlView, connectCheckerRtmp);
        lightOpenGlView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.init();
    }

    private void init() {
        if (this.mWorkerHandler == null) {
            this.mWorkerHandler = HandlerThreadHandler.createHandler(TAG);
            this.mWorkerThreadID = this.mWorkerHandler.getLooper().getThread().getId();
        }
        this.mUSBMonitor = new USBMonitor(this.mContext, this.mOnDeviceConnectListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.register();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUVCCamera != null) {
                this.mUVCCamera.startPreview();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = this.mSync;
        synchronized (object) {
            this.stopPreview();
            if (this.mUSBMonitor != null) {
                this.mUSBMonitor.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destory() {
        Object object = this.mSync;
        synchronized (object) {
            this.releaseCamera();
            if (this.mUSBMonitor != null) {
                this.mUSBMonitor.destroy();
                this.mUSBMonitor = null;
            }
        }
    }

    public void startRecord(String path) {
        if (!this.checkCameraOpened()) {
            return;
        }
        try {
            if (this.isStreaming()) {
                this.rtmpUsbCamera.startRecord(path, null);
            } else if (this.rtmpUsbCamera.prepareVideo(this.width, this.height, this.fps, this.bitrate, this.rotation) && this.rtmpUsbCamera.prepareAudio()) {
                this.rtmpUsbCamera.startRecord(path, null);
            }
            if (!this.isPreviewing && !this.isStreaming()) {
                this.doLog("\u4e0d\u5e26\u9884\u89c8\u65f6\u9700\u8981\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e0bSurface");
                this.startPreview();
            }
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public void startRecord(String path, RecordController.Listener listener) {
        if (!this.checkCameraOpened()) {
            return;
        }
        try {
            if (this.isStreaming()) {
                this.rtmpUsbCamera.startRecord(path, listener);
            } else if (this.rtmpUsbCamera.prepareVideo(this.width, this.height, this.fps, this.bitrate, this.rotation) && this.rtmpUsbCamera.prepareAudio()) {
                this.rtmpUsbCamera.startRecord(path, listener);
            }
            if (!this.isPreviewing && !this.isStreaming()) {
                this.doLog("\u4e0d\u5e26\u9884\u89c8\u65f6\u9700\u8981\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e0bSurface");
                this.startPreview();
            }
        }
        catch (IOException e) {
            listener.onStatusChange(RecordController.Status.STOPPED);
            e.getMessage();
        }
    }

    public void stopRecord() {
        if (!this.checkCameraOpened()) {
            return;
        }
        this.rtmpUsbCamera.stopRecord();
        if (!this.isPreviewing && !this.isStreaming()) {
            this.stopPreview();
        }
    }

    public boolean isRecording() {
        return this.rtmpUsbCamera.isRecording();
    }

    public void startStream(String url) {
        if (!this.checkCameraOpened()) {
            return;
        }
        if (this.isRecording()) {
            this.rtmpUsbCamera.startStream(url);
        } else if (this.rtmpUsbCamera.prepareVideo(this.width, this.height, this.fps, this.bitrate, this.rotation) && this.rtmpUsbCamera.prepareAudio()) {
            this.rtmpUsbCamera.startStream(url);
        }
        if (!this.isPreviewing && !this.isRecording()) {
            this.startPreview();
        }
    }

    public void stopStream() {
        if (!this.checkCameraOpened()) {
            return;
        }
        this.rtmpUsbCamera.stopStream();
        if (!this.isPreviewing && !this.isRecording()) {
            this.stopPreview();
        }
    }

    public boolean isStreaming() {
        return this.rtmpUsbCamera.isStreaming();
    }

    public void takePicture(PictureBack picCallBack) {
        if (!this.checkCameraOpened()) {
            return;
        }
        long delayMillis = 0L;
        if (!(this.isPreviewing || this.isStreaming() || this.isRecording())) {
            this.isTakePicture = true;
            this.startPreview();
            delayMillis = 5000L;
        }
        this.mWorkerHandler.postDelayed(() -> {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                this.mUVCCamera.setFrameCallback(frame -> {
                    byte[] yuv = new byte[frame.capacity()];
                    frame.get(yuv);
                    YuvImage yuvImage = new YuvImage(yuv, 17, this.width, this.height, null);
                    yuvImage.compressToJpeg(new Rect(0, 0, this.width, this.height), 100, (OutputStream)stream);
                    Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                    if (picCallBack != null) {
                        picCallBack.onPictureBitMap(bmp);
                    }
                    this.mUVCCamera.setFrameCallback(null, 4);
                    if (!(this.isPreviewing || this.isStreaming() || this.isRecording())) {
                        this.stopPreview();
                        this.isTakePicture = false;
                    }
                }, 4);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, delayMillis);
    }

    public List<UsbDevice> getDeviceList() {
        List<DeviceFilter> filter = DeviceFilter.getDeviceFilters(this.mContext, R.xml.device_filter);
        List<UsbDevice> deviceList = this.mUSBMonitor.getDeviceList(filter);
        return deviceList;
    }

    public boolean checkCameraOpened() {
        if (this.mUVCCamera == null) {
            this.doLog(this.mContext.getResources().getString(R.string.msg_camera_open_fail));
            return false;
        }
        if (this.rtmpUsbCamera == null) {
            this.doLog("RtmpUsbCamera \u672a\u521d\u59cb\u5316");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startPreview() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUVCCamera != null) {
                this.releaseSurface();
                this.initSurface();
                this.mUVCCamera.setPreviewDisplay(this.mPreviewSurface);
                this.mUVCCamera.startPreview();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopPreview() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUVCCamera != null) {
                this.mUVCCamera.stopPreview();
            }
            this.rtmpUsbCamera.stopPreview(this.isTakePicture);
        }
    }

    public void setPreviewSize(int width, int height, int bitrate, int rotation) {
        if (!this.checkCameraOpened()) {
            return;
        }
        this.bitrate = bitrate;
        this.rotation = rotation;
        this.setPreviewSize(this.mUVCCamera, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPreviewSize(UVCCamera camera, int width, int height) {
        if (camera == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            this.width = width;
            this.height = height;
            this.doLog("setPreviewSize width:" + width + " height:" + height);
            try {
                camera.setPreviewSize(width, height, 1);
            }
            catch (IllegalArgumentException e) {
                try {
                    camera.setPreviewSize(width, height, 0);
                }
                catch (IllegalArgumentException e1) {
                    camera.destroy();
                    this.doLog("setPreviewSize IllegalArgumentException:" + e1);
                    if (this.usbCameraCallBack != null) {
                        this.usbCameraCallBack.onPreview(false);
                    }
                    return;
                }
            }
            if (this.usbCameraCallBack != null) {
                this.usbCameraCallBack.onPreview(true);
            }
        }
    }

    private void initSurface() {
        if (this.rtmpUsbCamera == null) {
            return;
        }
        if (this.rtmpUsbCamera.isOnPreview()) {
            this.rtmpUsbCamera.stopStream();
        }
        this.rtmpUsbCamera.startPreview(this.width, this.height, this.isTakePicture);
        SurfaceTexture st = this.rtmpUsbCamera.getGlInterface().getSurfaceTexture();
        if (st != null) {
            this.mPreviewSurface = new Surface(st);
        }
        if (this.mPreviewSurface == null) {
            this.doLog("\u672a\u521d\u59cb\u5316\u9884\u89c8\u63a7\u4ef6  Surface:" + (st != null));
        }
    }

    private void releaseSurface() {
        if (this.mPreviewSurface == null) {
            return;
        }
        this.mPreviewSurface.release();
        this.mPreviewSurface = null;
    }

    private void requestPermission() {
        List<DeviceFilter> filter = DeviceFilter.getDeviceFilters(this.mContext, R.xml.device_filter);
        List<UsbDevice> deviceList = this.mUSBMonitor.getDeviceList(filter);
        if (deviceList == null || deviceList.size() == 0) {
            return;
        }
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.requestPermission(deviceList.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseCamera() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUVCCamera != null) {
                try {
                    this.mUVCCamera.setStatusCallback(null);
                    this.mUVCCamera.setButtonCallback(null);
                    this.mUVCCamera.close();
                    this.mUVCCamera.destroy();
                }
                catch (Exception e) {
                    this.doLog("releaseCamera:" + e);
                }
                this.mUVCCamera = null;
            }
            this.releaseSurface();
        }
    }

    protected final synchronized void queueEvent(Runnable task, long delayMillis) {
        if (task == null || this.mWorkerHandler == null) {
            return;
        }
        try {
            this.mWorkerHandler.removeCallbacks(task);
            if (delayMillis > 0L) {
                this.mWorkerHandler.postDelayed(task, delayMillis);
            } else if (this.mWorkerThreadID == Thread.currentThread().getId()) {
                task.run();
            } else {
                this.mWorkerHandler.post(task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
        this.doLog("surfaceChanged:" + i1 + " " + i2);
        this.rtmpUsbCamera.startPreview(this.width, this.height, this.isTakePicture);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.doLog("surfaceDestroyed");
        this.rtmpUsbCamera.stopPreview(this.isTakePicture);
    }

    private void doLog(String msg) {
        Log.e((String)TAG, (String)msg);
    }

    public static interface PictureBack {
        public void onPictureBitMap(Bitmap var1);
    }

    public static interface USBCameraCallBack {
        public void onOpenCamera(boolean var1);

        public void onPreview(boolean var1);
    }
}

