/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class UVCCameraTextureView
extends TextureView {
    private static final String TAG = "UVCCameraTextureView";
    private int mLayoutWidth;
    private int mLayoutHeight;
    private float mAspectRatio;
    private float mLayoutAspectRatio;
    private int mRotation = 0;
    private int mScaleX = 1;
    private int mScaleY = 1;
    private TransState mTransState = TransState.FRONT_UP;
    private OnTransStateChangeListener mListener = null;

    public void setOnTransStateChangeListener(OnTransStateChangeListener listener) {
        this.mListener = listener;
    }

    public UVCCameraTextureView(Context context) {
        this(context, null, 0);
    }

    public UVCCameraTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UVCCameraTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAspectRatio(float aspectRatio, int layoutWidth, int layoutHeight) {
        this.mAspectRatio = aspectRatio;
        this.mLayoutWidth = layoutWidth;
        this.mLayoutHeight = layoutHeight;
        this.mLayoutAspectRatio = (float)layoutHeight / (float)layoutWidth;
        this.setHeightWidth();
    }

    public void rightRotate() {
        this.mRotation += 90;
        if (this.mRotation == 360) {
            this.mRotation = 0;
        }
        this.setHeightWidth();
        this.setRotation(this.mRotation);
        this.setTransState(TransState.CUSTOM);
    }

    public void leftRotate() {
        this.mRotation -= 90;
        if (this.mRotation == -90) {
            this.mRotation = 270;
        }
        this.setHeightWidth();
        this.setRotation(this.mRotation);
        this.setTransState(TransState.CUSTOM);
    }

    public void toggleMirror() {
        if (this.mRotation == 0 || this.mRotation == 180) {
            this.mScaleX = -this.mScaleX;
            this.setScaleX(this.mScaleX);
        } else {
            this.mScaleY = -this.mScaleY;
            this.setScaleY(this.mScaleY);
        }
        this.setTransState(TransState.CUSTOM);
    }

    public void setPosition(TransState state) {
        boolean mirrored = false;
        switch (state) {
            case CUSTOM: {
                return;
            }
            case BACK_UP: {
                this.mRotation = 0;
                this.mScaleX = -1;
                this.mScaleY = 1;
                break;
            }
            case FRONT_UP: {
                this.mRotation = 0;
                this.mScaleX = 1;
                this.mScaleY = 1;
                break;
            }
            case BACK_DOWN: {
                this.mRotation = 180;
                this.mScaleX = -1;
                this.mScaleY = 1;
                break;
            }
            case FRONT_DOWN: {
                this.mRotation = 180;
                this.mScaleX = 1;
                this.mScaleY = 1;
                break;
            }
            case BACK_LEFT: {
                this.mRotation = 270;
                this.mScaleX = 1;
                this.mScaleY = -1;
                break;
            }
            case FRONT_LEFT: {
                this.mRotation = 270;
                this.mScaleX = 1;
                this.mScaleY = 1;
                break;
            }
            case BACK_RIGHT: {
                this.mRotation = 90;
                this.mScaleX = 1;
                this.mScaleY = -1;
                break;
            }
            case FRONT_RIGHT: {
                this.mRotation = 90;
                this.mScaleX = 1;
                this.mScaleY = 1;
            }
        }
        this.setHeightWidth();
        this.setRotation(this.mRotation);
        this.setScaleX(this.mScaleX);
        this.setScaleY(this.mScaleY);
        this.setTransState(state);
    }

    public Bitmap getBitmap() {
        Bitmap origin = super.getBitmap();
        int width = origin.getWidth();
        int height = origin.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(this.getScaleX(), this.getScaleY());
        matrix.postRotate((float)this.mRotation);
        Bitmap resmap = Bitmap.createBitmap((Bitmap)origin, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        return resmap;
    }

    private void setTransState(TransState state) {
        if (this.mTransState != state) {
            this.mTransState = state;
            if (this.mListener != null) {
                this.mListener.onTransStateChange(state);
            }
        }
    }

    private void setHeightWidth() {
        int height;
        int width;
        if (this.mRotation == 0 || this.mRotation == 180) {
            width = this.mLayoutWidth;
            height = (int)((float)this.mLayoutWidth / this.mAspectRatio);
        } else if (this.mLayoutAspectRatio > this.mAspectRatio) {
            height = this.mLayoutWidth;
            width = (int)((float)this.mLayoutWidth * this.mAspectRatio);
        } else {
            height = (int)((float)this.mLayoutHeight / this.mAspectRatio);
            width = this.mLayoutHeight;
        }
        Log.i((String)TAG, (String)("height:" + String.valueOf(height) + ",width:" + String.valueOf(width)));
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height, 17));
    }

    public static interface OnTransStateChangeListener {
        public void onTransStateChange(TransState var1);
    }

    public static enum TransState {
        CUSTOM,
        FRONT_UP,
        FRONT_DOWN,
        FRONT_RIGHT,
        FRONT_LEFT,
        BACK_UP,
        BACK_DOWN,
        BACK_RIGHT,
        BACK_LEFT;

    }
}

