/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.video.CameraCallBack;
import com.pedro.rtplibrary.util.LocalLog;
import com.pedro.rtplibrary.util.Mp4AppendUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RecordController {
    private static final String TAG = "RecordController";
    private Status status = Status.STOPPED;
    private MediaMuxer mediaMuxer;
    private MediaMuxer mediaMuxer2;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private Listener listener;
    private long pauseMoment = 0L;
    private long pauseTime = 0L;
    private final MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private final MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();
    private String videoMime = "video/avc";
    private boolean isOnlyAudio = false;
    private boolean isOnlyVideo = false;
    private CameraCallBack callbacks;
    private boolean isSplitVideo = false;
    private String new_path = "";
    private String old_path = "";
    private String path;
    private String base_path = "";
    private int index = 0;
    private int video_length = 10000;
    private int delay_off = 5;
    private SharedPreferences preferences;
    private ArrayList<String> mp4AppendingPathList;
    private File mp4AppendLog;
    private boolean isAppen = true;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(50, 100, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("videoPool");
            return thread;
        }
    });
    private final FileFilter videoFilter = file -> file.getName().toLowerCase().endsWith(".mp4") && file.getName().length() > 16 && !file.isHidden() && file.getName().contains("-");
    private boolean isAppend = false;
    Handler handler = new Handler(){

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (RecordController.this.status == Status.STOPPED) {
                return;
            }
            if (RecordController.this.lastTimeVideoWrite > 0L && System.currentTimeMillis() - RecordController.this.lastTimeVideoWrite > 10000L) {
                LocalLog.e(RecordController.TAG, "recordAudio  \u8fde\u7eed10\u79d2\u6ca1\u7528\u89c6\u9891\u6570\u636e\uff0c\u5173\u95ed\u5f55\u5236\u540e\u91cd\u65b0\u5f55\u5236 old_path:" + RecordController.this.old_path);
                RecordController.this.stopRecord();
                if (RecordController.this.callbacks != null) {
                    RecordController.this.callbacks.onCameraError("\u72b6\u6001\u662f\u5f55\u5236\u4e2d\uff0c\u4f46\u8fde\u7eed1\u5206\u949f\u6ca1\u89c6\u9891\u6570\u636e");
                }
                return;
            }
            if (msg.what == 0) {
                if (!TextUtils.isEmpty((CharSequence)RecordController.this.new_path) && !RecordController.this.old_path.equals(RecordController.this.new_path)) {
                    RecordController.this.isAppend = true;
                    RecordController.this.old_path = RecordController.this.new_path;
                    RecordController.this.getBasePath(RecordController.this.new_path);
                    if (RecordController.this.index % 2 != 0) {
                        RecordController.this.index = 1;
                        RecordController.this.index++;
                        RecordController.this.preferences.edit().putInt("index", RecordController.this.index).commit();
                        RecordController.this.path = RecordController.this.base_path + "-" + RecordController.this.index + ".mp4";
                        RecordController.this.startMediaMuxer2();
                        String logPathName = RecordController.this.getLogPathName(RecordController.this.base_path + "-" + RecordController.this.index);
                        RecordController.this.saveEmptyFile(RecordController.this.mp4AppendLog.getAbsolutePath(), logPathName);
                        RecordController.this.handler.removeMessages(1);
                        RecordController.this.handler.sendEmptyMessageDelayed(1, (long)RecordController.this.delay_off);
                    } else {
                        RecordController.this.index = 0;
                        RecordController.this.index++;
                        RecordController.this.preferences.edit().putInt("index", RecordController.this.index).commit();
                        RecordController.this.path = RecordController.this.base_path + "-" + RecordController.this.index + ".mp4";
                        String logPathName = RecordController.this.getLogPathName(RecordController.this.base_path + "-" + RecordController.this.index);
                        RecordController.this.saveEmptyFile(RecordController.this.mp4AppendLog.getAbsolutePath(), logPathName);
                        RecordController.this.startMediaMuxer();
                        RecordController.this.handler.removeMessages(2);
                        RecordController.this.handler.sendEmptyMessageDelayed(2, (long)RecordController.this.delay_off);
                    }
                    RecordController.this.handler.removeMessages(0);
                    RecordController.this.handler.sendEmptyMessageDelayed(0, (long)RecordController.this.video_length);
                    return;
                }
                RecordController.this.index++;
                RecordController.this.preferences.edit().putInt("index", RecordController.this.index).commit();
                RecordController.this.path = RecordController.this.base_path + "-" + RecordController.this.index + ".mp4";
                String logPathName = RecordController.this.getLogPathName(RecordController.this.base_path + "-" + RecordController.this.index);
                RecordController.this.saveEmptyFile(RecordController.this.mp4AppendLog.getAbsolutePath(), logPathName);
                if (RecordController.this.index % 2 != 0) {
                    RecordController.this.startMediaMuxer();
                    if (RecordController.this.index != 1) {
                        RecordController.this.handler.removeMessages(2);
                        RecordController.this.handler.sendEmptyMessageDelayed(2, (long)RecordController.this.delay_off);
                    }
                } else {
                    RecordController.this.startMediaMuxer2();
                    if (RecordController.this.index != 1) {
                        RecordController.this.handler.removeMessages(1);
                        RecordController.this.handler.sendEmptyMessageDelayed(1, (long)RecordController.this.delay_off);
                    }
                }
                RecordController.this.handler.removeMessages(0);
                RecordController.this.handler.sendEmptyMessageDelayed(0, (long)RecordController.this.video_length);
            } else if (msg.what == 1) {
                RecordController.this.stopMediaMuxer();
            } else if (msg.what == 2) {
                RecordController.this.stopMediaMuxer2();
            }
        }
    };
    private boolean isMediaMuxer2 = false;
    private boolean isMediaMuxer = false;
    private long lastTimeVideoWrite = 0L;

    public void setIsAppen(boolean isAppen) {
        this.isAppen = isAppen;
    }

    public void setSplitVideo(Context context, boolean isSplitVideo, int video_length, int delay_off, CameraCallBack callbacks) {
        if (this.preferences != null) {
            return;
        }
        Log.e((String)TAG, (String)("setSplitVideo----\u662f\u5426\u5206\u7247\u4fdd\u5b58: " + isSplitVideo + "---\u7247\u6bb5\u89c6\u9891\u65f6\u957f: " + video_length + "---\u5ef6\u65f6\u5173\u95ed\uff08\u6beb\u79d2\uff09\uff1a" + delay_off));
        this.isSplitVideo = isSplitVideo;
        this.video_length = video_length * 1000;
        this.delay_off = delay_off;
        this.callbacks = callbacks;
        this.mp4AppendLog = new File(context.getExternalFilesDir(null).getAbsolutePath() + File.separator + "mp4AppendLog");
        if (!this.mp4AppendLog.exists()) {
            this.mp4AppendLog.mkdir();
        }
        this.mp4AppendingPathList = new ArrayList();
        this.preferences = context.getSharedPreferences("VIDEO_SPLIT_TAG", 0);
        String b_path = this.preferences.getString("base_path", "");
        int videoNum = this.preferences.getInt("index", 0);
        this.appendMp4List(b_path, videoNum);
        if (!this.isRecording()) {
            if (TextUtils.isEmpty((CharSequence)this.base_path)) {
                this.base_path = b_path;
            }
            this.queryAppendFile();
        }
    }

    public void setNewPath(String new_path) {
        if (TextUtils.isEmpty((CharSequence)new_path)) {
            return;
        }
        this.new_path = new_path;
        if (!this.isSplitVideo) {
            this.stopMediaMuxer();
            if (this.callbacks != null) {
                this.callbacks.onRecordSuccessPath(this.path);
            }
            this.path = new_path;
            this.startMediaMuxer();
        } else {
            this.handler.removeMessages(0);
            this.handler.sendEmptyMessageDelayed(0, (long)this.delay_off);
        }
    }

    private void appendMp4List(String b_path, int videoNum) {
        try {
            if (!this.isAppen) {
                return;
            }
            if (b_path == null || "".equals(b_path)) {
                return;
            }
            if (this.base_path.equals(b_path)) {
                return;
            }
            if (videoNum <= 0) {
                return;
            }
            if (this.isSppendPath(b_path)) {
                return;
            }
            this.mp4AppendingPathList.add(b_path);
            this.poolExecutor.execute(() -> {
                File p;
                Log.e((String)TAG, (String)("appendMp4List=========================\u5f00\u59cb\u5408\u5e76\u8def\u5f84====================:" + b_path + "  \u5e94\u5408\u5e76\u6570\u91cf: " + videoNum));
                ArrayList<String> mp4PathList = new ArrayList<String>();
                for (int i = 0; i <= videoNum; ++i) {
                    String p2 = b_path + "-" + i + ".mp4";
                    if (!new File(p2).exists()) continue;
                    mp4PathList.add(p2);
                }
                String logPathName = this.getLogPathName(b_path + "-" + videoNum);
                if (mp4PathList.isEmpty()) {
                    this.removeMp4AppendingPath(b_path);
                    this.deleteFile(this.mp4AppendLog.getAbsolutePath() + File.separator + logPathName);
                    return;
                }
                this.saveEmptyFile(this.mp4AppendLog.getAbsolutePath(), logPathName);
                Log.e((String)TAG, (String)(b_path + ".mp4   \u8fc7\u6ee4\u6389\u4e0d\u53ef\u5408\u5e76\u89c6\u9891\u540e\u5269\u4f59\u6570\u91cf:  " + mp4PathList.size()));
                Mp4AppendUtil videoComposer = new Mp4AppendUtil(mp4PathList, b_path + ".mp4", this.delay_off);
                boolean isOk = videoComposer.joinVideo();
                Log.e((String)TAG, (String)("appendMp4List======================\u7ed3\u675f\u5408\u5e76====================\u5408\u5e76\u89c6\u9891\u662f\u5426\u6210\u529f:  " + isOk + "    \u5408\u5e76\u8def\u5f84:" + b_path));
                if (isOk && (p = new File(b_path + ".mp4")).exists() && p.length() > 100L && this.callbacks != null) {
                    this.callbacks.onRecordSuccessPath(b_path + ".mp4");
                }
                this.deleteFile(this.mp4AppendLog.getAbsolutePath() + File.separator + logPathName);
                this.removeMp4AppendingPath(b_path);
                this.deleteErrorVideo(b_path);
            });
        }
        catch (RejectedExecutionException e) {
            Log.e((String)TAG, (String)("\u5408\u5e76\u89c6\u9891\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
        catch (ConcurrentModificationException e) {
            Log.e((String)TAG, (String)("\u5408\u5e76\u89c6\u9891\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u5408\u5e76\u89c6\u9891\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
    }

    private boolean isSppendPath(String path) {
        try {
            if (this.mp4AppendingPathList == null || this.mp4AppendingPathList.isEmpty()) {
                return false;
            }
            for (String videoPath : this.mp4AppendingPathList) {
                if (!path.equals(videoPath)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException e) {
            Log.e((String)TAG, (String)("\u68c0\u67e5\u8def\u5f84\u662f\u5426\u5728\u5408\u5e76\u4e2d\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u68c0\u67e5\u8def\u5f84\u662f\u5426\u5728\u5408\u5e76\u4e2d\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
        return false;
    }

    private void removeMp4AppendingPath(String path) {
        try {
            if (this.mp4AppendingPathList == null || this.mp4AppendingPathList.isEmpty()) {
                return;
            }
            Iterator<String> appendPaths2 = this.mp4AppendingPathList.iterator();
            while (appendPaths2.hasNext()) {
                String videoPath = appendPaths2.next();
                if (!path.equals(videoPath)) continue;
                appendPaths2.remove();
            }
        }
        catch (ConcurrentModificationException e) {
            Log.e((String)TAG, (String)("\u5408\u5e76\u5b8c\u6210\uff0c\u79fb\u9664\u5408\u5e76\u4e2d\u8def\u5f84\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u5408\u5e76\u5b8c\u6210\uff0c\u79fb\u9664\u5408\u5e76\u4e2d\u8def\u5f84\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
    }

    private String getLogPathName(String logPath) {
        try {
            String[] paths = logPath.split("[/]");
            return paths[paths.length - 1];
        }
        catch (NullPointerException e) {
            File f = new File(logPath + ".mp4");
            if (f.exists()) {
                return f.getName().substring(0, f.getName().length() - 4);
            }
            return null;
        }
    }

    private String getRecordDirectory(String base_path) {
        try {
            String[] paths = base_path.split("[/]");
            return base_path.substring(0, base_path.length() - paths[paths.length - 1].length());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private void saveEmptyFile(String path, String emptyFileName) {
        File saveFile = new File(path, emptyFileName);
        if (!saveFile.exists()) {
            File[] files;
            String[] names = emptyFileName.split("[-]");
            if (names.length > 0 && (files = new File(path).listFiles()).length > 0) {
                for (File f : files) {
                    if (!f.getName().contains(names[0])) continue;
                    f.delete();
                    break;
                }
            }
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteErrorVideo(String path) {
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                return;
            }
            int index = path.lastIndexOf("/");
            String base_p = path.substring(0, index);
            String name = path.substring(index + 1);
            Log.e((String)TAG, (String)("deleteErrorVideo  base_p: " + base_p + "  name:" + name));
            File videoFolder = new File(base_p);
            File[] listFiles = videoFolder.listFiles(this.videoFilter);
            Log.e((String)TAG, (String)("deleteErrorVideo   length: " + listFiles.length));
            for (File f : listFiles) {
                if (!f.getName().startsWith(name)) continue;
                Log.e((String)TAG, (String)("\u5220\u9664\u89c6\u9891 deleteName:" + name + "   path:" + f.getAbsolutePath()));
                f.delete();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u5220\u9664\u9519\u8bef\u89c6\u9891\u51fa\u73b0\u5f02\u5e38:  " + e));
        }
    }

    private void deleteFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
    }

    private void queryAppendFile() {
        if (this.mp4AppendLog == null) {
            return;
        }
        File[] fs = this.mp4AppendLog.listFiles();
        if (fs == null) {
            return;
        }
        for (File f : fs) {
            String name = f.getName();
            String[] names = name.split("-");
            if (names == null || names.length != 2) continue;
            String b = this.getRecordDirectory(this.base_path);
            if (!TextUtils.isEmpty((CharSequence)b)) {
                this.appendMp4List(b + names[0], Integer.parseInt(names[1]));
                continue;
            }
            String b2 = this.getRecordDirectory(this.path);
            if (!TextUtils.isEmpty((CharSequence)b2)) {
                this.appendMp4List(b2 + names[0], Integer.parseInt(names[1]));
                continue;
            }
            Log.e((String)TAG, (String)"queryAppendFile  base_path\u548cpath\u90fd\u6ca1\u6709\uff0c\u6ca1\u529e\u6cd5\u8fdb\u884c\u5408\u5e76");
        }
    }

    public void getBasePath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        this.base_path = path.substring(0, path.length() - 4);
        this.preferences.edit().putString("base_path", this.base_path).commit();
    }

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable Listener listener) throws IOException {
        if (this.isSplitVideo) {
            if (!this.old_path.equals(path)) {
                String b_path = this.preferences.getString("base_path", "");
                int videoNum = this.preferences.getInt("index", 0);
                this.appendMp4List(b_path, videoNum);
                this.index = 1;
                this.getBasePath(path);
                this.old_path = path;
                this.new_path = "";
                this.preferences.edit().putInt("index", this.index).commit();
                this.path = this.base_path + "-" + this.index + ".mp4";
                String logPathName = this.getLogPathName(this.base_path + "-" + this.index);
                this.saveEmptyFile(this.mp4AppendLog.getAbsolutePath(), logPathName);
            }
        } else {
            this.path = path;
        }
        this.isMediaMuxer = true;
        this.mediaMuxer = new MediaMuxer(this.path, 0);
        this.listener = listener;
        this.status = Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.isOnlyAudio && this.audioFormat != null) {
            this.init();
        }
        if (this.isSplitVideo) {
            this.handler.sendEmptyMessageDelayed(0, (long)this.video_length);
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable Listener listener) throws IOException {
        this.mediaMuxer = new MediaMuxer(fd, 0);
        this.listener = listener;
        this.status = Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.isOnlyAudio && this.audioFormat != null) {
            this.init();
        }
    }

    private void startMediaMuxer() {
        try {
            if (this.videoFormat == null || this.audioFormat == null) {
                LocalLog.e(TAG, "startMediaMuxer  \u89c6\u9891\u6570\u636e  videoFormat == null || audioFormat == null old_path:" + this.old_path);
                this.stopRecord();
                return;
            }
            this.mediaMuxer = new MediaMuxer(this.path, 0);
            this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
            this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
            this.mediaMuxer.start();
            this.isMediaMuxer = true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startMediaMuxer2() {
        try {
            if (this.videoFormat == null || this.audioFormat == null) {
                LocalLog.e(TAG, "startMediaMuxer2  \u89c6\u9891\u6570\u636e  videoFormat == null || audioFormat == null old_path:" + this.old_path);
                this.stopRecord();
                return;
            }
            this.mediaMuxer2 = new MediaMuxer(this.path, 0);
            this.videoTrack = this.mediaMuxer2.addTrack(this.videoFormat);
            this.audioTrack = this.mediaMuxer2.addTrack(this.audioFormat);
            this.mediaMuxer2.start();
            this.isMediaMuxer2 = true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean stopMediaMuxer() {
        if (this.mediaMuxer != null) {
            try {
                this.isMediaMuxer = false;
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
                if (this.isAppend) {
                    this.handler.postDelayed(() -> {
                        this.queryAppendFile();
                        this.isAppend = false;
                    }, 1000L);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean stopMediaMuxer2() {
        if (this.mediaMuxer2 != null) {
            try {
                this.isMediaMuxer2 = false;
                this.mediaMuxer2.stop();
                this.mediaMuxer2.release();
                if (this.isAppend) {
                    this.handler.postDelayed(() -> {
                        this.queryAppendFile();
                        this.isAppend = false;
                    }, 1000L);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.status = Status.STOPPED;
        this.videoTrack = -1;
        this.audioTrack = -1;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.lastTimeVideoWrite = 0L;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
        this.handler.removeMessages(0);
        this.handler.removeMessages(1);
        this.handler.removeMessages(2);
        if (this.stopMediaMuxer() || this.stopMediaMuxer2()) {
            this.base_path = this.base_path + "0";
            this.handler.postDelayed(() -> this.queryAppendFile(), 1000L);
        } else {
            File f = new File(this.base_path + "-" + this.index + ".mp4");
            if (f.exists()) {
                f.delete();
            }
        }
    }

    public void setVideoMime(String videoMime) {
        this.videoMime = videoMime;
    }

    public boolean isRunning() {
        return this.status == Status.STARTED || this.status == Status.RECORDING || this.status == Status.RESUMED || this.status == Status.PAUSED;
    }

    public boolean isRecording() {
        return this.status == Status.RECORDING;
    }

    public Status getStatus() {
        return this.status;
    }

    public void resetFormats() {
        this.videoFormat = null;
        this.audioFormat = null;
    }

    public void pauseRecord() {
        if (this.status == Status.RECORDING) {
            this.pauseMoment = System.nanoTime() / 1000L;
            this.status = Status.PAUSED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    public void resumeRecord() {
        if (this.status == Status.PAUSED) {
            this.pauseTime += System.nanoTime() / 1000L - this.pauseMoment;
            this.status = Status.RESUMED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    private boolean isKeyFrame(ByteBuffer videoBuffer) {
        byte[] header2 = new byte[5];
        videoBuffer.duplicate().get(header2, 0, header2.length);
        if (this.videoMime.equals("video/avc") && (header2[4] & 0x1F) == 5) {
            return true;
        }
        return this.videoMime.equals("video/hevc") && (header2[4] >> 1 & 0x3F) == 19 || (header2[4] >> 1 & 0x3F) == 20;
    }

    @RequiresApi(api=18)
    private void write(int track, ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        try {
            if (this.isMediaMuxer) {
                this.mediaMuxer.writeSampleData(track, byteBuffer, info);
            } else if (this.isMediaMuxer2) {
                this.mediaMuxer2.writeSampleData(track, byteBuffer, info);
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            Log.e((String)TAG, (String)"Write error \uff1a", (Throwable)e);
        }
    }

    @RequiresApi(api=18)
    private void init() {
        if (!this.isOnlyVideo) {
            this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        }
        this.mediaMuxer.start();
        this.status = Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @RequiresApi(api=18)
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
        if (this.status == Status.STARTED && this.videoFormat != null && (this.audioFormat != null || this.isOnlyVideo)) {
            if (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer)) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
                this.init();
            }
        } else if (this.status == Status.RESUMED && (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer))) {
            this.status = Status.RECORDING;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
        if (this.status == Status.RECORDING) {
            this.lastTimeVideoWrite = System.currentTimeMillis();
            this.updateFormat(this.videoInfo, videoInfo);
            this.write(this.videoTrack, videoBuffer, this.videoInfo);
        }
    }

    @RequiresApi(api=18)
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == Status.RECORDING) {
            this.updateFormat(this.audioInfo, audioInfo);
            this.write(this.audioTrack, audioBuffer, this.audioInfo);
        }
    }

    public void setVideoFormat(MediaFormat videoFormat, boolean isOnlyVideo) {
        this.videoFormat = videoFormat;
        this.isOnlyVideo = isOnlyVideo;
    }

    public void setAudioFormat(MediaFormat audioFormat, boolean isOnlyAudio) {
        this.audioFormat = audioFormat;
        this.isOnlyAudio = isOnlyAudio;
        if (isOnlyAudio && this.status == Status.STARTED && Build.VERSION.SDK_INT >= 18) {
            this.init();
        }
    }

    public void setVideoFormat(MediaFormat videoFormat) {
        this.setVideoFormat(videoFormat, false);
    }

    public void setAudioFormat(MediaFormat audioFormat) {
        this.setAudioFormat(audioFormat, false);
    }

    private void updateFormat(MediaCodec.BufferInfo newInfo, MediaCodec.BufferInfo oldInfo) {
        newInfo.flags = oldInfo.flags;
        newInfo.offset = oldInfo.offset;
        newInfo.size = oldInfo.size;
        newInfo.presentationTimeUs = oldInfo.presentationTimeUs - this.pauseTime;
    }

    public static interface Listener {
        public void onStatusChange(Status var1);
    }

    public static enum Status {
        STARTED,
        STOPPED,
        RECORDING,
        PAUSED,
        RESUMED;

    }
}

