/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@TargetApi(value=18)
public class Mp4AppendUtil {
    private static final String TAG = "RecordController";
    private ArrayList<String> mVideoList;
    private String mOutFilename;
    private MediaMuxer mMuxer;
    private ByteBuffer mReadBuf;
    private int mOutAudioTrackIndex;
    private int mOutVideoTrackIndex;
    private MediaFormat mAudioFormat;
    private MediaFormat mVideoFormat;
    private ArrayList<String> okVideoList;
    private ArrayList<String> mediaFormatList;
    private int delay_off;

    public Mp4AppendUtil(ArrayList<String> videoList, String outFilename, int delay_off) {
        this.mVideoList = videoList;
        this.mOutFilename = outFilename;
        this.delay_off = delay_off;
        this.mReadBuf = ByteBuffer.allocate(0x100000);
        this.okVideoList = new ArrayList();
        this.mediaFormatList = new ArrayList();
        this.mediaFormatList.addAll(videoList);
    }

    @SuppressLint(value={"WrongConstant"})
    public boolean joinVideo() {
        if (this.mVideoList == null || this.mVideoList.isEmpty()) {
            return false;
        }
        boolean getAudioFormat = false;
        boolean getVideoFormat = false;
        for (String videoPath : this.mediaFormatList) {
            MediaExtractor extractor = new MediaExtractor();
            try {
                extractor.setDataSource(videoPath);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (!getVideoFormat) {
                int trackIndex = Mp4AppendUtil.selectTrack(extractor, "video/");
                if (trackIndex < 0) {
                    Log.e((String)TAG, (String)("No video track found in " + videoPath));
                } else {
                    extractor.selectTrack(trackIndex);
                    this.mVideoFormat = extractor.getTrackFormat(trackIndex);
                    getVideoFormat = true;
                }
            }
            if (!getAudioFormat) {
                int trackIndex = Mp4AppendUtil.selectTrack(extractor, "audio/");
                if (trackIndex < 0) {
                    Log.e((String)TAG, (String)("No audio track found in " + videoPath));
                } else {
                    extractor.selectTrack(trackIndex);
                    this.mAudioFormat = extractor.getTrackFormat(trackIndex);
                    getAudioFormat = true;
                }
            }
            extractor.release();
            if (!getVideoFormat || !getAudioFormat) continue;
            break;
        }
        try {
            this.mMuxer = new MediaMuxer(this.mOutFilename, 0);
            if (getVideoFormat) {
                this.mOutVideoTrackIndex = this.mMuxer.addTrack(this.mVideoFormat);
            }
            if (getAudioFormat) {
                this.mOutAudioTrackIndex = this.mMuxer.addTrack(this.mAudioFormat);
            }
            this.mMuxer.start();
            long ptsOffset = 0L;
            for (String videoPath : this.mVideoList) {
                boolean hasVideo = true;
                boolean hasAudio = true;
                int inVideoTrackIndex = 0;
                int inAudioTrackIndex = 0;
                MediaExtractor videoExtractor = new MediaExtractor();
                MediaExtractor audioExtractor = new MediaExtractor();
                try {
                    videoExtractor.setDataSource(videoPath);
                    inVideoTrackIndex = Mp4AppendUtil.selectTrack(videoExtractor, "video/");
                    if (inVideoTrackIndex < 0) {
                        hasVideo = false;
                    }
                    videoExtractor.selectTrack(inVideoTrackIndex);
                    audioExtractor.setDataSource(videoPath);
                    inAudioTrackIndex = Mp4AppendUtil.selectTrack(audioExtractor, "audio/");
                    if (inAudioTrackIndex < 0) {
                        hasAudio = false;
                    }
                    audioExtractor.selectTrack(inAudioTrackIndex);
                    this.okVideoList.add(videoPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.deleteFile(videoPath);
                    Log.e((String)TAG, (String)("joinVideo  Exception:" + e.getMessage() + " \u79fb\u9664\u5f02\u5e38\u89c6\u9891\u7247\u6bb5\uff1a" + videoPath));
                }
                long presentationTimeUs = 0L;
                long audioPts = 0L;
                long videoPts = 0L;
                while (hasVideo || hasAudio) {
                    MediaExtractor extractor;
                    int outTrackIndex;
                    int currenttrackIndex;
                    if ((!hasVideo || audioPts - videoPts <= 50000L) && hasAudio) {
                        currenttrackIndex = inAudioTrackIndex;
                        outTrackIndex = this.mOutAudioTrackIndex;
                        extractor = audioExtractor;
                    } else {
                        currenttrackIndex = inVideoTrackIndex;
                        outTrackIndex = this.mOutVideoTrackIndex;
                        extractor = videoExtractor;
                    }
                    this.mReadBuf.rewind();
                    int chunkSize = extractor.readSampleData(this.mReadBuf, 0);
                    if (chunkSize < 0) {
                        if (currenttrackIndex == inVideoTrackIndex) {
                            hasVideo = false;
                            continue;
                        }
                        if (currenttrackIndex != inAudioTrackIndex) continue;
                        hasAudio = false;
                        continue;
                    }
                    if (extractor.getSampleTrackIndex() != currenttrackIndex) {
                        Log.e((String)TAG, (String)("WEIRD: got sample from track " + extractor.getSampleTrackIndex() + ", expected " + currenttrackIndex));
                    }
                    presentationTimeUs = extractor.getSampleTime();
                    if (currenttrackIndex == inVideoTrackIndex) {
                        videoPts = presentationTimeUs;
                    } else {
                        audioPts = presentationTimeUs;
                    }
                    MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
                    info.offset = 0;
                    info.size = chunkSize;
                    info.presentationTimeUs = ptsOffset + presentationTimeUs;
                    if ((extractor.getSampleFlags() & 1) != 0) {
                        info.flags = 1;
                    }
                    this.mReadBuf.rewind();
                    this.mMuxer.writeSampleData(outTrackIndex, this.mReadBuf, info);
                    extractor.advance();
                }
                ptsOffset += videoPts > audioPts ? videoPts : audioPts;
                ptsOffset += (long)this.delay_off;
                videoExtractor.release();
                audioExtractor.release();
            }
            if (this.mMuxer != null) {
                try {
                    this.mMuxer.stop();
                    this.mMuxer.release();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Muxer close error. No data was written");
                }
                this.mMuxer = null;
            }
            if (!this.okVideoList.isEmpty()) {
                Log.e((String)TAG, (String)(this.mOutFilename + "    \u5b9e\u9645\u5408\u5e76\u89c6\u9891\u6570: " + this.okVideoList.size()));
                for (String videoPath : this.okVideoList) {
                    this.deleteFile(videoPath);
                }
            } else {
                this.deleteFile(this.mOutFilename);
                return false;
            }
            return true;
        }
        catch (IOException var28) {
            var28.printStackTrace();
            this.deleteFile(this.mOutFilename);
            Log.e((String)TAG, (String)("joinVideo IOException--new MediaMuxer\u5931\u8d25: " + var28.getMessage()));
            return false;
        }
        catch (IllegalStateException var29) {
            var29.printStackTrace();
            this.deleteFile(this.mOutFilename);
            Log.e((String)TAG, (String)("joinVideo IllegalStateException--new MediaMuxer\u5931\u8d25: " + var29.getMessage()));
            return false;
        }
    }

    public static int selectTrack(MediaExtractor extractor, String mimePrefix) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!mime.startsWith(mimePrefix)) continue;
            return i;
        }
        return -1;
    }

    public void deleteFile(String path) {
        File f = new File(path);
        Log.e((String)TAG, (String)("deleteFile \u5408\u5e76\u540e\u5220\u9664\u89c6\u9891: " + path));
        if (f.exists()) {
            f.delete();
        }
    }
}

