/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.icu.text.SimpleDateFormat;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.io.FileWriter;
import java.text.ParseException;
import java.util.Date;

public class LocalLog {
    private static final boolean isLog = true;
    private static final String TAG = LocalLog.class.getSimpleName();
    private static String device_id;
    private static Object obj;
    private static File logFile;
    static File file;

    public static void e(String msg) {
        Log.e((String)TAG, (String)msg);
        if (Build.VERSION.SDK_INT >= 24) {
            LocalLog.writeLogFile(TAG, msg);
        }
    }

    public static void e(String tag, String msg) {
        Log.e((String)tag, (String)msg);
        if (Build.VERSION.SDK_INT >= 24) {
            LocalLog.writeLogFile(tag, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    private static void writeLogFile(String tag, String msg) {
        if (logFile == null) {
            Log.e((String)TAG, (String)"writeLogFile \u65e5\u5fd7\u5de5\u5177\u672a\u521d\u59cb\u5316... ");
            return;
        }
        Object object = obj;
        synchronized (object) {
            try {
                SimpleDateFormat s = new SimpleDateFormat("HH:mm:ss");
                String dateStr = s.format(new Date());
                FileWriter fw = null;
                if (file.exists()) {
                    if (file.length() > 0x100000L) {
                        LocalLog.createLog();
                        fw = new FileWriter(file, false);
                    } else {
                        fw = new FileWriter(file, true);
                    }
                } else {
                    LocalLog.createLog();
                    fw = new FileWriter(file, false);
                }
                fw.write(String.format("[%s] [%s] %s", dateStr, tag, msg));
                fw.write(13);
                fw.write(10);
                fw.flush();
                fw.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void createLog() {
        if (Build.VERSION.SDK_INT >= 24) {
            SimpleDateFormat s2 = new SimpleDateFormat("YYYYMMddHHmmss");
            file = new File(logFile.getAbsolutePath() + "/" + device_id + "-" + s2.format(new Date()) + ".txt");
        }
    }

    public static boolean isCreateLogFile() {
        if (file == null || logFile == null) {
            return false;
        }
        return logFile.exists() && file.exists();
    }

    @SuppressLint(value={"MissingPermission"})
    public static void createFile(Context context) {
        logFile = new File(context.getExternalFilesDir(null).getAbsolutePath() + "/log/");
        if (!logFile.exists()) {
            logFile.mkdir();
            Log.e((String)TAG, (String)("\u672c\u5730\u65e5\u5fd7\u8def\u5f84\uff1a" + logFile.getAbsolutePath()));
        }
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                device_id = tm.getDeviceId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LocalLog.createLog();
        if (Build.VERSION.SDK_INT >= 24) {
            Date d = new Date();
            SimpleDateFormat s = new SimpleDateFormat("YYYYMMddHHmmss");
            String dateStr = s.format(d);
            if (logFile.listFiles() != null && logFile.listFiles().length > 0) {
                for (File f : logFile.listFiles()) {
                    String[] ftime = f.getName().split("[-]");
                    if (ftime.length <= 1 || ftime.length >= 4 || LocalLog.calDateDifferent(dateStr, f.getName().contains("ERROR") ? ftime[2] : ftime[1]) <= 1L) continue;
                    f.delete();
                    LocalLog.writeLogFile(TAG, "\u8be5\u65e5\u5fd7\u5df2\u7ecf\u4fdd\u5b58\u5927\u4e8e\u4e24\u5929\u76f4\u63a5\u5220\u9664: " + f.getName());
                }
            }
        }
    }

    @RequiresApi(api=24)
    private static long calDateDifferent(String date1, String date2) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            Date d1 = df.parse(date1);
            Date d2 = df.parse(date2);
            long diff = d1.getTime() - d2.getTime();
            long days = diff / 86400000L;
            long hours = (diff - days * 86400000L) / 3600000L;
            long minutes = (diff - days * 86400000L - hours * 3600000L) / 60000L;
            return days;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    static {
        obj = new Object();
    }
}

