/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp.init;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.media.AudioManager;
import android.media.CamcorderProfile;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import androidx.annotation.NonNull;
import com.pedro.encoder.input.gl.render.filters.object.GifObjectFilterRender;
import com.pedro.encoder.input.gl.render.filters.object.ImageObjectFilterRender;
import com.pedro.encoder.input.gl.render.filters.object.TextTimeFilterRender;
import com.pedro.encoder.input.video.CameraCallBack;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.utils.SYUtils;
import com.pedro.encoder.utils.gl.TranslateTo;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.rtmp.RtmpCamera1;
import com.pedro.rtplibrary.util.LocalLog;
import com.pedro.rtplibrary.util.RecordController;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class InitRtmpCamera {
    public static volatile InitRtmpCamera mInitRtmpCamera;
    private final String TAG = InitRtmpCamera.class.getSimpleName();
    private Context context;
    private RtmpCamera1 rtmpCamera1;
    private boolean defaultPrepare = false;
    private int width = 1920;
    private int height = 1080;
    private int fps = 5;
    private int bitrate = 1200;
    private int rotation = 0;
    private SurfaceView surfaceView;
    private int audioBitrate = 64;
    private int sampleRate = 32000;
    private boolean isStereo = false;
    private boolean echoCanceler = false;
    private boolean noiseSuppressor = false;
    private int cameraSelect = 1;
    private CameraCallBack callbacks;
    private int f_index = 0;
    private List<byte[]> f_data = new ArrayList<byte[]>();
    private String pushUrl = "rtmp://47.106.114.236:11006/live/livestream";
    private boolean isRelease;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean takePicture = false;
    private int takePictureDelayed = 2000;
    private boolean isTakePictureByUnInit = false;
    SurfaceHolder.Callback surfaceCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(@NonNull SurfaceHolder surfaceHolder) {
            Log.e((String)InitRtmpCamera.this.TAG, (String)"surfaceCreated----------------");
        }

        public void surfaceChanged(@NonNull SurfaceHolder surfaceHolder, int i, int i1, int i2) {
            Log.e((String)InitRtmpCamera.this.TAG, (String)"surfaceChanged----------------");
            InitRtmpCamera.this.rtmpCamera1.startPreview(InitRtmpCamera.this.rtmpCamera1.getCameraFacing(), InitRtmpCamera.this.rotation);
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder surfaceHolder) {
            Log.e((String)InitRtmpCamera.this.TAG, (String)"surfaceDestroyed----------------");
            if (Build.VERSION.SDK_INT >= 18 && InitRtmpCamera.this.isRecord()) {
                InitRtmpCamera.this.rtmpCamera1.stopRecord();
            }
            if (InitRtmpCamera.this.isRtmpStream()) {
                InitRtmpCamera.this.rtmpCamera1.stopStream();
            }
            InitRtmpCamera.this.rtmpCamera1.stopPreview();
            InitRtmpCamera.this.isClearFilters = true;
        }
    };
    View.OnTouchListener touchListener = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (InitRtmpCamera.this.rtmpCamera1 == null) {
                return true;
            }
            int action = motionEvent.getAction();
            if (motionEvent.getPointerCount() > 1) {
                if (action == 2) {
                    InitRtmpCamera.this.rtmpCamera1.setZoom(motionEvent);
                }
            } else if (action == 0) {
                InitRtmpCamera.this.rtmpCamera1.tapToFocus(view, motionEvent);
            }
            return true;
        }
    };
    ConnectCheckerRtmp checkerRtmp = new ConnectCheckerRtmp(){

        @Override
        public void onConnectionStartedRtmp(String rtmpUrl) {
            LocalLog.e(InitRtmpCamera.this.TAG, "onConnectionStartedRtmp \u6b63\u5728\u63a8\u6d41\u7684\u8def\u5f84\uff1a" + rtmpUrl);
        }

        @Override
        public void onConnectionSuccessRtmp() {
            LocalLog.e(InitRtmpCamera.this.TAG, "onConnectionSuccessRtmp \u63a8\u6d41\u6210\u529f");
            if (InitRtmpCamera.this.callbacks != null) {
                InitRtmpCamera.this.callbacks.onPushStatus(true);
            }
        }

        @Override
        public void onConnectionFailedRtmp(String reason) {
            LocalLog.e(InitRtmpCamera.this.TAG, "onConnectionFailedRtmp \u63a8\u6d41\u8fde\u63a5\u9519\u8bef\uff1a" + reason);
            if (InitRtmpCamera.this.callbacks != null) {
                InitRtmpCamera.this.callbacks.onPushStatus(false);
            }
            if (InitRtmpCamera.this.rtmpCamera1 != null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    LocalLog.e(InitRtmpCamera.this.TAG, "onDisconnectRtmp \u5173\u95ed\u63a8\u6d41\u65f6\u5982\u679c\u5728\u5f55\u5236\u4e2d\u5c31\u5173\u95ed\u5f55\u5236\u4e00\u8d77");
                    InitRtmpCamera.this.stopRecord();
                }
                InitRtmpCamera.this.stopPush();
            }
        }

        @Override
        public void onNewBitrateRtmp(long bitrate) {
        }

        @Override
        public void onDisconnectRtmp() {
            LocalLog.e(InitRtmpCamera.this.TAG, "onDisconnectRtmp \u5173\u95ed\u63a8\u6d41");
            if (InitRtmpCamera.this.callbacks != null) {
                InitRtmpCamera.this.callbacks.onPushStatus(false);
            }
            if (InitRtmpCamera.this.rtmpCamera1 != null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    Log.e((String)InitRtmpCamera.this.TAG, (String)"onDisconnectRtmp \u5173\u95ed\u63a8\u6d41\u65f6\u5982\u679c\u5728\u5f55\u5236\u4e2d\u5c31\u5173\u95ed\u5f55\u5236\u4e00\u8d77");
                    InitRtmpCamera.this.stopRecord();
                }
                InitRtmpCamera.this.isClearFilters = true;
            }
        }

        @Override
        public void onAuthErrorRtmp() {
        }

        @Override
        public void onAuthSuccessRtmp() {
        }
    };
    RecordController.Listener recoderListener = new RecordController.Listener(){

        @Override
        public void onStatusChange(RecordController.Status status) {
            if (InitRtmpCamera.this.callbacks != null) {
                if (status == RecordController.Status.RECORDING) {
                    InitRtmpCamera.this.callbacks.onRecordStatus(true);
                } else {
                    InitRtmpCamera.this.callbacks.onRecordStatus(false);
                }
            }
        }
    };
    private TextTimeFilterRender nameFilterRender;
    private TextTimeFilterRender idFilterRender;
    private TextTimeFilterRender textObjectFilterRender;
    private TextTimeFilterRender timeFilterRender;
    private TextTimeFilterRender capLeftFilterRender;
    private TextTimeFilterRender leftFilterRender;
    private TextTimeFilterRender rightFilterRender;
    private TextTimeFilterRender timeFilterRenderGB28181;
    private TextTimeFilterRender locationFilterRenderGB28181;
    private TextTimeFilterRender addressFilterRenderGB28181;
    private TextTimeFilterRender diyFilterRenderGB28181;
    boolean isClearFilters = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InitRtmpCamera getInstance() {
        if (mInitRtmpCamera != null) return mInitRtmpCamera;
        Class<InitRtmpCamera> clazz = InitRtmpCamera.class;
        synchronized (InitRtmpCamera.class) {
            if (mInitRtmpCamera != null) return mInitRtmpCamera;
            mInitRtmpCamera = new InitRtmpCamera();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInitRtmpCamera;
        }
    }

    public void init(Context context, SurfaceView surfaceView, CameraCallBack callbacks, int width, int height, int fps, int bitrate, int rotation) {
        this.context = context;
        this.callbacks = callbacks;
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitrate = bitrate;
        this.rotation = rotation;
        this.surfaceView = surfaceView;
        if (Build.VERSION.SDK_INT >= 24 && !LocalLog.isCreateLogFile()) {
            LocalLog.createFile(context);
        }
        LocalLog.e(this.TAG, "----------------------------init--------------------------------------------------");
        if (!this.isCamera()) {
            if (callbacks != null) {
                callbacks.onCameraError("\u6ca1\u6709\u53ef\u7528\u6444\u50cf\u5934");
            }
            this.release();
            return;
        }
        this.initRtmpCamera1(surfaceView != null);
    }

    private void initRtmpCamera1(boolean isView) {
        if (this.rtmpCamera1 != null) {
            return;
        }
        LocalLog.e(this.TAG, "initRtmpCamera1  \u662f\u5426\u6709\u9884\u89c8\uff1a" + isView);
        if (isView) {
            this.surfaceView.getHolder().addCallback(this.surfaceCallback);
            this.surfaceView.setOnTouchListener(this.touchListener);
            this.rtmpCamera1 = new RtmpCamera1(this.surfaceView, this.checkerRtmp);
        } else {
            this.rtmpCamera1 = new RtmpCamera1(this.context, this.checkerRtmp);
        }
        this.rtmpCamera1.setCameraCallBack(this.callbacks);
        this.isRelease = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCamera() {
        boolean result;
        Camera camera = null;
        try {
            List supportedPreviewSizes;
            camera = Camera.open();
            if (camera == null && Build.VERSION.SDK_INT >= 9) {
                boolean connected = false;
                for (int camIdx = 0; camIdx < Camera.getNumberOfCameras(); ++camIdx) {
                    try {
                        camera = Camera.open((int)camIdx);
                        connected = true;
                    }
                    catch (RuntimeException e) {
                        Log.e((String)this.TAG, (String)("isCamera: " + e));
                    }
                    if (connected) break;
                }
            }
            result = (supportedPreviewSizes = camera.getParameters().getSupportedPreviewSizes()) != null;
            camera.startPreview();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        return result;
    }

    public boolean setLight(boolean isOpen) {
        if (!this.isInitCamera()) {
            return false;
        }
        return this.rtmpCamera1.setLight(isOpen);
    }

    public boolean setNightVision(boolean isOpen) {
        if (!this.isInitCamera()) {
            return false;
        }
        return this.rtmpCamera1.setNightVision(isOpen);
    }

    public void setDefaultPrepare(boolean defaultPrepare) {
        this.defaultPrepare = defaultPrepare;
    }

    public void setAiOutIndex(int aiOutIndex) {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"setAiOutIndex Please initialize first...");
            return;
        }
        this.rtmpCamera1.setAiOutIndex(aiOutIndex);
    }

    public void setAudioPrepare(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        LocalLog.e(this.TAG, "\u66f4\u6539\u97f3\u9891\u914d\u7f6e   bitrate\uff1a" + bitrate + "   sampleRate:" + sampleRate + "   isStereo:" + isStereo + "   echoCanceler:" + echoCanceler);
        this.audioBitrate = bitrate;
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
        this.echoCanceler = echoCanceler;
        this.noiseSuppressor = noiseSuppressor;
    }

    public void setWidthHeight(int width, int height, int fps, int bitrate, int rotation) {
        LocalLog.e(this.TAG, "\u66f4\u6539\u5bbd\u9ad8\u914d\u7f6e   width\uff1a" + width + "   height\uff1a" + height + "   bitrate\uff1a" + bitrate);
        if (this.isTakePictureByUnInit) {
            Log.e((String)this.TAG, (String)"\u5982\u679c\u5728\u672a\u63a8\u6d41\u6216\u5f55\u5236\u65f6\u62cd\u7167\u4e2d\uff0c\u5ef6\u65f6\u4e00\u70b9\u66f4\u6539\u5206\u8fa8\u7387");
            this.isTakePictureByUnInit = false;
            this.handler.postDelayed(() -> this.setWidthHeight(width, height, fps, bitrate, rotation), (long)this.takePictureDelayed);
            return;
        }
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitrate = bitrate;
        this.rotation = rotation;
    }

    public void setIsAppen(boolean isAppen) {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"setIsAppen Please initialize first...");
            return;
        }
        this.rtmpCamera1.setIsAppen(isAppen);
    }

    public void setSplitVideo(Context context, boolean isSplitVideo, int video_length, int delay_off) {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"setSplitVideo Please initialize first...");
            return;
        }
        this.rtmpCamera1.setSplitVideo(context, isSplitVideo, video_length, delay_off, this.callbacks);
    }

    private boolean isInitCamera() {
        if (this.rtmpCamera1 == null || this.context == null) {
            LocalLog.e(this.TAG, "\u63a8\u6d41\u5e93\u672a\u521d\u59cb\u5316");
            if (this.callbacks != null) {
                this.callbacks.onCameraError("Please initialize first...");
            }
            return false;
        }
        return true;
    }

    public void release() {
        try {
            if (this.isRelease) {
                Log.e((String)this.TAG, (String)"release:\u5df2\u9500\u6bc1\u4e0d\u7528\u7ee7\u7eed");
                return;
            }
            LocalLog.e(this.TAG, "----------------------------release--------------------------------------------------");
            this.stopRecord();
            this.stopPush();
            if (this.isOnPreview()) {
                this.rtmpCamera1.stopPreview();
            }
            this.isClearFilters = true;
            this.clearFilters();
            if (this.surfaceView != null) {
                if (this.surfaceView.getHolder() != null) {
                    this.surfaceView.getHolder().addCallback(null);
                    this.surfaceView.getHolder().removeCallback(this.surfaceCallback);
                    this.surfaceCallback = null;
                }
                this.surfaceView.setOnTouchListener(null);
                this.touchListener = null;
                this.surfaceView = null;
            }
            this.rtmpCamera1.setCameraCallBack(null);
            if (this.callbacks != null) {
                this.callbacks = null;
            }
            this.rtmpCamera1 = null;
            this.context = null;
            this.isRelease = true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("release \u5f02\u5e38: " + e));
        }
    }

    public boolean rtmpCameraState() {
        return this.isInitCamera();
    }

    public boolean isOnPreview() {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"isOnPreview Please initialize first...");
            return false;
        }
        return this.rtmpCamera1.isOnPreview();
    }

    public void startPush(String url) {
        try {
            if (!this.isInitCamera()) {
                LocalLog.e(this.TAG, "startPush \u63a8\u6d41\u5e93\u672a\u521d\u59cb\u5316\uff1a" + url);
                return;
            }
            if (this.isTakePictureByUnInit) {
                LocalLog.e(this.TAG, "\u5982\u679c\u5728\u672a\u63a8\u6d41\u6216\u5f55\u5236\u65f6\u62cd\u7167\u4e2d\uff0c\u5ef6\u65f6\u4e00\u70b9\u6253\u5f00\u63a8\u6d41");
                this.isTakePictureByUnInit = false;
                this.handler.postDelayed(() -> this.startPush(url), (long)this.takePictureDelayed);
                return;
            }
            this.stopRecord();
            this.handler.postDelayed(() -> {
                if (!this.pushUrl.equals(url)) {
                    LocalLog.e(this.TAG, "\u63a8\u6d41\u8def\u5f84\u53d1\u751f\u6539\u53d8\uff0c\u5148\u5173\u95ed\u63a8\u6d41\uff0c\u518d\u91cd\u65b0\u63a8\u6d41\uff1a" + url);
                    this.stopPush();
                    this.pushUrl = url;
                    if (this.prepareEncoders()) {
                        this.rtmpCamera1.startStream(this.pushUrl);
                    }
                    return;
                }
                if (this.isRtmpStream()) {
                    LocalLog.e(this.TAG, "\u6b63\u5728\u63a8\u6d41\u4e2d\uff1a" + this.pushUrl);
                    if (this.callbacks != null) {
                        this.callbacks.onPushStatus(true);
                    }
                } else {
                    LocalLog.e(this.TAG, "\u6ca1\u6709\u63a8\u6d41\uff0c\u5c31\u7ee7\u7eed\u63a8\u6d41\uff1a" + this.pushUrl);
                    if (this.prepareEncoders()) {
                        this.rtmpCamera1.startStream(this.pushUrl);
                    } else if (this.callbacks != null) {
                        this.callbacks.onPushStatus(false);
                    }
                }
            }, 1000L);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("startPush \u5f02\u5e38: " + e));
        }
    }

    public void stopPush() {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"stopPush Please initialize first...");
                return;
            }
            LocalLog.e(this.TAG, "\u5173\u95ed\u63a8\u6d41\uff1a" + this.pushUrl);
            if (this.isRtmpStream()) {
                this.rtmpCamera1.stopStream();
            }
            this.isClearFilters = true;
        }
        catch (RuntimeException e) {
            Log.e((String)this.TAG, (String)("\u5173\u95ed\u63a8\u6d41\u5f02\u5e38\uff1a" + e));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("startPush \u5f02\u5e38: " + e));
        }
    }

    public boolean isRtmpStream() {
        try {
            if (!this.isInitCamera()) {
                return false;
            }
            return this.rtmpCamera1.isStreaming();
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("isRtmpStream NullPointerException:" + e));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("isRtmpStream Exception:" + e));
        }
        return false;
    }

    public void startRecord(String path) {
        try {
            if (!this.isInitCamera()) {
                LocalLog.e(this.TAG, "startRecord \u672a\u521d\u59cb\u5316\u63a8\u6d41\u5e93\uff1a" + path);
                return;
            }
            if (Build.VERSION.SDK_INT < 18) {
                LocalLog.e(this.TAG, "You need min JELLY_BEAN_MR2(API 18) for do it...");
                return;
            }
            if (this.isTakePictureByUnInit) {
                LocalLog.e(this.TAG, "\u5982\u679c\u5728\u672a\u63a8\u6d41\u6216\u5f55\u5236\u65f6\u62cd\u7167\u4e2d\uff0c\u5ef6\u65f6\u4e00\u70b9\u6253\u5f00\u5f55\u5236");
                this.isTakePictureByUnInit = false;
                this.handler.postDelayed(() -> this.startRecord(path), (long)this.takePictureDelayed);
                return;
            }
            this.stopPush();
            if (!this.isRecord()) {
                if (!this.isRtmpStream()) {
                    LocalLog.e(this.TAG, "\u6ca1\u6709\u5f55\u5236\u4e5f\u6ca1\u6709\u63a8\u6d41\uff0c\u5f00\u59cb\u5f55\u5236\uff1a" + path);
                    if (this.prepareEncoders()) {
                        this.rtmpCamera1.startRecord(path, this.recoderListener);
                    } else if (this.callbacks != null) {
                        this.callbacks.onRecordStatus(false);
                    }
                } else {
                    LocalLog.e(this.TAG, "\u63a8\u6d41\u4e2d\uff0c\u76f4\u63a5\u5f55\u5236\uff1a" + path);
                    this.rtmpCamera1.startRecord(path, this.recoderListener);
                }
            } else {
                LocalLog.e(this.TAG, "\u5f55\u5236\u4e2d\uff0c\u76f4\u63a5\u5c06\u8def\u5f84\u4f20\u65b0\u8def\u5f84\u8fdb\u53bb\uff1a" + path);
                this.rtmpCamera1.setNewPath(path);
            }
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("startRecord \u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("startRecord \u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    public void stopRecord() {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"stopRecord Please initialize first...");
                return;
            }
            LocalLog.e(this.TAG, "\u505c\u6b62\u5f55\u5236");
            if (Build.VERSION.SDK_INT >= 18 && this.isRecord()) {
                this.rtmpCamera1.stopRecord();
            }
            this.isClearFilters = true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("startRecord \u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    public boolean isRecord() {
        try {
            if (!this.isInitCamera()) {
                return false;
            }
            return this.rtmpCamera1.isRecording();
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("isRecord NullPointerException:" + e));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("isRecord Exception:" + e));
        }
        return false;
    }

    public void takePicture(PictureBack pictureBack) {
        try {
            LocalLog.e(this.TAG, "takePicture \u65e0\u56de\u8c03\uff0c\u65e0\u6c34\u5370\u62cd\u7167");
            if (!this.isInitCamera()) {
                this.takePictureByUnInit(pictureBack, null, null, null, null, null);
            } else if (this.isRtmpStream() || this.isRecord()) {
                this.handler.postDelayed(() -> {
                    if (this.isInitCamera()) {
                        this.rtmpCamera1.setPictureBack(pictureBack);
                    } else {
                        this.takePictureByUnInit(pictureBack, null, null, null, null, null);
                    }
                }, (long)this.takePictureDelayed);
            } else if (this.surfaceView != null) {
                this.handler.postDelayed(() -> {
                    if (this.isInitCamera()) {
                        this.rtmpCamera1.setPictureBack(pictureBack);
                    } else {
                        this.takePictureByUnInit(pictureBack, null, null, null, null, null);
                    }
                }, (long)this.takePictureDelayed);
            } else {
                this.takePictureByUnInit(pictureBack, null, null, null, null, null);
            }
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("takePicture3 Exception:" + e));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("takePicture Exception:" + e));
        }
    }

    public void takePicture(Context context, int rotation, PictureBack pictureBack) {
        try {
            LocalLog.e(this.TAG, "takePicture \u6709\u56de\u8c03\uff0c\u65e0\u6c34\u5370\u62cd\u7167");
            this.context = context;
            this.rotation = rotation;
            if (!this.isInitCamera()) {
                this.takePictureByUnInit(pictureBack, null, null, null, null, null);
            } else if (this.isRtmpStream() || this.isRecord()) {
                this.handler.postDelayed(() -> {
                    if (this.isInitCamera()) {
                        this.rtmpCamera1.setPictureBack(pictureBack);
                    } else {
                        this.takePictureByUnInit(pictureBack, null, null, null, null, null);
                    }
                }, (long)this.takePictureDelayed);
            } else if (this.surfaceView != null) {
                this.handler.postDelayed(() -> {
                    if (this.isInitCamera()) {
                        this.rtmpCamera1.setPictureBack(pictureBack);
                    } else {
                        this.takePictureByUnInit(pictureBack, null, null, null, null, null);
                    }
                }, (long)this.takePictureDelayed);
            } else {
                this.takePictureByUnInit(pictureBack, null, null, null, null, null);
            }
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("takePicture3 Exception:" + e));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("takePicture2 Exception:" + e));
        }
    }

    public void takePicture(Context context, int rotation, String id, String info, String addr, String longLat, String textColor, PictureBack pictureBack) {
        try {
            LocalLog.e(this.TAG, "takePicture \u6709\u56de\u8c03\uff0c\u6709\u6c34\u5370\u62cd\u7167");
            this.context = context;
            this.rotation = rotation;
            if (!this.isInitCamera()) {
                this.takePictureByUnInit(pictureBack, id, info, addr, longLat, textColor);
            } else if (this.isRtmpStream() || this.isRecord()) {
                this.handler.postDelayed(() -> {
                    if (this.isInitCamera()) {
                        this.rtmpCamera1.setPictureBack(pictureBack, id, info, addr, longLat, textColor);
                    } else {
                        this.takePictureByUnInit(pictureBack, id, info, addr, longLat, textColor);
                    }
                }, (long)this.takePictureDelayed);
            } else if (this.surfaceView != null) {
                this.handler.postDelayed(() -> {
                    if (this.isInitCamera()) {
                        this.rtmpCamera1.setPictureBack(pictureBack, id, info, addr, longLat, textColor);
                    } else {
                        this.takePictureByUnInit(pictureBack, id, info, addr, longLat, textColor);
                    }
                }, (long)this.takePictureDelayed);
            } else {
                this.takePictureByUnInit(pictureBack, id, info, addr, longLat, textColor);
            }
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("takePicture3 Exception:" + e));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("takePicture3 Exception:" + e));
        }
    }

    public void takePictureByUnInit(PictureBack pictureBack, String id, String info, String addr, String longLat, String textColor) {
        Camera mCamera;
        LocalLog.e(this.TAG, "takePictureByUnInit \u672ainit\u62cd\u7167...");
        try {
            mCamera = Camera.open((int)this.selectCamera(this.cameraSelect));
        }
        catch (RuntimeException e) {
            LocalLog.e(this.TAG, "takePictureByUnInit \u6444\u50cf\u5934\u5f02\u5e38\uff1a" + e);
            if (this.callbacks != null) {
                this.callbacks.onCameraError(e.getMessage());
            }
            return;
        }
        if (!this.isOkWith(mCamera)) {
            return;
        }
        try {
            List supportedFocusModes;
            this.isTakePictureByUnInit = true;
            Camera.Parameters params = mCamera.getParameters();
            params.setZoom(0);
            params.setPreviewFormat(17);
            params.setPreviewSize(this.width, this.height);
            if (this.takePicture) {
                params.setPictureSize(this.width, this.height);
            }
            if ((supportedFocusModes = params.getSupportedFocusModes()) != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("continuous-picture")) {
                    params.setFocusMode("continuous-picture");
                } else if (supportedFocusModes.contains("auto")) {
                    params.setFocusMode("auto");
                } else {
                    params.setFocusMode((String)supportedFocusModes.get(0));
                }
            }
            mCamera.setParameters(params);
            InitRtmpCamera.setCameraDisplayOrientation((Activity)this.context, this.selectCamera(this.cameraSelect), mCamera);
            if (!this.takePicture) {
                this.f_data.clear();
                this.f_index = 0;
                mCamera.setPreviewCallback((bytes, camera) -> {
                    if (bytes == null) {
                        return;
                    }
                    if (bytes.length != this.width * this.height * 3 / 2) {
                        return;
                    }
                    ++this.f_index;
                    this.f_data.add(bytes);
                });
            }
            SurfaceTexture surfaceTexture = new SurfaceTexture(0);
            mCamera.setPreviewTexture(surfaceTexture);
            mCamera.startPreview();
            if (!this.takePicture) {
                this.handler.postDelayed(() -> {
                    if (this.f_data == null || this.f_data.isEmpty()) {
                        return;
                    }
                    byte[] bytes = this.f_data.get(this.f_data.size() - 1);
                    YuvImage image = new YuvImage(bytes, 17, this.width, this.height, null);
                    if (image != null) {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        image.compressToJpeg(new Rect(0, 0, this.width, this.height), 80, (OutputStream)stream);
                        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                        Matrix matrix = new Matrix();
                        matrix.postRotate((float)this.rotation);
                        Bitmap nbmp2 = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)matrix, (boolean)true);
                        if (!TextUtils.isEmpty((CharSequence)id) && !TextUtils.isEmpty((CharSequence)info)) {
                            Bitmap nbmp3 = SYUtils.dealBitmap(nbmp2, id, info, addr, longLat, textColor);
                            if (pictureBack != null) {
                                pictureBack.onPictureBitMap(nbmp3);
                            }
                        } else if (pictureBack != null) {
                            pictureBack.onPictureBitMap(nbmp2);
                        }
                        if (mCamera != null) {
                            mCamera.stopPreview();
                            mCamera.setPreviewCallback(null);
                            mCamera.release();
                            this.isTakePictureByUnInit = false;
                        }
                    }
                }, 1000L);
            } else {
                AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
                audioManager.setStreamMute(1, true);
                mCamera.takePicture(null, null, (bytes, camera) -> {
                    try {
                        File pictureFile = new File(this.context.getExternalFilesDir(null).getAbsolutePath());
                        String path = pictureFile.getAbsolutePath() + File.separator + System.currentTimeMillis() + ".jpg";
                        FileOutputStream fos = new FileOutputStream(path);
                        fos.write(bytes);
                        fos.close();
                        Bitmap bmp = BitmapFactory.decodeFile((String)path);
                        Matrix matrix = new Matrix();
                        matrix.postRotate((float)this.rotation);
                        Bitmap nbmp2 = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)matrix, (boolean)true);
                        if (!TextUtils.isEmpty((CharSequence)id) && !TextUtils.isEmpty((CharSequence)info)) {
                            Bitmap nbmp3 = SYUtils.dealBitmap(nbmp2, id, info, addr, longLat, textColor);
                            if (pictureBack != null) {
                                pictureBack.onPictureBitMap(nbmp3);
                            }
                        } else if (pictureBack != null) {
                            pictureBack.onPictureBitMap(nbmp2);
                        }
                        Log.e((String)this.TAG, (String)("onPictureTaken       \u62cd\u7167\u8def\u5f84" + path));
                        new File(path).delete();
                        if (mCamera != null) {
                            mCamera.stopPreview();
                            mCamera.setPreviewCallback(null);
                            mCamera.release();
                            this.isTakePictureByUnInit = false;
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException ioe) {
            this.isTakePictureByUnInit = false;
            Log.e((String)this.TAG, (String)("\u672a\u521d\u59cb\u5316\u62cd\u7167\u5f02\u5e38 IOException:" + ioe));
        }
        catch (RuntimeException e) {
            this.isTakePictureByUnInit = false;
            Log.e((String)this.TAG, (String)("\u672a\u521d\u59cb\u5316\u62cd\u7167\u5f02\u5e38 RuntimeException:" + e));
        }
        catch (Exception e) {
            this.isTakePictureByUnInit = false;
            Log.e((String)this.TAG, (String)("\u672a\u521d\u59cb\u5316\u62cd\u7167\u5f02\u5e38 \u5f02\u5e38\uff1a" + e));
        }
    }

    public void setTakePictureWay(boolean takePicture) {
        this.takePicture = takePicture;
    }

    private boolean isOkWith(Camera camera) {
        List<Camera.Size> cameras = this.getPreviewSize(camera);
        if (cameras == null || cameras.isEmpty()) {
            return false;
        }
        for (Camera.Size s : cameras) {
            if (this.width > s.width) continue;
            break;
        }
        this.width = cameras.get((int)0).width;
        this.height = cameras.get((int)0).height;
        Log.e((String)this.TAG, (String)("isOkWith \u9ed8\u8ba41920\u5206\u8fa8\u7387\u4e0d\u652f\u6301\u5df2\u81ea\u52a8\u5207\u6362\u5230\uff1a" + this.width + "*" + this.height));
        return true;
    }

    public List<Camera.Size> getPreviewSize(Camera camera) {
        List previewSizes = camera.getParameters().getSupportedPreviewSizes();
        Camera.Size maxSize = this.getMaxEncoderSizeSupported(camera);
        Iterator iterator = previewSizes.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            if (size.width <= maxSize.width && size.height <= maxSize.height) continue;
            iterator.remove();
        }
        Collections.sort(previewSizes, (o1, o2) -> {
            int i = o2.width - o1.width;
            if (i == 0) {
                return o2.height - o1.height;
            }
            return i;
        });
        return previewSizes;
    }

    private Camera.Size getMaxEncoderSizeSupported(Camera camera) {
        if (CamcorderProfile.hasProfile((int)10)) {
            Camera camera2 = camera;
            Objects.requireNonNull(camera2);
            return new Camera.Size(camera2, 4096, 2160);
        }
        if (CamcorderProfile.hasProfile((int)8)) {
            Camera camera3 = camera;
            Objects.requireNonNull(camera3);
            return new Camera.Size(camera3, 3840, 2160);
        }
        if (CamcorderProfile.hasProfile((int)11)) {
            Camera camera4 = camera;
            Objects.requireNonNull(camera4);
            return new Camera.Size(camera4, 2560, 1440);
        }
        if (CamcorderProfile.hasProfile((int)6)) {
            Camera camera5 = camera;
            Objects.requireNonNull(camera5);
            return new Camera.Size(camera5, 1920, 1080);
        }
        if (CamcorderProfile.hasProfile((int)5)) {
            Camera camera6 = camera;
            Objects.requireNonNull(camera6);
            return new Camera.Size(camera6, 1280, 720);
        }
        Camera camera7 = camera;
        Objects.requireNonNull(camera7);
        return new Camera.Size(camera7, 640, 480);
    }

    public static void setCameraDisplayOrientation(Activity activity, int cameraId, Camera camera) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
    }

    public void switchCamera() {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"switchCamera Please initialize first...");
            return;
        }
        try {
            this.rtmpCamera1.switchCamera();
        }
        catch (CameraOpenException e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
    }

    private boolean prepareEncoders() {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"switchCamera Please initialize first...");
            return false;
        }
        if (this.defaultPrepare) {
            return this.rtmpCamera1.prepareAudio() && this.rtmpCamera1.prepareVideo();
        }
        return this.rtmpCamera1.prepareAudio(this.audioBitrate * 1024, this.sampleRate, this.isStereo, this.echoCanceler, this.noiseSuppressor) && this.rtmpCamera1.prepareVideo(this.width, this.height, this.fps, this.bitrate * 1024, this.rotation);
    }

    private int selectCamera(int facing) {
        int number = Camera.getNumberOfCameras();
        for (int i = 0; i < number; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing != facing) continue;
            return i;
        }
        return 0;
    }

    public void setNameToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setNameToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.nameFilterRender != null) {
                this.nameFilterRender.setText(text, textSize, textColor, bgColor, padding, false);
                this.nameFilterRender.setDefaultScale(this.width, this.height);
                this.nameFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setNameToStream: \u6dfb\u52a0\u6587\u5b57\u6c34\u5370");
            this.nameFilterRender = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.nameFilterRender);
            this.nameFilterRender.setText(text, textSize, textColor, bgColor, padding, false);
            this.nameFilterRender.setDefaultScale(this.width, this.height);
            this.nameFilterRender.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setNameToStream: \u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setIdToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setIdToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.idFilterRender != null) {
                this.idFilterRender.setText(text, textSize, textColor, bgColor, padding, false);
                this.idFilterRender.setDefaultScale(this.width, this.height);
                this.idFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setTextToStream: \u6dfb\u52a0\u6587\u5b57\u6c34\u5370");
            this.idFilterRender = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.idFilterRender);
            this.idFilterRender.setText(text, textSize, textColor, bgColor, padding, false);
            this.idFilterRender.setDefaultScale(this.width, this.height);
            this.idFilterRender.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setTextToStream: \u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setUpdateTextToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setUpdateTextToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.textObjectFilterRender != null) {
                this.textObjectFilterRender.setText(text, textSize, textColor, bgColor, padding, false);
                this.textObjectFilterRender.setDefaultScale(this.width, this.height);
                this.textObjectFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setUpdateTextToStream: \u6dfb\u52a0\u52a8\u6001\u6587\u5b57\u6c34\u5370");
            if (this.textObjectFilterRender == null) {
                this.textObjectFilterRender = new TextTimeFilterRender();
                this.rtmpCamera1.getGlInterface().addFilter(this.textObjectFilterRender);
                this.textObjectFilterRender.setText(text, textSize, textColor, bgColor, padding, false);
                this.textObjectFilterRender.setDefaultScale(this.width, this.height);
                this.textObjectFilterRender.setPosition(x, y);
            }
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setUpdateTextToStream: \u6dfb\u52a0\u52a8\u6001\u6587\u5b57\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setTimeTextToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setTimeTextToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.timeFilterRender != null) {
                this.timeFilterRender.setText(text, textSize, textColor, bgColor, padding, true);
                this.timeFilterRender.setDefaultScale(this.width, this.height);
                this.timeFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setTimeTextToStream: \u6dfb\u52a0\u65f6\u95f4\u6c34\u5370");
            this.timeFilterRender = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.timeFilterRender);
            this.timeFilterRender.setText(text, textSize, textColor, bgColor, padding, true);
            this.timeFilterRender.setDefaultScale(this.width, this.height);
            this.timeFilterRender.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setTimeTextToStream: \u6dfb\u52a0\u65f6\u95f4\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setImageToStream(Bitmap bitmap, TranslateTo positionTo) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setImageToStream Please initialize first...");
                return;
            }
            Log.e((String)this.TAG, (String)"setImageToStream: \u6dfb\u52a0\u56fe\u7247\u6c34\u5370");
            ImageObjectFilterRender imageObjectFilterRender = new ImageObjectFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(imageObjectFilterRender);
            imageObjectFilterRender.setImage(bitmap);
            imageObjectFilterRender.setDefaultScale(this.width, this.height);
            imageObjectFilterRender.setPosition(positionTo);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setImageToStream: \u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setGifToStream(InputStream inputStream, TranslateTo positionTo) {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"setGifToStream Please initialize first...");
            return;
        }
        Log.e((String)this.TAG, (String)"setGifToStream: \u6dfb\u52a0gif\u56fe\u7247\u6c34\u5370");
        try {
            GifObjectFilterRender gifObjectFilterRender = new GifObjectFilterRender();
            gifObjectFilterRender.setGif(inputStream);
            this.rtmpCamera1.getGlInterface().addFilter(gifObjectFilterRender);
            gifObjectFilterRender.setDefaultScale(this.width, this.height);
            gifObjectFilterRender.setPosition(positionTo);
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("setGifToStream IOException:" + e.getMessage()));
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setGifToStream: \u6dfb\u52a0gif\u56fe\u7247\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setCapLeftTxtToStream(String info, String id, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setLeftTxtToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.capLeftFilterRender != null) {
                this.capLeftFilterRender.setCapLeftText(info, id, textSize, textColor, bgColor, padding);
                this.capLeftFilterRender.setDefaultScale(this.width, this.height);
                this.capLeftFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setCapLeftTxtToStream: \u8fd9\u662f\u5de6\u4e0b\u89d2\u6c34\u5370\u7ec4\u5408");
            this.capLeftFilterRender = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.capLeftFilterRender);
            this.capLeftFilterRender.setCapLeftText(info, id, textSize, textColor, bgColor, padding);
            this.capLeftFilterRender.setDefaultScale(this.width, this.height);
            this.capLeftFilterRender.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setCapLeftTxtToStream: \u8fd9\u662f\u5de6\u4e0b\u89d2\u6c34\u5370\u7ec4\u5408\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setLeftTxtToStream(String name, String register, String id, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera() || !this.isRtmpStream() && !this.isRecord()) {
                Log.e((String)this.TAG, (String)"setLeftTxtToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.leftFilterRender != null) {
                this.leftFilterRender.setLeftText(name, register, id, textSize, textColor, bgColor, padding);
                this.leftFilterRender.setDefaultScale(this.width, this.height);
                this.leftFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setLeftTxtToStream: \u8fd9\u662f\u5de6\u4e0b\u89d2\u6c34\u5370\u7ec4\u5408");
            this.leftFilterRender = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.leftFilterRender);
            this.leftFilterRender.setLeftText(name, register, id, textSize, textColor, bgColor, padding);
            this.leftFilterRender.setDefaultScale(this.width, this.height);
            this.leftFilterRender.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setLeftTxtToStream: \u8fd9\u662f\u5de6\u4e0b\u89d2\u6c34\u5370\u7ec4\u5408\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setRightTxtToStream(TextTimeFilterRender.RightBean rightBean, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera() || !this.isRtmpStream() && !this.isRecord()) {
                Log.e((String)this.TAG, (String)"setRightTxtToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.rightFilterRender != null) {
                this.rightFilterRender.setRightBean(rightBean, textSize, textColor, bgColor, padding);
                this.rightFilterRender.setDefaultScale(this.width, this.height);
                this.rightFilterRender.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setRightTxtToStream: \u8fd9\u662f\u53f3\u4e0b\u89d2\u6c34\u5370\u7ec4\u5408");
            this.rightFilterRender = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.rightFilterRender);
            this.rightFilterRender.setRightBean(rightBean, textSize, textColor, bgColor, padding);
            this.rightFilterRender.setDefaultScale(this.width, this.height);
            this.rightFilterRender.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setRightTxtToStream: \u8fd9\u662f\u53f3\u4e0b\u89d2\u6c34\u5370\u7ec4\u5408\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setGB28181TimeTextToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y, boolean isAutoUpdate) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setGB28181TimeTextToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.timeFilterRenderGB28181 != null) {
                this.timeFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, isAutoUpdate);
                this.timeFilterRenderGB28181.setDefaultScale(this.width, this.height);
                this.timeFilterRenderGB28181.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setTimeTextToStream: \u6dfb\u52a0\u65f6\u95f4\u6c34\u5370");
            this.timeFilterRenderGB28181 = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.timeFilterRenderGB28181);
            this.timeFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, isAutoUpdate);
            this.timeFilterRenderGB28181.setDefaultScale(this.width, this.height);
            this.timeFilterRenderGB28181.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setTimeTextToStream: \u6dfb\u52a0\u65f6\u95f4\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setGB28181LocationToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setGB28181LocationToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.locationFilterRenderGB28181 != null) {
                this.locationFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, false);
                this.locationFilterRenderGB28181.setDefaultScale(this.width, this.height);
                this.locationFilterRenderGB28181.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setGB28181LocationToStream: \u6dfb\u52a0\u7ecf\u7eac\u5ea6\u6c34\u5370");
            this.locationFilterRenderGB28181 = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.locationFilterRenderGB28181);
            this.locationFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, false);
            this.locationFilterRenderGB28181.setDefaultScale(this.width, this.height);
            this.locationFilterRenderGB28181.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setGB28181LocationToStream: \u6dfb\u52a0\u7ecf\u7eac\u5ea6\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setGB28181AddressToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setGB28181AddressToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.addressFilterRenderGB28181 != null) {
                this.addressFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, false);
                this.addressFilterRenderGB28181.setDefaultScale(this.width, this.height);
                this.addressFilterRenderGB28181.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setGB28181AddressToStream: \u6dfb\u52a0\u5730\u5740\u6c34\u5370");
            this.addressFilterRenderGB28181 = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.addressFilterRenderGB28181);
            this.addressFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, false);
            this.addressFilterRenderGB28181.setDefaultScale(this.width, this.height);
            this.addressFilterRenderGB28181.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setGB28181AddressToStream: \u6dfb\u52a0\u5730\u5740\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void setGB28181DiyToStream(String text, int textSize, String textColor, String bgColor, int padding, float x, float y) {
        try {
            if (!this.isInitCamera()) {
                Log.e((String)this.TAG, (String)"setGB28181DiyToStream Please initialize first...");
                return;
            }
            this.clearFilters();
            if (this.diyFilterRenderGB28181 != null) {
                this.diyFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, false);
                this.diyFilterRenderGB28181.setDefaultScale(this.width, this.height);
                this.diyFilterRenderGB28181.setPosition(x, y);
                return;
            }
            Log.e((String)this.TAG, (String)"setGB28181DiyToStream: \u6dfb\u52a0\u81ea\u5b9a\u4e49\u6c34\u5370");
            this.diyFilterRenderGB28181 = new TextTimeFilterRender();
            this.rtmpCamera1.getGlInterface().addFilter(this.diyFilterRenderGB28181);
            this.diyFilterRenderGB28181.setText(text, textSize, textColor, bgColor, padding, false);
            this.diyFilterRenderGB28181.setDefaultScale(this.width, this.height);
            this.diyFilterRenderGB28181.setPosition(x, y);
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)("setGB28181DiyToStream: \u6dfb\u52a0\u81ea\u5b9a\u4e49\u6c34\u5370\u5f02\u5e38\uff1a" + e));
        }
    }

    public void clearFilters() {
        if (!this.isInitCamera()) {
            Log.e((String)this.TAG, (String)"clearFilters Please initialize first...");
            return;
        }
        if (!this.isClearFilters) {
            return;
        }
        Log.e((String)this.TAG, (String)"clearFilters \u6e05\u9664\u6c34\u5370...");
        if (this.rightFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.rightFilterRender);
            this.rightFilterRender = null;
        }
        if (this.leftFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.leftFilterRender);
            this.leftFilterRender = null;
        }
        if (this.timeFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.timeFilterRender);
            this.timeFilterRender = null;
        }
        if (this.textObjectFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.textObjectFilterRender);
            this.textObjectFilterRender = null;
        }
        if (this.idFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.idFilterRender);
            this.idFilterRender = null;
        }
        if (this.nameFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.nameFilterRender);
            this.nameFilterRender = null;
        }
        if (this.capLeftFilterRender != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.capLeftFilterRender);
            this.capLeftFilterRender = null;
        }
        if (this.timeFilterRenderGB28181 != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.timeFilterRenderGB28181);
            this.timeFilterRenderGB28181 = null;
        }
        if (this.locationFilterRenderGB28181 != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.locationFilterRenderGB28181);
            this.locationFilterRenderGB28181 = null;
        }
        if (this.addressFilterRenderGB28181 != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.addressFilterRenderGB28181);
            this.addressFilterRenderGB28181 = null;
        }
        if (this.diyFilterRenderGB28181 != null) {
            this.rtmpCamera1.getGlInterface().removeFilter(this.diyFilterRenderGB28181);
            this.diyFilterRenderGB28181 = null;
        }
        this.isClearFilters = false;
    }

    public static interface PictureBack {
        public void onPictureBitMap(Bitmap var1);
    }
}

