/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.media.MediaCodec;
import android.text.TextUtils;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.video.CameraCallBack;
import com.pedro.encoder.utils.SYUtils;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.base.Camera1Base;
import com.pedro.rtplibrary.rtmp.init.InitRtmpCamera;
import com.pedro.rtplibrary.util.LocalLog;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class RtmpCamera1
extends Camera1Base {
    private final RtmpClient rtmpClient;
    private InitRtmpCamera.PictureBack pictureBack;
    private boolean isTake = false;
    private String id;
    private String info;
    private String addr;
    private String longLat;
    private String textColor;
    private CameraCallBack callbacks;
    private int aiOutIndex = 0;
    private long startTime = 0L;

    public RtmpCamera1(SurfaceView surfaceView, ConnectCheckerRtmp connectChecker) {
        super(surfaceView);
        this.rtmpClient = new RtmpClient(connectChecker);
    }

    public RtmpCamera1(TextureView textureView, ConnectCheckerRtmp connectChecker) {
        super(textureView);
        this.rtmpClient = new RtmpClient(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(OpenGlView openGlView, ConnectCheckerRtmp connectChecker) {
        super(openGlView);
        this.rtmpClient = new RtmpClient(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(LightOpenGlView lightOpenGlView, ConnectCheckerRtmp connectChecker) {
        super(lightOpenGlView);
        this.rtmpClient = new RtmpClient(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(Context context, ConnectCheckerRtmp connectChecker) {
        super(context);
        this.rtmpClient = new RtmpClient(connectChecker);
    }

    public void setCameraCallBack(CameraCallBack callbacks) {
        this.callbacks = callbacks;
        this.setCameraCallBacks(callbacks);
    }

    public void setPictureBack(InitRtmpCamera.PictureBack pictureBack) {
        this.pictureBack = pictureBack;
        this.isTake = true;
    }

    public void setPictureBack(InitRtmpCamera.PictureBack pictureBack, String id, String info, String addr, String longLat, String textColor) {
        this.pictureBack = pictureBack;
        this.id = id;
        this.info = info;
        this.addr = addr;
        this.longLat = longLat;
        this.textColor = textColor;
        this.isTake = true;
    }

    public void setAiOutIndex(int aiOutIndex) {
        this.aiOutIndex = aiOutIndex;
    }

    public void setIsAppen(boolean isAppen) {
        this.recordController.setIsAppen(isAppen);
    }

    public void setSplitVideo(Context context, boolean isSplitVideo, int video_length, int delay_off, CameraCallBack callbacks) {
        if (this.recordController == null) {
            return;
        }
        this.recordController.setSplitVideo(context, isSplitVideo, video_length, delay_off, callbacks);
    }

    public void setNewPath(String new_path) {
        this.recordController.setNewPath(new_path);
    }

    @Override
    public void inputYUVData(Frame frame) {
        super.inputYUVData(frame);
        try {
            long start;
            if (frame == null || frame.getCamera() == null || frame.getBuffer() == null) {
                LocalLog.e("inputYUVData  frame\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u76f8\u5e94\u5904\u7406");
                return;
            }
            if (this.callbacks != null && this.aiOutIndex != 0 && (start = System.currentTimeMillis()) - this.startTime > (long)(1000 * this.aiOutIndex)) {
                this.callbacks.onCameraFrame(frame);
                Camera.Size size = frame.getCamera().getParameters().getPreviewSize();
                if (frame.getBuffer().length != size.width * size.height * 3 / 2) {
                    return;
                }
                YuvImage image = new YuvImage(frame.getBuffer(), 17, size.width, size.height, null);
                if (image != null) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    image.compressToJpeg(new Rect(0, 0, size.width, size.height), 80, (OutputStream)stream);
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                    int bytes = bitmap.getByteCount();
                    ByteBuffer buffer = ByteBuffer.allocate(bytes);
                    bitmap.copyPixelsToBuffer((Buffer)buffer);
                    byte[] aiFrame = buffer.array();
                    this.callbacks.doAi(aiFrame);
                }
                this.startTime = start;
            }
            if (this.isTake) {
                Camera.Size size = frame.getCamera().getParameters().getPreviewSize();
                YuvImage image = new YuvImage(frame.getBuffer(), 17, size.width, size.height, null);
                if (image != null) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    image.compressToJpeg(new Rect(0, 0, size.width, size.height), 80, (OutputStream)stream);
                    Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                    Matrix matrix = new Matrix();
                    if (frame.isFlip()) {
                        matrix.postRotate(270.0f);
                    } else {
                        matrix.postRotate((float)frame.getOrientation());
                    }
                    Bitmap nbmp2 = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)matrix, (boolean)true);
                    if (!TextUtils.isEmpty((CharSequence)this.id) && !TextUtils.isEmpty((CharSequence)this.info)) {
                        Bitmap nbmp3 = SYUtils.dealBitmap(nbmp2, this.id, this.info, this.addr, this.longLat, this.textColor);
                        if (this.pictureBack != null) {
                            this.pictureBack.onPictureBitMap(nbmp3);
                        }
                        this.id = null;
                        this.info = null;
                    } else if (this.pictureBack != null) {
                        this.pictureBack.onPictureBitMap(nbmp2);
                    }
                }
                this.isTake = false;
            }
        }
        catch (Exception e) {
            LocalLog.e("inputYUVData  frame\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u76f8\u5e94\u5904\u7406:" + e);
        }
    }

    public void setProfileIop(ProfileIop profileIop) {
        this.rtmpClient.setProfileIop(profileIop);
    }

    @Override
    public void resizeCache(int newSize) throws RuntimeException {
        this.rtmpClient.resizeCache(newSize);
    }

    @Override
    public int getCacheSize() {
        return this.rtmpClient.getCacheSize();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtmpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtmpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtmpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtmpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtmpClient.setAuthorization(user, password);
    }

    public void forceAkamaiTs(boolean enabled) {
        this.rtmpClient.forceAkamaiTs(enabled);
    }

    public void setWriteChunkSize(int chunkSize) {
        if (!this.isStreaming()) {
            this.rtmpClient.setWriteChunkSize(chunkSize);
        }
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.rtmpClient.setFps(this.videoEncoder.getFps());
        this.rtmpClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtmpClient.disconnect();
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
    }

    @Override
    protected boolean shouldRetry(String reason) {
        return this.rtmpClient.shouldRetry(reason);
    }

    @Override
    public void reConnect(long delay, @Nullable String backupUrl) {
        this.rtmpClient.reConnect(delay, backupUrl);
    }

    @Override
    public boolean hasCongestion() {
        return this.rtmpClient.hasCongestion();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtmpClient.sendVideo(h264Buffer, info);
    }

    @Override
    public void setLogs(boolean enable) {
        this.rtmpClient.setLogs(enable);
    }
}

