/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.audio.MicrophoneManagerManual;
import com.pedro.encoder.input.audio.MicrophoneMode;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.GetCameraData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class CameraUsbBase
implements GetAacData,
GetCameraData,
GetVideoData,
GetMicrophoneData {
    private final Context context;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private boolean onPreview = false;
    private boolean audioInitialized = false;
    private final FpsListener fpsListener = new FpsListener();
    private int rotation = 90;
    protected RecordController recordController;
    private GlInterface glInterface;
    private boolean isPreviewing;

    public CameraUsbBase(Context context) {
        this.context = context;
        this.isPreviewing = false;
        this.glInterface = new OffScreenGlThread(context);
        this.glInterface.init();
        this.init();
    }

    @RequiresApi(api=18)
    public CameraUsbBase(OpenGlView openGlView) {
        this.isPreviewing = true;
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init();
    }

    @RequiresApi(api=18)
    public CameraUsbBase(LightOpenGlView lightOpenGlView) {
        this.isPreviewing = true;
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init();
    }

    public void setInputYUVData(byte[] bytes, int rotation, int imageFormat) {
        this.rotation = rotation;
        if (this.streaming) {
            this.inputYUVData(new Frame(bytes, rotation, false, imageFormat));
        }
    }

    private void init() {
        this.videoEncoder = new VideoEncoder(this);
        this.setMicrophoneMode(MicrophoneMode.SYNC);
        this.recordController = new RecordController();
    }

    public void setMicrophoneMode(MicrophoneMode microphoneMode) {
        switch (microphoneMode) {
            case SYNC: {
                this.microphoneManager = new MicrophoneManagerManual();
                this.audioEncoder = new AudioEncoder(this);
                this.audioEncoder.setGetFrame(((MicrophoneManagerManual)this.microphoneManager).getGetFrame());
                break;
            }
            case ASYNC: {
                this.microphoneManager = new MicrophoneManager(this);
                this.audioEncoder = new AudioEncoder(this);
            }
        }
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int avcProfile, int avcProfileLevel) {
        Log.e((String)"TAG", (String)("width===" + width + "---height===" + height + "---fps===" + fps + "---bitrate===" + bitrate + "\nrotation===" + rotation + "--iFrameInterval===" + iFrameInterval + "---avcProfileLevel===" + avcProfileLevel));
        FormatVideoEncoder formatVideoEncoder = this.glInterface == null ? FormatVideoEncoder.YUV420Dynamical : FormatVideoEncoder.SURFACE;
        return this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, formatVideoEncoder, avcProfile, avcProfileLevel);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        return this.prepareVideo(width, height, 30, bitrate, 2, this.rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        Log.e((String)"TAG", (String)("audioSource=====" + audioSource + " bitrate====" + bitrate + " sampleRate=====" + sampleRate + " isStereo=====" + isStereo + " echoCanceler=====" + echoCanceler + " noiseSuppressor=====" + noiseSuppressor));
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.prepareAudioRtp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        return this.prepareVideo(640, 480, 30, 1228800, this.rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, false, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    protected void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.videoEncoder.requestKeyframe();
            } else {
                if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                    this.glInterface.removeMediaCodecSurface();
                }
                this.videoEncoder.reset();
                if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
            }
        }
    }

    private void startEncoders() {
        this.videoEncoder.start();
        if (this.audioInitialized) {
            this.audioEncoder.start();
        }
        this.prepareGlView();
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
        this.onPreview = true;
    }

    private void prepareGlView() {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.glInterface.setRotation(0);
            if (!this.isPreviewing) {
                this.glInterface.start();
            }
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof OffScreenGlThread) {
                    this.glInterface.stop();
                    this.onPreview = false;
                }
            }
            this.videoEncoder.stop();
            if (this.audioInitialized) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
        }
    }

    public void startPreview(int width, int height, boolean isTakePicture) {
        if (isTakePicture || !this.isStreaming() && !this.onPreview && !(this.glInterface instanceof OffScreenGlThread)) {
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                boolean isPortrait = CameraHelper.isPortrait(this.context);
                if (isPortrait) {
                    this.glInterface.setEncoderSize(height, width);
                } else {
                    this.glInterface.setEncoderSize(width, height);
                }
                this.glInterface.setRotation(0);
                this.glInterface.start();
            }
            this.onPreview = true;
        } else {
            Log.e((String)"TAG", (String)"Streaming or preview started, ignored");
        }
    }

    public void stopPreview(boolean isTakePicture) {
        if (isTakePicture || !this.isStreaming() && !this.isRecording() && this.onPreview && !(this.glInterface instanceof OffScreenGlThread)) {
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
                this.glInterface.stop();
            }
            this.onPreview = false;
        } else {
            Log.e((String)"TAG", (String)"Streaming or preview stopped, ignored");
        }
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    protected abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1, @Nullable String var3);

    public abstract boolean hasCongestion();

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    @Override
    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.recordController.recordAudio(aacBuffer, info);
        }
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    @Override
    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.onSpsPpsVpsRtp(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    @Override
    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        if (Build.VERSION.SDK_INT >= 18) {
            this.recordController.recordVideo(h264Buffer, info);
        }
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    @Override
    public void inputPCMData(Frame frame) {
        this.audioEncoder.inputPCMData(frame);
    }

    @Override
    public void inputYUVData(Frame frame) {
        this.videoEncoder.inputYUVData(frame);
    }

    @Override
    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat, !this.audioInitialized);
    }

    @Override
    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat);
    }

    public abstract void setLogs(boolean var1);

    public abstract void setCheckServerAlive(boolean var1);
}

