/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.audio.MicrophoneManagerManual;
import com.pedro.encoder.input.audio.MicrophoneMode;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public abstract class Camera2Base
implements GetAacData,
GetVideoData,
GetMicrophoneData {
    private static final String TAG = "Camera2Base";
    private final Context context;
    private Camera2ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private GlInterface glInterface;
    private boolean audioInitialized = false;
    private boolean onPreview = false;
    private boolean isBackground = false;
    protected RecordController recordController;
    private int previewWidth;
    private int previewHeight;
    private final FpsListener fpsListener = new FpsListener();

    @Deprecated
    public Camera2Base(SurfaceView surfaceView) {
        this.surfaceView = surfaceView;
        this.context = surfaceView.getContext();
        this.init(this.context);
    }

    @Deprecated
    public Camera2Base(TextureView textureView) {
        this.textureView = textureView;
        this.context = textureView.getContext();
        this.init(this.context);
    }

    public Camera2Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(LightOpenGlView lightOpenGlView) {
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(Context context, boolean useOpengl) {
        this.context = context;
        if (useOpengl) {
            this.glInterface = new OffScreenGlThread(context);
            this.glInterface.init();
        }
        this.isBackground = true;
        this.init(context);
    }

    private void init(Context context) {
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder(this);
        this.setMicrophoneMode(MicrophoneMode.ASYNC);
        this.recordController = new RecordController();
    }

    public void setMicrophoneMode(MicrophoneMode microphoneMode) {
        switch (microphoneMode) {
            case SYNC: {
                this.microphoneManager = new MicrophoneManagerManual();
                this.audioEncoder = new AudioEncoder(this);
                this.audioEncoder.setGetFrame(((MicrophoneManagerManual)this.microphoneManager).getGetFrame());
                break;
            }
            case ASYNC: {
                this.microphoneManager = new MicrophoneManager(this);
                this.audioEncoder = new AudioEncoder(this);
            }
        }
    }

    public void setCameraCallbacks(CameraCallbacks callbacks) {
        this.cameraManager.setCameraCallbacks(callbacks);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public boolean enableFaceDetection(Camera2ApiManager.FaceDetectorCallback faceDetectorCallback) {
        return this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean enableVideoStabilization() {
        return this.cameraManager.enableVideoStabilization();
    }

    public void disableVideoStabilization() {
        this.cameraManager.disableVideoStabilization();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.cameraManager.isVideoStabilizationEnabled();
    }

    @Deprecated
    public boolean isFrontCamera() {
        return this.cameraManager.getCameraFacing() == CameraHelper.Facing.FRONT;
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.cameraManager.getCameraFacing();
    }

    public void enableLantern() throws Exception {
        this.cameraManager.enableLantern();
    }

    public void disableLantern() {
        this.cameraManager.disableLantern();
    }

    public boolean isLanternEnabled() {
        return this.cameraManager.isLanternEnabled();
    }

    public boolean isLanternSupported() {
        return this.cameraManager.isLanternSupported();
    }

    public void enableAutoFocus() {
        this.cameraManager.enableAutoFocus();
    }

    public void disableAutoFocus() {
        this.cameraManager.disableAutoFocus();
    }

    public boolean isAutoFocusEnabled() {
        return this.cameraManager.isAutoFocusEnabled();
    }

    public void setFocusDistance(float distance) {
        this.cameraManager.setFocusDistance(distance);
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int avcProfile, int avcProfileLevel) {
        if (this.onPreview && (this.glInterface == null || width != this.previewWidth || height != this.previewHeight)) {
            this.stopPreview();
            this.onPreview = true;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, avcProfile, avcProfileLevel);
        this.prepareCameraManager();
        return result;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        int rotation = CameraHelper.getCameraOrientation(this.context);
        return this.prepareVideo(width, height, 30, bitrate, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.prepareAudioRtp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        int rotation = CameraHelper.getCameraOrientation(this.context);
        return this.prepareVideo(640, 480, 30, 1228800, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    public void replaceView(Context context) {
        this.isBackground = true;
        this.replaceGlInterface(new OffScreenGlThread(context));
    }

    public void replaceView(OpenGlView openGlView) {
        this.isBackground = false;
        this.replaceGlInterface(openGlView);
    }

    public void replaceView(LightOpenGlView lightOpenGlView) {
        this.isBackground = false;
        this.replaceGlInterface(lightOpenGlView);
    }

    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            if (this.isStreaming() || this.isRecording() || this.isOnPreview()) {
                this.cameraManager.closeCamera();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                this.glInterface.init();
                boolean isPortrait = CameraHelper.isPortrait(this.context);
                if (isPortrait) {
                    this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
                } else {
                    this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
                }
                this.glInterface.setRotation(this.videoEncoder.getRotation() == 0 ? 270 : this.videoEncoder.getRotation() - 90);
                this.glInterface.start();
                if (this.isStreaming() || this.isRecording()) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
                this.cameraManager.openLastCamera();
            } else {
                this.glInterface = glInterface;
                this.glInterface.init();
            }
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int rotation) {
        if (!(this.isStreaming() || this.onPreview || this.isBackground)) {
            this.previewWidth = width;
            this.previewHeight = height;
            if (this.surfaceView != null) {
                this.cameraManager.prepareCamera(this.surfaceView.getHolder().getSurface(), this.videoEncoder.getFps());
            } else if (this.textureView != null) {
                this.cameraManager.prepareCamera(new Surface(this.textureView.getSurfaceTexture()), this.videoEncoder.getFps());
            } else if (this.glInterface != null) {
                boolean isPortrait = CameraHelper.isPortrait(this.context);
                if (isPortrait) {
                    this.glInterface.setEncoderSize(height, width);
                } else {
                    this.glInterface.setEncoderSize(width, height);
                }
                this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
                this.glInterface.start();
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), width, height, this.videoEncoder.getFps());
            }
            this.cameraManager.openCameraFacing(cameraFacing);
            this.onPreview = true;
        } else if (!this.isStreaming() && !this.onPreview && this.isBackground) {
            this.cameraManager.setCameraFacing(cameraFacing);
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height) {
        this.startPreview(cameraFacing, width, height, CameraHelper.getCameraOrientation(this.context));
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(cameraFacing, this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(int width, int height) {
        this.startPreview(this.getCameraFacing(), width, height);
    }

    public void startPreview() {
        this.startPreview(this.getCameraFacing());
    }

    public void stopPreview() {
        if (!this.isStreaming() && !this.isRecording() && this.onPreview && !this.isBackground) {
            if (this.glInterface != null) {
                this.glInterface.stop();
            }
            this.cameraManager.closeCamera();
            this.onPreview = false;
            this.previewWidth = 0;
            this.previewHeight = 0;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview stopped, ignored");
        }
    }

    public void startStreamAndRecord(String url, String path, RecordController.Listener listener) throws IOException {
        this.startStream(url);
        this.recordController.startRecord(path, listener);
    }

    public void startStreamAndRecord(String url, String path) throws IOException {
        this.startStreamAndRecord(url, path, null);
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        this.videoEncoder.start();
        if (this.audioInitialized) {
            this.audioEncoder.start();
        }
        this.prepareGlView();
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
        if (this.glInterface == null && !this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
            this.cameraManager.openLastCamera();
        }
        this.onPreview = true;
    }

    protected void requestKeyFrame() {
        this.videoEncoder.requestKeyframe();
    }

    private void prepareGlView() {
        if (this.glInterface != null) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            int rotation = this.videoEncoder.getRotation();
            this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
            if (!this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
                this.glInterface.start();
            }
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            boolean bl = this.onPreview = !this.isBackground;
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof OffScreenGlThread) {
                    this.glInterface.stop();
                    this.cameraManager.closeCamera();
                }
            } else if (this.isBackground) {
                this.cameraManager.closeCamera();
                this.onPreview = false;
            } else {
                this.cameraManager.stopRepeatingEncoder();
            }
            this.videoEncoder.stop();
            if (this.audioInitialized) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
        }
    }

    public boolean reTry(long delay, String reason, @Nullable String backupUrl) {
        boolean result = this.shouldRetry(reason);
        if (result) {
            this.requestKeyFrame();
            this.reConnect(delay, backupUrl);
        }
        return result;
    }

    public boolean reTry(long delay, String reason) {
        return this.reTry(delay, reason, null);
    }

    protected abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1, @Nullable String var3);

    public abstract boolean hasCongestion();

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public List<Size> getResolutionsBack() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsBack());
    }

    public List<Size> getResolutionsFront() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsFront());
    }

    public Range<Integer>[] getSupportedFps() {
        return this.cameraManager.getSupportedFps();
    }

    public CameraCharacteristics getCameraCharacteristics() {
        return this.cameraManager.getCameraCharacteristics();
    }

    public void disableAudio() {
        if (this.audioInitialized) {
            this.microphoneManager.mute();
        }
    }

    public void enableAudio() {
        if (this.audioInitialized) {
            this.microphoneManager.unMute();
        }
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public float getMaxZoom() {
        return this.cameraManager.getMaxZoom();
    }

    public float getZoom() {
        return this.cameraManager.getZoom().floatValue();
    }

    public void setZoom(float level) {
        this.cameraManager.setZoom(level);
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera();
        } else {
            this.cameraManager.setCameraFacing(this.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT);
        }
    }

    public void setExposure(int value) {
        this.cameraManager.setExposure(value);
    }

    public int getExposure() {
        return this.cameraManager.getExposure();
    }

    public int getMaxExposure() {
        return this.cameraManager.getMaxExposure();
    }

    public int getMinExposure() {
        return this.cameraManager.getMinExposure();
    }

    public void tapToFocus(MotionEvent event) {
        this.cameraManager.tapToFocus(event);
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    private void prepareCameraManager() {
        if (this.textureView != null) {
            this.cameraManager.prepareCamera(this.textureView, this.videoEncoder.getInputSurface(), this.videoEncoder.getFps());
        } else if (this.surfaceView != null) {
            this.cameraManager.prepareCamera(this.surfaceView, this.videoEncoder.getInputSurface(), this.videoEncoder.getFps());
        } else if (this.glInterface == null) {
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface(), this.videoEncoder.getFps());
        }
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    @Override
    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.recordController.recordAudio(aacBuffer, info);
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    @Override
    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.onSpsPpsVpsRtp(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    @Override
    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        this.recordController.recordVideo(h264Buffer, info);
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    @Override
    public void inputPCMData(Frame frame) {
        this.audioEncoder.inputPCMData(frame);
    }

    @Override
    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat, !this.audioInitialized);
    }

    @Override
    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat);
    }

    public abstract void setLogs(boolean var1);
}

