/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message.data;

import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/rtmp/rtmp/message/data/Data;", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "name", "", "timeStamp", "", "streamId", "basicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "(Ljava/lang/String;IILcom/pedro/rtmp/rtmp/message/BasicHeader;)V", "bodySize", "data", "", "Lcom/pedro/rtmp/amf/v0/AmfData;", "addData", "", "amfData", "getSize", "readBody", "input", "Ljava/io/InputStream;", "storeBody", "", "toString", "rtmp-stream_debug"})
public abstract class Data
extends RtmpMessage {
    @NotNull
    private final String name;
    @NotNull
    private final List<AmfData> data;
    private int bodySize;

    public Data(@NotNull String name, int timeStamp, int streamId, @NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        super(basicHeader);
        this.name = name;
        this.data = new ArrayList();
        AmfString amfString = new AmfString(this.name);
        this.bodySize += amfString.getSize() + 1;
        Iterable $this$forEach$iv = this.data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmfData it = (AmfData)element$iv;
            boolean bl = false;
            this.bodySize += it.getSize() + 1;
        }
        this.getHeader().setMessageLength(this.bodySize);
        this.getHeader().setTimeStamp(timeStamp);
        this.getHeader().setMessageStreamId(streamId);
    }

    public final void addData(@NotNull AmfData amfData) {
        Intrinsics.checkNotNullParameter((Object)amfData, (String)"amfData");
        this.data.add(amfData);
        this.bodySize += amfData.getSize() + 1;
        this.getHeader().setMessageLength(this.bodySize);
    }

    @Override
    public void readBody(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.bodySize = 0;
        AmfString amfString = new AmfString(null, 1, null);
        amfString.readHeader(input);
        amfString.readBody(input);
        this.bodySize += amfString.getSize() + 1;
        while (this.bodySize < this.getHeader().getMessageLength()) {
            AmfData amfData = AmfData.Companion.getAmfData(input);
            this.data.add(amfData);
            this.bodySize += amfData.getSize() + 1;
        }
    }

    @Override
    @NotNull
    public byte[] storeBody() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AmfString amfString = new AmfString(this.name);
        amfString.writeHeader(byteArrayOutputStream);
        amfString.writeBody(byteArrayOutputStream);
        Iterable $this$forEach$iv = this.data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmfData it = (AmfData)element$iv;
            boolean bl = false;
            it.writeHeader(byteArrayOutputStream);
            it.writeBody(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    @Override
    public int getSize() {
        return this.bodySize;
    }

    @NotNull
    public String toString() {
        return "Data(name='" + this.name + "', data=" + this.data + ", bodySize=" + this.bodySize + ')';
    }
}

