/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtmp.amf.v0.AmfData;
import com.pedro.rtmp.amf.v0.AmfNumber;
import com.pedro.rtmp.amf.v0.AmfObject;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.Handshake;
import com.pedro.rtmp.rtmp.RtmpSender;
import com.pedro.rtmp.rtmp.message.Abort;
import com.pedro.rtmp.rtmp.message.Acknowledgement;
import com.pedro.rtmp.rtmp.message.Aggregate;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.SetPeerBandwidth;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.command.Command;
import com.pedro.rtmp.rtmp.message.control.Type;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.utils.AuthUtil;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtmp.utils.CreateSSLSocket;
import com.pedro.rtmp.utils.RtmpConfig;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00103\u001a\u000204H\u0002J\u001c\u00105\u001a\u0002042\b\u00100\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00106\u001a\u00020\fH\u0007J\u0006\u00107\u001a\u000204J\u0010\u00107\u001a\u0002042\u0006\u00108\u001a\u00020\fH\u0002J\b\u00109\u001a\u00020\fH\u0002J\u000e\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020\fJ\u0018\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0002J\u0010\u0010?\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0002J\u0010\u0010@\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006H\u0002J\b\u0010A\u001a\u000204H\u0002J\b\u0010B\u001a\u000204H\u0002J\u0006\u0010C\u001a\u00020\fJ\u001c\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020\u00132\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010G\u001a\u000204J\u0006\u0010H\u001a\u000204J\u0006\u0010I\u001a\u000204J\u0006\u0010J\u001a\u000204J\u000e\u0010K\u001a\u0002042\u0006\u0010L\u001a\u00020\bJ\u0016\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u0016\u0010R\u001a\u0002042\u0006\u0010S\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u0016\u0010T\u001a\u0002042\u0006\u0010U\u001a\u00020\b2\u0006\u0010V\u001a\u00020\fJ\u001a\u0010W\u001a\u0002042\b\u0010X\u001a\u0004\u0018\u00010\u00062\b\u0010Y\u001a\u0004\u0018\u00010\u0006J\u000e\u0010Z\u001a\u0002042\u0006\u0010;\u001a\u00020\fJ\u000e\u0010[\u001a\u0002042\u0006\u0010\\\u001a\u00020\bJ\u000e\u0010]\u001a\u0002042\u0006\u0010^\u001a\u00020\fJ\u000e\u0010_\u001a\u0002042\u0006\u0010`\u001a\u00020\fJ\u000e\u0010a\u001a\u0002042\u0006\u0010b\u001a\u00020\fJ\u000e\u0010c\u001a\u0002042\u0006\u0010d\u001a\u00020eJ\u000e\u0010f\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\bJ \u0010g\u001a\u0002042\u0006\u0010h\u001a\u00020O2\u0006\u0010i\u001a\u00020O2\b\u0010j\u001a\u0004\u0018\u00010OJ\u0016\u0010k\u001a\u0002042\u0006\u0010l\u001a\u00020\b2\u0006\u0010m\u001a\u00020\bJ\u000e\u0010n\u001a\u0002042\u0006\u0010o\u001a\u00020\bJ\u000e\u0010p\u001a\u00020\f2\u0006\u0010q\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0015R\u0011\u0010+\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0015R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpClient;", "", "connectCheckerRtmp", "Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;", "(Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "checkServerAlive", "", "commandsManager", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "connectionSocket", "Ljava/net/Socket;", "doingRetry", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "handler", "Ljava/util/concurrent/ScheduledExecutorService;", "<set-?>", "isStreaming", "()Z", "numRetry", "publishPermitted", "reTries", "reader", "Ljava/io/BufferedInputStream;", "rtmpSender", "Lcom/pedro/rtmp/rtmp/RtmpSender;", "rtmpUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "runnable", "Ljava/lang/Runnable;", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "thread", "Ljava/util/concurrent/ExecutorService;", "tlsEnabled", "url", "writer", "Ljava/io/OutputStream;", "closeConnection", "", "connect", "isRetry", "disconnect", "clear", "establishConnection", "forceAkamaiTs", "enabled", "getAppName", "app", "name", "getStreamName", "getTcUrl", "handleMessages", "handleServerPackets", "hasCongestion", "reConnect", "delay", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setAuthorization", "user", "password", "setCheckServerAlive", "setFps", "fps", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setProfileIop", "profileIop", "Lcom/pedro/rtmp/flv/video/ProfileIop;", "setReTries", "setVideoInfo", "sps", "pps", "vps", "setVideoResolution", "width", "height", "setWriteChunkSize", "chunkSize", "shouldRetry", "reason", "rtmp-stream_debug"})
public final class RtmpClient {
    @NotNull
    private final ConnectCheckerRtmp connectCheckerRtmp;
    @NotNull
    private final String TAG;
    private final Pattern rtmpUrlPattern;
    @Nullable
    private Socket connectionSocket;
    @Nullable
    private BufferedInputStream reader;
    @Nullable
    private OutputStream writer;
    @Nullable
    private ExecutorService thread;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private final RtmpSender rtmpSender;
    private volatile boolean isStreaming;
    @Nullable
    private String url;
    private boolean tlsEnabled;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;
    @Nullable
    private ScheduledExecutorService handler;
    @Nullable
    private Runnable runnable;
    private boolean publishPermitted;
    private boolean checkServerAlive;

    public RtmpClient(@NotNull ConnectCheckerRtmp connectCheckerRtmp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.TAG = "RtmpClient";
        this.rtmpUrlPattern = Pattern.compile("^rtmps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
        this.commandsManager = new CommandsManager();
        this.rtmpSender = new RtmpSender(this.connectCheckerRtmp, this.commandsManager);
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.rtmpSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.rtmpSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.rtmpSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.rtmpSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.rtmpSender.getSentVideoFrames();
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        this.commandsManager.setAudioDisabled(false);
        this.commandsManager.setVideoDisabled(onlyAudio);
    }

    public final void setOnlyVideo(boolean onlyVideo) {
        this.commandsManager.setVideoDisabled(false);
        this.commandsManager.setAudioDisabled(onlyVideo);
    }

    public final void forceAkamaiTs(boolean enabled) {
        this.commandsManager.setAkamaiTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        RtmpConfig.INSTANCE.setWriteChunkSize(chunkSize);
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        this.commandsManager.setAuth(user, password);
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.commandsManager.setAudioInfo(sampleRate, isStereo);
        this.rtmpSender.setAudioInfo(sampleRate, isStereo);
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.rtmpSender.setVideoInfo(sps, pps, vps);
    }

    public final void setProfileIop(@NotNull ProfileIop profileIop) {
        Intrinsics.checkNotNullParameter((Object)((Object)profileIop), (String)"profileIop");
        this.rtmpSender.setProfileIop(profileIop);
    }

    public final void setVideoResolution(int width, int height) {
        this.commandsManager.setVideoResolution(width, height);
    }

    public final void setFps(int fps) {
        this.commandsManager.setFps(fps);
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        if (!isRetry) {
            this.doingRetry = true;
        }
        if (url == null) {
            this.isStreaming = false;
            this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
            return;
        }
        if (!this.isStreaming || isRetry) {
            String string2;
            int n;
            String portStr;
            String string3;
            this.url = url;
            this.connectCheckerRtmp.onConnectionStartedRtmp(url);
            Matcher rtmpMatcher = this.rtmpUrlPattern.matcher(url);
            if (rtmpMatcher.matches()) {
                string3 = rtmpMatcher.group(0);
                if (string3 == null) {
                    string3 = "";
                }
            } else {
                this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
                return;
            }
            this.tlsEnabled = StringsKt.startsWith$default((String)string3, (String)"rtmps", (boolean)false, (int)2, null);
            String string4 = rtmpMatcher.group(1);
            if (string4 == null) {
                string4 = "";
            }
            this.commandsManager.setHost(string4);
            String string5 = portStr = rtmpMatcher.group(2);
            this.commandsManager.setPort(string5 == null ? 1935 : (n = Integer.parseInt(string5)));
            String string6 = rtmpMatcher.group(3);
            if (string6 == null) {
                string6 = "";
            }
            if ((string2 = rtmpMatcher.group(4)) == null) {
                string2 = "";
            }
            this.commandsManager.setAppName(this.getAppName(string6, string2));
            String string7 = rtmpMatcher.group(4);
            if (string7 == null) {
                string7 = "";
            }
            this.commandsManager.setStreamName(this.getStreamName(string7));
            string5 = rtmpMatcher.group(0);
            String string8 = rtmpMatcher.group(0);
            String string9 = (string5 == null ? "" : string5).substring(0, (string8 == null ? "" : string8).length() - this.commandsManager.getStreamName().length());
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.commandsManager.setTcUrl(this.getTcUrl(string9));
            this.isStreaming = true;
            ExecutorService executorService = this.thread = Executors.newSingleThreadExecutor();
            if (executorService != null) {
                executorService.execute(() -> RtmpClient.connect$lambda-0(this));
            }
        }
    }

    public static /* synthetic */ void connect$default(RtmpClient rtmpClient, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rtmpClient.connect(string2, bl);
    }

    private final void handleServerPackets() {
        while (!Thread.interrupted()) {
            try {
                this.handleMessages();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final String getAppName(String app, String name) {
        String string2;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string2 = app;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(app).append('/');
            String string3 = name.substring(0, StringsKt.indexOf$default((CharSequence)name, (String)"/", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string2 = stringBuilder.append(string3).toString();
        }
        return string2;
    }

    private final String getStreamName(String name) {
        String string2;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string2 = name;
        } else {
            String string3 = name.substring(StringsKt.indexOf$default((CharSequence)name, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            string2 = string3;
        }
        return string2;
    }

    private final String getTcUrl(String url) {
        String string2;
        if (StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
            String string3 = url.substring(0, url.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string2 = string3;
        } else {
            string2 = url;
        }
        return string2;
    }

    private final boolean establishConnection() throws IOException {
        Socket socket = null;
        if (!this.tlsEnabled) {
            socket = new Socket();
            SocketAddress socketAddress = new InetSocketAddress(this.commandsManager.getHost(), this.commandsManager.getPort());
            socket.connect(socketAddress, 5000);
        } else {
            Socket socket2 = CreateSSLSocket.createSSlSocket(this.commandsManager.getHost(), this.commandsManager.getPort());
            if (socket2 == null) {
                throw new IOException("Socket creation failed");
            }
            socket = socket2;
        }
        socket.setSoTimeout(5000);
        BufferedInputStream reader = new BufferedInputStream(socket.getInputStream());
        OutputStream writer = socket.getOutputStream();
        long timestamp = System.currentTimeMillis() / (long)1000;
        Handshake handshake = new Handshake();
        InputStream inputStream = reader;
        Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
        if (!handshake.sendHandshake(inputStream, writer)) {
            return false;
        }
        this.commandsManager.setTimestamp((int)timestamp);
        this.commandsManager.setStartTs(System.nanoTime() / (long)1000);
        this.connectionSocket = socket;
        this.reader = reader;
        this.writer = writer;
        return true;
    }

    private final void handleMessages() throws IOException {
        BufferedInputStream bufferedInputStream = this.reader;
        if (bufferedInputStream == null) {
            throw new IOException("Invalid reader, Connection failed");
        }
        BufferedInputStream reader = bufferedInputStream;
        OutputStream outputStream = this.writer;
        if (outputStream == null) {
            throw new IOException("Invalid writer, Connection failed");
        }
        OutputStream writer = outputStream;
        RtmpMessage message = this.commandsManager.readMessageResponse(reader);
        block3 : switch (WhenMappings.$EnumSwitchMapping$0[message.getType().ordinal()]) {
            case 1: {
                SetChunkSize setChunkSize = (SetChunkSize)message;
                this.commandsManager.setReadChunkSize(setChunkSize.getChunkSize());
                Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"chunk size configured to ", (Object)setChunkSize.getChunkSize()));
                break;
            }
            case 2: {
                Acknowledgement setChunkSize = (Acknowledgement)message;
                break;
            }
            case 3: {
                WindowAcknowledgementSize windowAcknowledgementSize = (WindowAcknowledgementSize)message;
                RtmpConfig.INSTANCE.setAcknowledgementWindowSize(windowAcknowledgementSize.getAcknowledgementWindowSize());
                break;
            }
            case 4: {
                SetPeerBandwidth setPeerBandwidth = (SetPeerBandwidth)message;
                this.commandsManager.sendWindowAcknowledgementSize(writer);
                break;
            }
            case 5: {
                Abort setPeerBandwidth = (Abort)message;
                break;
            }
            case 6: {
                Aggregate setPeerBandwidth = (Aggregate)message;
                break;
            }
            case 7: {
                UserControl userControl = (UserControl)message;
                Type type = userControl.getType();
                if (WhenMappings.$EnumSwitchMapping$1[type.ordinal()] == 1) {
                    this.commandsManager.sendPong(userControl.getEvent(), writer);
                    break;
                }
                Log.i((String)this.TAG, (String)("user control command " + (Object)((Object)type) + " ignored"));
                break;
            }
            case 8: 
            case 9: {
                Command command = (Command)message;
                String commandName = this.commandsManager.getSessionHistory().getName(command.getCommandId());
                switch (command.getName()) {
                    case "_result": {
                        String string2;
                        String string3 = commandName;
                        if (Intrinsics.areEqual((Object)string3, (Object)"connect")) {
                            if (this.commandsManager.getOnAuth()) {
                                this.connectCheckerRtmp.onAuthSuccessRtmp();
                                this.commandsManager.setOnAuth(false);
                            }
                            this.commandsManager.createStream(writer);
                        } else if (Intrinsics.areEqual((Object)string3, (Object)"createStream")) {
                            try {
                                this.commandsManager.setStreamId((int)((AmfNumber)command.getData().get(3)).getValue());
                                this.commandsManager.sendPublish(writer);
                            }
                            catch (ClassCastException e) {
                                Log.e((String)this.TAG, (String)"error parsing _result createStream", (Throwable)e);
                            }
                        }
                        if ((string2 = commandName) == null) {
                            string2 = "unknown command";
                        }
                        Log.i((String)this.TAG, (String)Intrinsics.stringPlus((String)"success response received from ", (Object)string2));
                        break block3;
                    }
                    case "_error": {
                        try {
                            AmfData amfData = ((AmfObject)command.getData().get(3)).getProperty("description");
                            if (amfData == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.pedro.rtmp.amf.v0.AmfString");
                            }
                            String description = ((AmfString)amfData).getValue();
                            if (Intrinsics.areEqual((Object)commandName, (Object)"connect")) {
                                if (StringsKt.contains$default((CharSequence)description, (CharSequence)"reason=authfail", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)description, (CharSequence)"reason=nosuchuser", (boolean)false, (int)2, null)) {
                                    this.connectCheckerRtmp.onAuthErrorRtmp();
                                    break block3;
                                }
                                if (this.commandsManager.getUser() != null && this.commandsManager.getPassword() != null && StringsKt.contains$default((CharSequence)description, (CharSequence)"challenge=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)description, (CharSequence)"salt=", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)description, (CharSequence)"nonce=", (boolean)false, (int)2, null)) {
                                    this.closeConnection();
                                    this.establishConnection();
                                    OutputStream outputStream2 = this.writer;
                                    if (outputStream2 == null) {
                                        throw new IOException("Invalid writer, Connection failed");
                                    }
                                    writer = outputStream2;
                                    this.commandsManager.setOnAuth(true);
                                    if (StringsKt.contains$default((CharSequence)description, (CharSequence)"challenge=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)description, (CharSequence)"salt=", (boolean)false, (int)2, null)) {
                                        String salt = AuthUtil.INSTANCE.getSalt(description);
                                        String challenge = AuthUtil.INSTANCE.getChallenge(description);
                                        String opaque = AuthUtil.INSTANCE.getOpaque(description);
                                        String string4 = this.commandsManager.getUser();
                                        String string5 = string4 == null ? "" : string4;
                                        String string6 = this.commandsManager.getPassword();
                                        if (string6 == null) {
                                            string6 = "";
                                        }
                                        this.commandsManager.sendConnect(AuthUtil.INSTANCE.getAdobeAuthUserResult(string5, string6, salt, challenge, opaque), writer);
                                        break block3;
                                    }
                                    if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"nonce=", (boolean)false, (int)2, null)) break block3;
                                    String nonce = AuthUtil.INSTANCE.getNonce(description);
                                    String string7 = this.commandsManager.getUser();
                                    String string8 = string7 == null ? "" : string7;
                                    String string9 = this.commandsManager.getPassword();
                                    if (string9 == null) {
                                        string9 = "";
                                    }
                                    this.commandsManager.sendConnect(AuthUtil.INSTANCE.getLlnwAuthUserResult(string8, string9, nonce, this.commandsManager.getAppName()), writer);
                                    break block3;
                                }
                                if (StringsKt.contains$default((CharSequence)description, (CharSequence)"code=403", (boolean)false, (int)2, null)) {
                                    if (StringsKt.contains$default((CharSequence)description, (CharSequence)"authmod=adobe", (boolean)false, (int)2, null)) {
                                        this.closeConnection();
                                        this.establishConnection();
                                        OutputStream outputStream3 = this.writer;
                                        if (outputStream3 == null) {
                                            throw new IOException("Invalid writer, Connection failed");
                                        }
                                        writer = outputStream3;
                                        Log.i((String)this.TAG, (String)"sending auth mode adobe");
                                        this.commandsManager.sendConnect(Intrinsics.stringPlus((String)"?authmod=adobe&user=", (Object)this.commandsManager.getUser()), writer);
                                        break block3;
                                    }
                                    if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"authmod=llnw", (boolean)false, (int)2, null)) break block3;
                                    Log.i((String)this.TAG, (String)"sending auth mode llnw");
                                    this.commandsManager.sendConnect(Intrinsics.stringPlus((String)"?authmod=llnw&user=", (Object)this.commandsManager.getUser()), writer);
                                    break block3;
                                }
                                this.connectCheckerRtmp.onAuthErrorRtmp();
                                break block3;
                            }
                            this.connectCheckerRtmp.onConnectionFailedRtmp(description);
                        }
                        catch (ClassCastException e) {
                            Log.e((String)this.TAG, (String)"error parsing _error command", (Throwable)e);
                        }
                        break block3;
                    }
                    case "onStatus": {
                        try {
                            String code;
                            AmfData amfData = ((AmfObject)command.getData().get(3)).getProperty("code");
                            if (amfData == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.pedro.rtmp.amf.v0.AmfString");
                            }
                            switch (((AmfString)amfData).getValue()) {
                                case "NetStream.Publish.Start": {
                                    this.commandsManager.sendMetadata(writer);
                                    this.connectCheckerRtmp.onConnectionSuccessRtmp();
                                    this.rtmpSender.setOutput(writer);
                                    this.rtmpSender.start();
                                    this.publishPermitted = true;
                                    break block3;
                                }
                                case "NetStream.Publish.BadName": 
                                case "NetConnection.Connect.Rejected": {
                                    this.connectCheckerRtmp.onConnectionFailedRtmp(Intrinsics.stringPlus((String)"onStatus: ", (Object)code));
                                    break block3;
                                }
                            }
                            StringBuilder stringBuilder = new StringBuilder().append("onStatus ").append(code).append(" response received from ");
                            String string10 = commandName;
                            if (string10 == null) {
                                string10 = "unknown command";
                            }
                            Log.i((String)this.TAG, (String)stringBuilder.append(string10).toString());
                        }
                        catch (ClassCastException e) {
                            Log.e((String)this.TAG, (String)"error parsing onStatus command", (Throwable)e);
                        }
                        break block3;
                    }
                }
                StringBuilder stringBuilder = new StringBuilder().append("unknown ").append(command.getName()).append(" response received from ");
                String string11 = commandName;
                if (string11 == null) {
                    string11 = "unknown command";
                }
                Log.i((String)this.TAG, (String)stringBuilder.append(string11).toString());
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                Log.e((String)this.TAG, (String)("unimplemented response for " + (Object)((Object)message.getType()) + ". Ignored"));
            }
        }
    }

    private final void closeConnection() {
        Socket socket = this.connectionSocket;
        if (socket != null) {
            socket.close();
        }
        this.commandsManager.reset();
    }

    @JvmOverloads
    public final void reConnect(long delay, @Nullable String backupUrl) {
        int n = this.reTries;
        this.reTries = n + -1;
        this.disconnect(false);
        Runnable runnable = this.runnable = () -> RtmpClient.reConnect$lambda-1(backupUrl, this);
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            ScheduledExecutorService scheduledExecutorService = this.handler = Executors.newSingleThreadScheduledExecutor();
            if (scheduledExecutorService != null) {
                scheduledExecutorService.schedule(it, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static /* synthetic */ void reConnect$default(RtmpClient rtmpClient, long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        rtmpClient.reConnect(l, string2);
    }

    public final void disconnect() {
        Runnable runnable = this.runnable;
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            ScheduledExecutorService scheduledExecutorService = this.handler;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        this.disconnect(true);
    }

    private final void disconnect(boolean clear) {
        if (this.isStreaming) {
            this.rtmpSender.stop(clear);
        }
        ExecutorService executorService = this.thread;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> RtmpClient.disconnect$lambda-5(this));
        try {
            ExecutorService executorService2;
            executor.shutdownNow();
            executor.awaitTermination(200L, TimeUnit.MILLISECONDS);
            ExecutorService executorService3 = executorService2 = this.thread;
            if (executorService3 != null) {
                executorService3.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            this.thread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clear) {
            this.reTries = this.numRetry;
            this.doingRetry = false;
            this.isStreaming = false;
            this.connectCheckerRtmp.onDisconnectRtmp();
        }
        this.publishPermitted = false;
        this.commandsManager.reset();
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getVideoDisabled()) {
            this.rtmpSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getAudioDisabled()) {
            this.rtmpSender.sendAudioFrame(aacBuffer, info);
        }
    }

    public final boolean hasCongestion() {
        return this.rtmpSender.hasCongestion();
    }

    public final void resetSentAudioFrames() {
        this.rtmpSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.rtmpSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.rtmpSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.rtmpSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.rtmpSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.rtmpSender.setLogs(enable);
    }

    public final void setCheckServerAlive(boolean enabled) {
        this.checkServerAlive = enabled;
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        RtmpClient.connect$default(this, url, false, 2, null);
    }

    @JvmOverloads
    public final void reConnect(long delay) {
        RtmpClient.reConnect$default(this, delay, null, 2, null);
    }

    private static final void connect$lambda-0(RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (!this$0.establishConnection()) {
                this$0.connectCheckerRtmp.onConnectionFailedRtmp("Handshake failed");
                return;
            }
            OutputStream outputStream = this$0.writer;
            if (outputStream == null) {
                throw new IOException("Invalid writer, Connection failed");
            }
            OutputStream writer = outputStream;
            this$0.commandsManager.sendChunkSize(writer);
            this$0.commandsManager.sendConnect("", writer);
            while (!Thread.interrupted() && !this$0.publishPermitted) {
                this$0.handleMessages();
            }
            this$0.handleServerPackets();
        }
        catch (Exception e) {
            Log.e((String)this$0.TAG, (String)"connection error", (Throwable)e);
            this$0.connectCheckerRtmp.onConnectionFailedRtmp(Intrinsics.stringPlus((String)"Error configure stream, ", (Object)e.getMessage()));
            return;
        }
    }

    private static final void reConnect$lambda-1(String $backupUrl, RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string2 = $backupUrl;
        if (string2 == null) {
            string2 = this$0.url;
        }
        String reconnectUrl = string2;
        this$0.connect(reconnectUrl, true);
    }

    private static final void disconnect$lambda-5(RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            OutputStream outputStream = this$0.writer;
            if (outputStream != null) {
                OutputStream writer = outputStream;
                boolean bl = false;
                this$0.commandsManager.sendClose(writer);
            }
            BufferedInputStream bufferedInputStream = this$0.reader;
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            this$0.reader = null;
            OutputStream outputStream2 = this$0.writer;
            if (outputStream2 != null) {
                outputStream2.close();
            }
            this$0.writer = null;
            this$0.closeConnection();
        }
        catch (IOException e) {
            Log.e((String)this$0.TAG, (String)"disconnect error", (Throwable)e);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MessageType.values().length];
            nArray[MessageType.SET_CHUNK_SIZE.ordinal()] = 1;
            nArray[MessageType.ACKNOWLEDGEMENT.ordinal()] = 2;
            nArray[MessageType.WINDOW_ACKNOWLEDGEMENT_SIZE.ordinal()] = 3;
            nArray[MessageType.SET_PEER_BANDWIDTH.ordinal()] = 4;
            nArray[MessageType.ABORT.ordinal()] = 5;
            nArray[MessageType.AGGREGATE.ordinal()] = 6;
            nArray[MessageType.USER_CONTROL.ordinal()] = 7;
            nArray[MessageType.COMMAND_AMF0.ordinal()] = 8;
            nArray[MessageType.COMMAND_AMF3.ordinal()] = 9;
            nArray[MessageType.VIDEO.ordinal()] = 10;
            nArray[MessageType.AUDIO.ordinal()] = 11;
            nArray[MessageType.DATA_AMF0.ordinal()] = 12;
            nArray[MessageType.DATA_AMF3.ordinal()] = 13;
            nArray[MessageType.SHARED_OBJECT_AMF0.ordinal()] = 14;
            nArray[MessageType.SHARED_OBJECT_AMF3.ordinal()] = 15;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Type.values().length];
            nArray[Type.PING_REQUEST.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

