/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.flv.video;

import com.pedro.rtmp.flv.video.ProfileIop;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pedro/rtmp/flv/video/VideoSpecificConfig;", "", "sps", "", "pps", "profileIop", "Lcom/pedro/rtmp/flv/video/ProfileIop;", "([B[BLcom/pedro/rtmp/flv/video/ProfileIop;)V", "size", "", "getSize", "()I", "setSize", "(I)V", "calculateSize", "write", "", "buffer", "offset", "rtmp-stream_debug"})
public final class VideoSpecificConfig {
    @NotNull
    private final byte[] sps;
    @NotNull
    private final byte[] pps;
    @NotNull
    private final ProfileIop profileIop;
    private int size;

    public VideoSpecificConfig(@NotNull byte[] sps, @NotNull byte[] pps, @NotNull ProfileIop profileIop) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)((Object)profileIop), (String)"profileIop");
        this.sps = sps;
        this.pps = pps;
        this.profileIop = profileIop;
        this.size = this.calculateSize(this.sps, this.pps);
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final void write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer data = ByteBuffer.wrap(buffer, offset, this.size);
        data.put((byte)1);
        byte profileIdc = this.sps[1];
        data.put(profileIdc);
        data.put(this.profileIop.getValue());
        byte levelIdc = this.sps[3];
        data.put(levelIdc);
        data.put((byte)-1);
        data.put((byte)-31);
        data.putShort((short)this.sps.length);
        data.put(this.sps);
        data.put((byte)1);
        data.putShort((short)this.pps.length);
        data.put(this.pps);
    }

    private final int calculateSize(byte[] sps, byte[] pps) {
        return 8 + sps.length + 3 + pps.length;
    }
}

