/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.util.Log;
import com.pedro.encoder.input.gl.render.filters.object.TextTimeFilterRender;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextStreamObject
extends StreamObjectBase {
    private static final String TAG = "TextStreamObject";
    private int numFrames;
    private Bitmap imageBitmap;

    @Override
    public int getWidth() {
        return this.imageBitmap != null ? this.imageBitmap.getWidth() : 0;
    }

    @Override
    public int getHeight() {
        return this.imageBitmap != null ? this.imageBitmap.getHeight() : 0;
    }

    public void load(String text, float textSize, int textColor, Typeface typeface) {
        this.numFrames = 1;
        this.imageBitmap = this.textAsBitmap(text, textSize, textColor, typeface);
        Log.i((String)TAG, (String)"finish load text");
    }

    public void load(String text, int textSize, String textColor, String bgColor, int padding) {
        this.numFrames = 1;
        this.imageBitmap = this.text2Bitmap(text, textSize, textColor, bgColor, padding);
    }

    public void load(String info, String id, int textSize, String textColor, String bgColor, int padding) {
        this.numFrames = 1;
        this.imageBitmap = this.capLeftText2Bitmap(info, id, textSize, textColor, bgColor, padding);
    }

    public void load(String name, String register, String id, int textSize, String textColor, String bgColor, int padding) {
        this.numFrames = 1;
        this.imageBitmap = this.leftText2Bitmap(name, register, id, textSize, textColor, bgColor, padding);
    }

    public void load(TextTimeFilterRender.RightBean rightBean, int textSize, String textColor, String bgColor, int padding) {
        this.numFrames = 1;
        this.imageBitmap = this.rightText2Bitmap(rightBean, textSize, textColor, bgColor, padding);
    }

    @Override
    public void recycle() {
        if (this.imageBitmap != null) {
            this.imageBitmap.recycle();
        }
    }

    private Bitmap textAsBitmap(String text, float textSize, int textColor, Typeface typeface) {
        Paint paint = new Paint(1);
        paint.setTextSize(textSize);
        paint.setColor(textColor);
        paint.setAlpha(255);
        if (typeface != null) {
            paint.setTypeface(typeface);
        }
        paint.setTextAlign(Paint.Align.LEFT);
        float baseline = -paint.ascent();
        int width = (int)(paint.measureText(text) + 0.5f);
        int height = (int)(baseline + paint.descent() + 0.5f);
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        canvas.drawText(text, 0.0f, baseline, paint);
        return image;
    }

    public Bitmap text2Bitmap(String text, int textSize, String textColor, String bgColor, int padding) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)textColor));
        paint.setTextSize((float)textSize);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        float width = paint.measureText(text, 0, text.length());
        float top = paint.getFontMetrics().top;
        float bottom = paint.getFontMetrics().bottom;
        Bitmap bm = Bitmap.createBitmap((int)((int)(width + (float)(padding * 2))), (int)((int)(bottom - top + (float)(padding * 2))), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bm);
        canvas.drawColor(Color.parseColor((String)bgColor));
        canvas.drawText(text, (float)padding, -top + (float)padding, paint);
        return bm;
    }

    public Bitmap capLeftText2Bitmap(String info, String id, int textSize, String textColor, String bgColor, int padding) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)textColor));
        paint.setTextSize((float)textSize);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        id = "\u7f16\u53f7\uff1a" + id;
        info = "\u4fe1\u606f\uff1a" + info;
        String time = "\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        int length = Math.max(Math.max(info.length(), id.length()), time.length());
        String text = length == info.length() ? info : (length == id.length() ? id : time);
        float width = paint.measureText(text, 0, text.length());
        float top = paint.getFontMetrics().top;
        float bottom = paint.getFontMetrics().bottom;
        Bitmap bm = Bitmap.createBitmap((int)((int)(width + (float)(padding * 2))), (int)((int)(bottom - top) * 3 + padding * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bm);
        canvas.drawColor(Color.parseColor((String)bgColor));
        canvas.drawText(time, (float)padding, (float)((int)(bottom - top) * 1), paint);
        canvas.drawText(id, (float)padding, (float)((int)(bottom - top) * 2), paint);
        canvas.drawText(info, (float)padding, (float)((int)(bottom - top) * 3), paint);
        return bm;
    }

    public Bitmap leftText2Bitmap(String name, String register, String id, int textSize, String textColor, String bgColor, int padding) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)textColor));
        paint.setTextSize((float)textSize);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        String time = "\u65f6\t\t\t\t\t\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        int l1 = Math.max(name.length() + TextStreamObject.getChineseCount(name), register.length() + TextStreamObject.getChineseCount(register));
        int l2 = Math.max(id.length() + TextStreamObject.getChineseCount(id), time.length() + TextStreamObject.getChineseCount(time));
        int length = Math.max(l1, l2);
        String text = length == time.length() + TextStreamObject.getChineseCount(time) ? time : (length == register.length() + TextStreamObject.getChineseCount(register) ? register : (length == id.length() + TextStreamObject.getChineseCount(id) ? id : name));
        float width = paint.measureText(text, 0, text.length());
        float top = paint.getFontMetrics().top;
        float bottom = paint.getFontMetrics().bottom;
        Bitmap bm = Bitmap.createBitmap((int)((int)(width + (float)(padding * 2))), (int)((int)(bottom - top) * 4 + padding * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bm);
        canvas.drawColor(Color.parseColor((String)bgColor));
        canvas.drawText(register, (float)padding, (float)((int)(bottom - top) * 1), paint);
        canvas.drawText(id, (float)padding, (float)((int)(bottom - top) * 2), paint);
        canvas.drawText(name, (float)padding, (float)((int)(bottom - top) * 3), paint);
        canvas.drawText(time, (float)padding, (float)((int)(bottom - top) * 4), paint);
        return bm;
    }

    public Bitmap rightText2Bitmap(TextTimeFilterRender.RightBean rightBean, int textSize, String textColor, String bgColor, int padding) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)textColor));
        paint.setTextSize((float)textSize);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        float width = paint.measureText(rightBean.getMaxLengthString(), 0, rightBean.getMaxLengthString().length());
        float top = paint.getFontMetrics().top;
        float bottom = paint.getFontMetrics().bottom;
        Bitmap bm = Bitmap.createBitmap((int)((int)(width + (float)(padding * 2))), (int)((int)(bottom - top) * 9 + padding * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bm);
        canvas.drawColor(Color.parseColor((String)bgColor));
        canvas.drawText(rightBean.floor, (float)padding, (float)((int)(bottom - top) * 1), paint);
        canvas.drawText(rightBean.direction, (float)padding, (float)((int)(bottom - top) * 2), paint);
        canvas.drawText(rightBean.speed, (float)padding, (float)((int)(bottom - top) * 3), paint);
        canvas.drawText(rightBean.isDoorOpen, (float)padding, (float)((int)(bottom - top) * 4), paint);
        canvas.drawText(rightBean.isPerson, (float)padding, (float)((int)(bottom - top) * 5), paint);
        canvas.drawText(rightBean.isCar, (float)padding, (float)((int)(bottom - top) * 6), paint);
        canvas.drawText(rightBean.signal, (float)padding, (float)((int)(bottom - top) * 7), paint);
        canvas.drawText(rightBean.electric, (float)padding, (float)((int)(bottom - top) * 8), paint);
        canvas.drawText(rightBean.temperature, (float)padding, (float)((int)(bottom - top) * 9), paint);
        return bm;
    }

    public static int getChineseCount(String content) {
        int count = 0;
        String regEx = "[\u4e00-\u9fa5]";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public Bitmap[] getBitmaps() {
        return new Bitmap[]{this.imageBitmap};
    }

    @Override
    public int updateFrame() {
        return 0;
    }
}

