/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SYUtils {
    public static Bitmap dealBitmap(Bitmap bitmapAll, String id, String info, String addr, String longLat, String textColor) {
        int space;
        int x;
        int y;
        float textSise;
        if (bitmapAll.getHeight() <= 480) {
            textSise = 18.0f;
            y = bitmapAll.getHeight() - 10;
            x = 5;
            space = 22;
        } else if (bitmapAll.getHeight() <= 720 && bitmapAll.getHeight() >= 480) {
            textSise = 32.0f;
            y = bitmapAll.getHeight() - 20;
            x = 10;
            space = 44;
        } else if (bitmapAll.getHeight() <= 1080 && bitmapAll.getHeight() >= 720) {
            textSise = 48.0f;
            y = bitmapAll.getHeight() - 30;
            x = 15;
            space = 66;
        } else {
            textSise = 60.0f;
            y = bitmapAll.getHeight() - 40;
            x = 20;
            space = 88;
        }
        Log.e((String)"TAG", (String)("dealBitmap: " + textSise + "   getHeight:" + bitmapAll.getHeight() + "     y:" + y + "    space:" + space + "     getWidth:" + bitmapAll.getWidth()));
        Bitmap bitmapAllNew = bitmapAll.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(bitmapAllNew);
        Paint paint = new Paint(1);
        paint.setColor(Color.parseColor((String)textColor));
        paint.setTextSize(textSise);
        canvas.drawText("\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), (float)x, (float)(y - space * 4), paint);
        canvas.drawText("\u7f16\u53f7\uff1a" + id, (float)x, (float)(y - space * 3), paint);
        canvas.drawText(info, (float)x, (float)(y - space * 2), paint);
        canvas.drawText(longLat, (float)x, (float)(y - space), paint);
        canvas.drawText(addr, (float)x, (float)y, paint);
        return bitmapAllNew;
    }

    public static byte[] dealByte(Bitmap bitmapAll) {
        Bitmap bitmapAllNew = bitmapAll.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(bitmapAllNew);
        Paint paint = new Paint(1);
        paint.setColor(-1);
        paint.setTextSize(40.0f);
        long a = System.currentTimeMillis();
        String b = "\u81ea\u5b9a\u4e49\u6c34\u5370";
        canvas.drawText("\u65f6\u95f4\u6233\uff1a" + a, 100.0f, 100.0f, paint);
        canvas.drawText(b, 100.0f, 300.0f, paint);
        byte[] newBytes = SYUtils.bitmapToNv21(bitmapAllNew, 640, 480);
        if (newBytes != null) {
            return newBytes;
        }
        return null;
    }

    private static byte[] bitmapToNv21(Bitmap src, int width, int height) {
        if (src != null && src.getWidth() >= width && src.getHeight() >= height) {
            int[] argb = new int[width * height];
            src.getPixels(argb, 0, width, 0, 0, width, height);
            return SYUtils.argbToNv21(argb, width, height);
        }
        return null;
    }

    private static byte[] argbToNv21(int[] argb, int width, int height) {
        int frameSize = width * height;
        int yIndex = 0;
        int uvIndex = frameSize;
        int index = 0;
        byte[] nv21 = new byte[width * height * 3 / 2];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int R2 = (argb[index] & 0xFF0000) >> 16;
                int G = (argb[index] & 0xFF00) >> 8;
                int B = argb[index] & 0xFF;
                int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                int U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                int V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                nv21[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 == 0 && index % 2 == 0 && uvIndex < nv21.length - 2) {
                    nv21[uvIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
                    nv21[uvIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                }
                ++index;
            }
        }
        return nv21;
    }
}

