/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters.object;

import android.opengl.GLES20;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.filters.object.BaseObjectFilterRender;
import com.pedro.encoder.utils.gl.TextStreamObject;
import java.text.SimpleDateFormat;
import java.util.Date;

@RequiresApi(api=18)
public class TextTimeFilterRender
extends BaseObjectFilterRender {
    private String text1 = "";
    private String leftText = "";
    private int textSize;
    private String textColor;
    private String bgColor;
    private int padding;
    private boolean isAutoUpdate;
    private boolean isLeft = false;
    private String name;
    private String register;
    private String id;
    private boolean isCapLeft = false;
    private String capInfo;
    private String capId;
    private String capOldStr = "";
    private String mRightBeanStr = "";
    private long start = 0L;

    public TextTimeFilterRender() {
        this.streamObject = new TextStreamObject();
    }

    @Override
    protected void drawFilter() {
        super.drawFilter();
        GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[0]);
        GLES20.glUniform1f((int)this.uAlphaHandle, (float)(this.streamObjectTextureId[0] == -1 ? 0.0f : this.alpha));
        if (this.isAutoUpdate && System.currentTimeMillis() - this.start > 1000L) {
            this.start = System.currentTimeMillis();
            ((TextStreamObject)this.streamObject).load(new SimpleDateFormat("yyyy-MM-dd EEEE HH:mm:ss").format(new Date()), this.textSize, this.textColor, this.bgColor, this.padding);
            this.shouldLoad = true;
        }
        if (this.isLeft && System.currentTimeMillis() - this.start > 1000L) {
            this.start = System.currentTimeMillis();
            ((TextStreamObject)this.streamObject).load(this.name, this.register, this.id, this.textSize, this.textColor, this.bgColor, this.padding);
            this.shouldLoad = true;
        }
        if (this.isCapLeft && System.currentTimeMillis() - this.start > 1000L) {
            this.start = System.currentTimeMillis();
            ((TextStreamObject)this.streamObject).load(this.capInfo, this.capId, this.textSize, this.textColor, this.bgColor, this.padding);
            this.shouldLoad = true;
        }
    }

    public void setText(String text, int textSize, String textColor, String bgColor, int padding, boolean isTime) {
        if (isTime) {
            this.text1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        } else if (text.equals(this.text1)) {
            return;
        }
        this.text1 = text;
        this.textSize = textSize;
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.padding = padding;
        this.isAutoUpdate = isTime;
        ((TextStreamObject)this.streamObject).load(this.text1, textSize, textColor, bgColor, padding);
        this.shouldLoad = true;
    }

    public void setCapLeftText(String info, String id, int textSize, String textColor, String bgColor, int padding) {
        if (this.capOldStr.equals(info + id)) {
            return;
        }
        this.textSize = textSize;
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.padding = padding;
        this.capOldStr = info + id;
        this.capId = id;
        this.capInfo = info;
        this.isCapLeft = true;
        ((TextStreamObject)this.streamObject).load(info, id, textSize, textColor, bgColor, padding);
        this.shouldLoad = true;
    }

    public void setLeftText(String name, String register, String id, int textSize, String textColor, String bgColor, int padding) {
        if (this.leftText.equals(name + register + id)) {
            return;
        }
        this.textSize = textSize;
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.padding = padding;
        this.leftText = name + register + id;
        this.name = name;
        this.register = register;
        this.id = id;
        this.isLeft = true;
        ((TextStreamObject)this.streamObject).load(name, register, id, textSize, textColor, bgColor, padding);
        this.shouldLoad = true;
    }

    public void setRightBean(RightBean rightBean, int textSize, String textColor, String bgColor, int padding) {
        if (this.mRightBeanStr.equals(rightBean.floor + rightBean.direction + rightBean.speed + rightBean.isDoorOpen + rightBean.isPerson + rightBean.isCar + rightBean.signal + rightBean.electric + rightBean.temperature)) {
            return;
        }
        this.mRightBeanStr = rightBean.floor + rightBean.direction + rightBean.speed + rightBean.isDoorOpen + rightBean.isPerson + rightBean.isCar + rightBean.signal + rightBean.electric + rightBean.temperature;
        this.textSize = textSize;
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.padding = padding;
        ((TextStreamObject)this.streamObject).load(rightBean, textSize, textColor, bgColor, padding);
        this.shouldLoad = true;
    }

    public static class RightBean {
        public String floor;
        public String direction;
        public String speed;
        public String isDoorOpen;
        public String isPerson;
        public String isCar;
        public String signal;
        public String electric;
        public String temperature;

        public String getMaxLengthString() {
            String[] strs = new String[]{this.floor, this.direction, this.speed, this.isDoorOpen, this.isPerson, this.isCar, this.signal, this.electric, this.temperature};
            for (int i = 0; i < strs.length - 1; ++i) {
                for (int j = 0; j < strs.length - 1; ++j) {
                    if (TextUtils.isEmpty((CharSequence)strs[j]) || strs[j].length() <= strs[j + 1].length()) continue;
                    String temp = strs[j + 1];
                    strs[j + 1] = strs[j];
                    strs[j] = temp;
                }
            }
            return strs[strs.length - 1];
        }
    }
}

