/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.yunianvh.libusbcamera.R;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RequiresApi(api=18)
public class HalftoneLinesFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uResolutionHandle = -1;
    private int uModeHandle = -1;
    private int uRowsHandle = -1;
    private int uRotationHandle = -1;
    private int uAntialiasHandle = -1;
    private int uSampleDistHandle = -1;
    private float mode = 1.0f;
    private float rows = 40.0f;
    private float rotation = 0.0f;
    private float antialias = 0.2f;
    private float[] sampleDist = new float[]{2.0f, 2.0f};

    public HalftoneLinesFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.halftone_lines_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uResolutionHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uResolution");
        this.uModeHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMode");
        this.uRowsHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uRows");
        this.uRotationHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uRotation");
        this.uAntialiasHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uAntialias");
        this.uSampleDistHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampleDist");
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform2f((int)this.uResolutionHandle, (float)this.getWidth(), (float)this.getHeight());
        GLES20.glUniform1f((int)this.uModeHandle, (float)this.mode);
        GLES20.glUniform1f((int)this.uRowsHandle, (float)this.rows);
        GLES20.glUniform1f((int)this.uRotationHandle, (float)this.rotation);
        GLES20.glUniform1f((int)this.uAntialiasHandle, (float)this.antialias);
        GLES20.glUniform2f((int)this.uSampleDistHandle, (float)this.sampleDist[0], (float)this.sampleDist[1]);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)4);
        GLES20.glActiveTexture((int)33988);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public float getMode() {
        return this.mode;
    }

    public float getRows() {
        return this.rows;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getAntialias() {
        return this.antialias;
    }

    public float[] getSampleDist() {
        return this.sampleDist;
    }

    public void setMode(int mode) {
        this.mode = mode < 1 ? 1.0f : (mode > 7 ? 7.0f : (float)mode);
    }

    public void setRows(float rows) {
        this.rows = rows;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setAntialias(float antialias) {
        this.antialias = antialias;
    }

    public void setSampleDist(float[] sampleDist) {
        this.sampleDist = sampleDist;
    }
}

