/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.content.res.Resources;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.yunianvh.libusbcamera.R;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RequiresApi(api=18)
public class ColorFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uColorHandle = -1;
    private static final String HEX_PATTERN = "^#([A-Fa-f0-9]{6})$";
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 1.0f;

    public ColorFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.color_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uColorHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uColor");
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform3f((int)this.uColorHandle, (float)this.red, (float)this.green, (float)this.blue);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)4);
        GLES20.glActiveTexture((int)33988);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setRGBColor(String rgbHexColor) {
        Pattern pattern = Pattern.compile(HEX_PATTERN);
        Matcher matcher = pattern.matcher(rgbHexColor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid hexColor pattern (Should be: ^#([A-Fa-f0-9]{6})$)");
        }
        int r = Integer.valueOf(rgbHexColor.substring(1, 3), 16);
        int g = Integer.valueOf(rgbHexColor.substring(3, 5), 16);
        int b = Integer.valueOf(rgbHexColor.substring(5, 7), 16);
        this.red = (float)r / 255.0f;
        this.green = (float)g / 255.0f;
        this.blue = (float)b / 255.0f;
    }

    public void setRGBColor(int r, int g, int b) {
        this.red = (float)r / 255.0f;
        this.green = (float)g / 255.0f;
        this.blue = (float)b / 255.0f;
    }

    public void setColor(Resources resources, int colorResource) {
        String color = resources.getString(colorResource);
        this.setRGBColor("#" + color.substring(3));
    }
}

