/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.opengl.GLES20;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public abstract class BaseRenderOffScreen {
    protected FloatBuffer squareVertex;
    public static final int FLOAT_SIZE_BYTES = 4;
    public static final int SQUARE_VERTEX_DATA_STRIDE_BYTES = 20;
    public static final int SQUARE_VERTEX_DATA_POS_OFFSET = 0;
    public static final int SQUARE_VERTEX_DATA_UV_OFFSET = 3;
    protected float[] MVPMatrix = new float[16];
    protected float[] STMatrix = new float[16];
    protected RenderHandler renderHandler = new RenderHandler();
    protected int width;
    protected int height;

    public abstract void initGl(int var1, int var2, Context var3, int var4, int var5);

    public abstract void draw();

    public abstract void release();

    public int getTexId() {
        return this.renderHandler.getTexId()[0];
    }

    protected void initFBO(int width, int height) {
        this.initFBO(width, height, this.renderHandler.getFboId(), this.renderHandler.getRboId(), this.renderHandler.getTexId());
    }

    protected void initFBO(int width, int height, int[] fboId, int[] rboId, int[] texId) {
        GlUtil.checkGlError("initFBO_S");
        GLES20.glGenFramebuffers((int)1, (int[])fboId, (int)0);
        GLES20.glGenRenderbuffers((int)1, (int[])rboId, (int)0);
        GLES20.glGenTextures((int)1, (int[])texId, (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)rboId[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
        GLES20.glBindFramebuffer((int)36160, (int)fboId[0]);
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rboId[0]);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)texId[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texId[0], (int)0);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("FrameBuffer uncompleted code: " + status);
        }
        GlUtil.checkGlError("initFBO_E");
    }
}

