/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.filters.AndroidViewFilterRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.object.BaseObjectFilterRender;
import com.pedro.encoder.input.video.CameraHelper;

@RequiresApi(api=18)
public class SpriteGestureController {
    private BaseObjectFilterRender baseObjectFilterRender;
    private AndroidViewFilterRender androidViewFilterRender;
    private float lastDistance;
    private boolean preventMoveOutside = true;

    public SpriteGestureController() {
    }

    public SpriteGestureController(BaseObjectFilterRender sprite) {
        this.baseObjectFilterRender = sprite;
    }

    public SpriteGestureController(AndroidViewFilterRender sprite) {
        this.androidViewFilterRender = sprite;
    }

    public BaseFilterRender getFilterRender() {
        return this.androidViewFilterRender == null ? this.baseObjectFilterRender : this.androidViewFilterRender;
    }

    public void setBaseObjectFilterRender(BaseObjectFilterRender baseObjectFilterRender) {
        this.baseObjectFilterRender = baseObjectFilterRender;
        this.androidViewFilterRender = null;
    }

    public void setBaseObjectFilterRender(AndroidViewFilterRender androidViewFilterRender) {
        this.androidViewFilterRender = androidViewFilterRender;
        this.baseObjectFilterRender = null;
    }

    public void stopListener() {
        this.androidViewFilterRender = null;
        this.baseObjectFilterRender = null;
    }

    public void setPreventMoveOutside(boolean preventMoveOutside) {
        this.preventMoveOutside = preventMoveOutside;
    }

    public boolean spriteTouched(View view, MotionEvent motionEvent) {
        PointF position;
        PointF scale;
        if (this.baseObjectFilterRender == null && this.androidViewFilterRender == null) {
            return false;
        }
        float xPercent = motionEvent.getX() * 100.0f / (float)view.getWidth();
        float yPercent = motionEvent.getY() * 100.0f / (float)view.getHeight();
        if (this.baseObjectFilterRender != null) {
            scale = this.baseObjectFilterRender.getScale();
            position = this.baseObjectFilterRender.getPosition();
        } else {
            scale = this.androidViewFilterRender.getScale();
            position = this.androidViewFilterRender.getPosition();
        }
        boolean xTouched = xPercent >= position.x && xPercent <= position.x + scale.x;
        boolean yTouched = yPercent >= position.y && yPercent <= position.y + scale.y;
        return xTouched && yTouched;
    }

    public void moveSprite(View view, MotionEvent motionEvent) {
        if (this.baseObjectFilterRender == null && this.androidViewFilterRender == null) {
            return;
        }
        if (motionEvent.getPointerCount() == 1) {
            float xPercent = motionEvent.getX() * 100.0f / (float)view.getWidth();
            float yPercent = motionEvent.getY() * 100.0f / (float)view.getHeight();
            PointF scale = this.baseObjectFilterRender != null ? this.baseObjectFilterRender.getScale() : this.androidViewFilterRender.getScale();
            if (this.preventMoveOutside) {
                float x = xPercent - scale.x / 2.0f;
                float y = yPercent - scale.y / 2.0f;
                if (x < 0.0f) {
                    x = 0.0f;
                }
                if (x + scale.x > 100.0f) {
                    x = 100.0f - scale.x;
                }
                if (y < 0.0f) {
                    y = 0.0f;
                }
                if (y + scale.y > 100.0f) {
                    y = 100.0f - scale.y;
                }
                if (this.baseObjectFilterRender != null) {
                    this.baseObjectFilterRender.setPosition(x, y);
                } else {
                    this.androidViewFilterRender.setPosition(x, y);
                }
            } else if (this.baseObjectFilterRender != null) {
                this.baseObjectFilterRender.setPosition(xPercent - scale.x / 2.0f, yPercent - scale.y / 2.0f);
            } else {
                this.androidViewFilterRender.setPosition(xPercent - scale.x / 2.0f, yPercent - scale.y / 2.0f);
            }
        }
    }

    public void scaleSprite(MotionEvent motionEvent) {
        if (this.baseObjectFilterRender == null && this.androidViewFilterRender == null) {
            return;
        }
        if (motionEvent.getPointerCount() > 1) {
            float distance = CameraHelper.getFingerSpacing(motionEvent);
            float percent = distance >= this.lastDistance ? 1.0f : -1.0f;
            PointF scale = this.baseObjectFilterRender != null ? this.baseObjectFilterRender.getScale() : this.androidViewFilterRender.getScale();
            scale.x += percent;
            scale.y += percent;
            if (this.baseObjectFilterRender != null) {
                this.baseObjectFilterRender.setScale(scale.x, scale.y);
            } else {
                this.androidViewFilterRender.setScale(scale.x, scale.y);
            }
            this.lastDistance = distance;
        }
    }
}

