/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.xml;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XmlDocument {
    private File currentFile;
    private Document document;

    public static XmlDocument readFile(File file) throws DocumentException {
        return new XmlDocument(file);
    }

    public static XmlDocument newDocument() throws DocumentException {
        return new XmlDocument(null);
    }

    public static Element element(String name, String content) {
        Element element = DocumentFactory.getInstance().createElement(name);
        element.setText(content);
        return element;
    }

    private XmlDocument(File file) throws DocumentException {
        this.currentFile = file;
        this.document = new SAXReader().read(file);
    }

    public Document getDocument() {
        return this.document;
    }

    public List<Element> selectElements(String xpath) {
        return this.document.selectNodes(xpath).stream().filter(node -> node instanceof Element).map(node -> (Element)node).collect(Collectors.toList());
    }

    public Element selectSingleElement(String xpath) {
        return this.document.selectNodes(xpath).stream().filter(node -> node instanceof Element).map(node -> (Element)node).findFirst().orElse(null);
    }

    public void addOrReplaceChildElement(Element parent, String childName, String childContent) {
        List nodes = parent.content();
        int found = -1;
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (!Objects.equals(node.getName(), childName)) continue;
            found = i;
            break;
        }
        Element element = XmlDocument.element(childName, childContent);
        if (found > -1) {
            nodes.remove(found);
            nodes.add(found, element);
        } else {
            nodes.add(element);
        }
    }

    public void save() throws IOException {
        this.save(this.currentFile);
    }

    public void save(File file) throws IOException {
        if (file != null) {
            Charset charset = Charset.forName(StringUtils.defaultString((String)this.document.getXMLEncoding(), (String)"UTF-8"));
            Files.write(file.toPath(), this.document.asXML().getBytes(charset), new OpenOption[0]);
        }
    }
}

