/*
 * Decompiled with CFR 0.152.
 */
package com.xwintop.xcore.util.javafx;

import com.xwintop.xcore.util.javafx.GetScreenUtil;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;
import org.controlsfx.tools.Utils;

public class TooltipUtil {
    public static void showToast(String message) {
        TooltipUtil.showToast((Node)null, message);
    }

    public static void showToast(Node node, String message) {
        Window window = Utils.getWindow((Object)node);
        double x = 0.0;
        double y = 0.0;
        if (node != null) {
            x = GetScreenUtil.getScreenX(node) + GetScreenUtil.getWidth(node) / 2.0;
            y = GetScreenUtil.getScreenY(node) + GetScreenUtil.getHeight(node);
        } else {
            x = window.getX() + window.getWidth() / 2.0;
            y = window.getY() + window.getHeight();
        }
        TooltipUtil.showToast(window, message, 3000L, x, y);
    }

    public static void showToast(Window window, String message, long time, double x, double y) {
        final Tooltip tooltip = new Tooltip(message);
        tooltip.setAutoHide(true);
        tooltip.setOpacity(0.9);
        tooltip.setWrapText(true);
        tooltip.show(window, x, y);
        tooltip.setAnchorX(tooltip.getAnchorX() - tooltip.getWidth() / 2.0);
        tooltip.setAnchorY(tooltip.getAnchorY() - tooltip.getHeight());
        if (time > 0L) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater(() -> tooltip.hide());
                }
            }, time);
        }
    }

    public static void showToast(String message, Pos pos) {
        TooltipUtil.showToast(null, message, null, 3.0, pos, null, null, true, true);
    }

    public static void showToast(String title, String message) {
        TooltipUtil.showToast(title, message, null, 3.0, Pos.BOTTOM_CENTER, null, null, true, true);
    }

    public static void showToast(String title, String message, Pos pos) {
        TooltipUtil.showToast(title, message, null, 3.0, pos, null, null, true, true);
    }

    public static void showToast(String title, String message, Node graphic, double hideTime, Pos pos, EventHandler<ActionEvent> onAction, Object owner, boolean isHideCloseButton, boolean isDarkStyle) {
        Notifications notificationBuilder = Notifications.create().title(title).text(message).graphic(graphic).hideAfter(Duration.seconds((double)hideTime)).position(pos).onAction(onAction);
        if (owner != null) {
            notificationBuilder.owner(owner);
        }
        if (isHideCloseButton) {
            notificationBuilder.hideCloseButton();
        }
        if (isDarkStyle) {
            notificationBuilder.darkStyle();
        }
        Platform.runLater(() -> notificationBuilder.show());
    }
}

